/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.microdata;

import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.URIs;

public class MicrodataBuilder {
    private final URI baseUri;
    private Stack<MicrodataItem> context = new Stack();
    private List<MicrodataItem> rootItems = new ArrayList<MicrodataItem>();

    private MicrodataBuilder(URI baseUri) {
        this.baseUri = baseUri;
    }

    public MicrodataBuilder enter(String type, String id, String ... names) {
        MicrodataItem item = null;
        if (NullOrEmpty.nullOrEmpty((Object[])names)) {
            item = new MicrodataItem(type, id);
            this.rootItems.add(item);
        } else {
            item = this.current().enter(type, id, names);
        }
        this.context.push(item);
        return this;
    }

    public MicrodataBuilder exit() {
        this.context.pop();
        return this;
    }

    public List<MicrodataItem> items() {
        return this.rootItems;
    }

    public MicrodataBuilder text(String text, String ... names) {
        this.current().text(text, names);
        return this;
    }

    public MicrodataBuilder timestamp(String timestamp, String ... names) {
        this.current().timestamp(timestamp, names);
        return this;
    }

    public MicrodataBuilder uri(String uri, String ... names) {
        this.current().uri(uri, names);
        return this;
    }

    private MicrodataItem current() {
        if (this.context.isEmpty()) {
            throw new IllegalStateException("No microdata context");
        }
        return this.context.peek();
    }

    public static MicrodataBuilder microdata(URI baseUri) {
        return new MicrodataBuilder(baseUri);
    }

    final class MicrodataValue {
        private final Kind kind;
        private final List<Object> values = new ArrayList<Object>();

        public String toString() {
            return this.values.toString();
        }

        private MicrodataValue(Kind kind) {
            this.kind = kind;
        }

        public List<MicrodataItem> items() {
            return this.values;
        }

        public Kind kind() {
            return this.kind;
        }

        public List<String> values() {
            return this.values;
        }

        void values(Object ... values) {
            for (Object value : values) {
                this.values.add(value);
            }
        }
    }

    public final class MicrodataItem {
        private final String id;
        private final String type;
        private final Map<String, MicrodataValue> values = new LinkedHashMap<String, MicrodataValue>();

        public String toString() {
            StringBuilder b = new StringBuilder("{");
            if (this.type != null) {
                b.append(this.type);
                b.append(",");
            }
            if (this.id != null) {
                b.append(this.id);
                b.append(",");
            }
            b.append(this.values.toString());
            b.append("}");
            return b.toString();
        }

        private MicrodataItem(String type, String id) {
            this.type = type;
            this.id = id;
        }

        public String id() {
            return this.id;
        }

        public Set<String> propertyNames() {
            return this.values.keySet();
        }

        public String type() {
            return this.type;
        }

        public MicrodataValue value(String property) {
            return this.values.get(property);
        }

        MicrodataItem enter(String type, String id, String ... names) {
            MicrodataItem item = new MicrodataItem(type, id);
            for (String name : names) {
                MicrodataValue existing = this.values.get(name);
                if (existing == null) {
                    existing = new MicrodataValue(Kind.ITEM);
                    this.values.put(name, existing);
                }
                existing.values(item);
            }
            return item;
        }

        void text(String text, String ... names) {
            for (String name : names) {
                MicrodataValue existing = this.values.get(name);
                if (existing == null) {
                    existing = new MicrodataValue(Kind.TEXT);
                    this.values.put(name, existing);
                }
                existing.values(text);
            }
        }

        void timestamp(String timestamp, String ... names) {
            for (String name : names) {
                MicrodataValue existing = this.values.get(name);
                if (existing == null) {
                    existing = new MicrodataValue(Kind.TIMESTAMP);
                    this.values.put(name, existing);
                }
                existing.values(timestamp);
            }
        }

        void uri(String uri, String ... names) {
            for (String name : names) {
                MicrodataValue existing = this.values.get(name);
                if (existing == null) {
                    existing = new MicrodataValue(Kind.URI);
                    this.values.put(name, existing);
                }
                String absoluteUri = URIs.resolve((URI)MicrodataBuilder.this.baseUri, (String)uri).toString();
                existing.values(absoluteUri);
            }
        }
    }

    public static enum Kind {
        ITEM,
        ROOT,
        TEXT,
        TIMESTAMP,
        URI;

    }
}

