/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.json.xml;

import java.io.IOException;
import java.io.InputStream;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.entity.EntityHeaders;
import oracle.dbtools.rt.entity.EntityHeadersBuilder;
import oracle.dbtools.rt.json.xml.XMLToJSON;
import oracle.dbtools.rt.transcode.Transcoders;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.ContentTypes;
import oracle.dbtools.rt.web.ReTargetingDispatcher;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.ResourceDispatcher;

@Service(provides={ResourceDispatcher.class})
public class JSONDispatcher
extends ReTargetingDispatcher<ReTargetingDispatcher.Target> {
    @Reference
    private Transcoders transcoders;

    @Override
    protected EntityHeaders modifyRequestHeaders(ReTargetingDispatcher.Target target, RequestEntity request) {
        return this.prefer(ContentTypes.JSON_TYPES);
    }

    @Override
    protected Entity modifyRequestBody(ReTargetingDispatcher.Target target, RequestEntity modifiedRequestHeaders, InputStream originalRequestBody) throws IOException {
        Entity newRequest = Entities.entity(originalRequestBody, modifiedRequestHeaders.headers());
        newRequest = this.transcoders.transform(this.prefer(newRequest, target.documentBase(), ContentTypes.XML_TYPES));
        return newRequest;
    }

    @Override
    protected Entity modifyResponse(ReTargetingDispatcher.Target target, Entity response) throws IOException {
        return this.transcoders.transform(this.prefer(response, target.documentBase(), ContentTypes.JSON_TYPES));
    }

    @Override
    protected ReTargetingDispatcher.Target target(RequestEntity request) {
        String match = XMLToJSON.match(request.path());
        if (match == null) {
            return null;
        }
        return new ReTargetingDispatcher.Target(match);
    }

    private EntityHeaders prefer(ContentType ... preferred) {
        EntityHeadersBuilder preferedHeaders = Entities.headers();
        CharSequence[] types = new CharSequence[preferred.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = preferred[i];
        }
        preferedHeaders.header((CharSequence)"X-APEX-PREFERRED-CONTENT-TYPE", types);
        return preferedHeaders.build();
    }

    private Entity prefer(Entity entity, String docBase, ContentType ... preferred) {
        return Entities.merge(entity, this.prefer(preferred));
    }
}

