/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.jdbc.entity;

import java.security.Principal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.common.jdbc.ConnectionPoolException;
import oracle.dbtools.common.jdbc.JDBCCall;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.jdbc.JDBCException;
import oracle.dbtools.common.query.QueryProvider;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.stmt.ParameterAccess;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.common.stmt.jdbc.BindableCallResults;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.Reflections;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.rt.home.ExistingEntity;
import oracle.dbtools.rt.home.StoreMode;
import oracle.dbtools.rt.home.tenants.TenantEntity;
import oracle.dbtools.rt.home.tenants.TenantEntityStorage;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.jdbc.entity.JDBCEntityMetaData;
import oracle.dbtools.rt.jdbc.entity.JDBCEntityStatementBuilder;
import oracle.dbtools.rt.jdbc.entity.JDBCIdentifiers;
import oracle.dbtools.rt.resource.templates.jdbc.ApexListenerJDBCPrincipal;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

public class JDBCEntityProviderBase<T extends TenantEntity>
implements ExistingEntity<T>,
TenantEntityStorage<T> {
    private final Statement childIds;
    private final Statement delete;
    private final Statement deleteChildIds;
    private final Statement entities;
    private final Statement entityById;
    private final Statement entityByNaturalKey;
    private final Statement insert;
    @Reference
    private JDBCCallProvider jdbc;
    private final JDBCEntityMetaData<T> metadata;
    @Reference
    private QueryProvider queryProvider;
    private final Statement update;
    private static final Transform<ResultRow, TenantIdentifier> AS_PK = new Transform<ResultRow, TenantIdentifier>(){

        public TenantIdentifier apply(ResultRow x) {
            return JDBCIdentifiers.valueOf(x, 2, 1);
        }
    };

    protected JDBCEntityProviderBase(JDBCEntityMetaData<T> metadata) {
        this.metadata = metadata;
        JDBCEntityMetaData.Table table = metadata.table();
        this.delete = JDBCEntityStatementBuilder.call().delete(table);
        this.insert = JDBCEntityStatementBuilder.call().insert(table);
        this.update = JDBCEntityStatementBuilder.call().update(table);
        this.entityById = JDBCEntityStatementBuilder.query().entity(table);
        this.entities = JDBCEntityStatementBuilder.query().entities(table);
        JDBCEntityMetaData<?> childEntity = metadata.childEntity();
        if (childEntity == null) {
            this.childIds = null;
            this.deleteChildIds = null;
        } else {
            this.childIds = this.childIds(metadata);
            this.deleteChildIds = this.deleteChildIds(metadata);
        }
        JDBCEntityMetaData.Column naturalKey = table.naturalKey();
        this.entityByNaturalKey = naturalKey == null ? null : this.entityByNaturalKey(table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<TenantIdentifier> childIds(Transaction txn, CompoundPrincipal principal, TenantIdentifier id) {
        if (this.childIds == null) {
            return Collections.emptyList();
        }
        ArrayList<TenantIdentifier> results = new ArrayList<TenantIdentifier>();
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            JDBCIdentifiers.bind(parameters, principal, id, "parent_id");
            this.creator(parameters, principal);
            Iterator<ResultRow> matches = null;
            try {
                matches = this.query(txn, this.childIds, parameters);
                Iterators.add(results, (Iterator)Iterators.transform(matches, AS_PK));
            }
            finally {
                Closeables.close(matches);
            }
        }
        catch (ConnectionPoolException e) {
            return null;
        }
        return results;
    }

    @Override
    public void delete(Transaction txn, CompoundPrincipal principal, TenantIdentifier id) {
        JDBCCall delete = null;
        try {
            JDBCEntityProviderBase.verifyTenant(principal, id, true);
            this.deleted(txn, principal, id);
            delete = this.jdbc().call(txn, this.delete);
            HashMap<String, Object> params = new HashMap<String, Object>();
            JDBCIdentifiers.bind(params, principal, id);
            this.creator(params, principal);
            delete.bind(params);
            delete.execute();
        }
        catch (SQLException e) {
            try {
                throw WebException.internalError(e, new Reason[0]);
            }
            catch (Throwable throwable) {
                Closeables.close(delete);
                throw throwable;
            }
        }
        Closeables.close((Object)delete);
    }

    /*
     * Loose catch block
     */
    @Override
    public void deleteChildren(Transaction txn, CompoundPrincipal principal, TenantIdentifier entityId) {
        if (this.childIds != null) {
            JDBCCall delete = null;
            try {
                JDBCEntityProviderBase.verifyTenant(principal, entityId, true);
                delete = this.jdbc().call(txn, this.deleteChildIds);
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                JDBCIdentifiers.bind(parameters, principal, entityId, "parent_id");
                this.creator(parameters, principal);
                delete.bind(parameters);
                delete.execute();
            }
            catch (ConnectionPoolException e) {
                Closeables.close(delete);
            }
            catch (SQLException e2) {
                throw WebException.internalError(e2, new Reason[0]);
                {
                    catch (Throwable throwable) {
                        Closeables.close(delete);
                        throw throwable;
                    }
                }
            }
            Closeables.close((Object)delete);
        }
    }

    @Override
    public Iterable<T> entities(Transaction txn, CompoundPrincipal principal) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        this.creator(parameters, principal);
        return this.entities(txn, principal, this.entities, parameters);
    }

    @Override
    public T entity(Transaction txn, CompoundPrincipal principal, TenantIdentifier entityId) {
        try {
            JDBCEntityProviderBase.verifyTenant(principal, entityId, false);
            return this.entity(principal, this.entityById, JDBCIdentifiers.entityId(entityId), "id");
        }
        catch (ConnectionPoolException e) {
            return null;
        }
    }

    @Override
    public T exists(Transaction txn, CompoundPrincipal principal, T instance) {
        try {
            if (this.hasNaturalKey()) {
                return this.entity(principal, this.entityByNaturalKey, this.naturalKeys(instance));
            }
            if (instance.id() != null) {
                return this.entity(txn, principal, (TenantIdentifier)instance.id());
            }
            return null;
        }
        catch (ConnectionPoolException e) {
            return null;
        }
    }

    @Override
    public Transaction newTransaction(CompoundPrincipal principal) {
        CompoundPrincipal apexListener = ApexListenerJDBCPrincipal.apexListener(principal);
        return this._newTransaction(apexListener);
    }

    @Override
    public T store(StoreMode storeMode, Transaction txn, CompoundPrincipal principal, T instance) {
        try {
            if (StoreMode.CREATE == storeMode) {
                return this.create(txn, principal, instance);
            }
            if (StoreMode.UPDATE == storeMode) {
                return this.update(txn, principal, instance);
            }
            return this.upsert(txn, principal, instance);
        }
        catch (SQLException e) {
            throw WebException.internalError(e, new Reason[0]);
        }
    }

    protected void creator(Map<String, Object> parameters, CompoundPrincipal principal) {
        if (principal != null && principal.getName() != null) {
            String user = principal.getName().toUpperCase();
            parameters.put("created_by", user);
        }
    }

    protected void deleted(Transaction txn, CompoundPrincipal principal, TenantIdentifier id) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterable<T> entities(Transaction txn, CompoundPrincipal principal, Statement stmt, Map<String, Object> parameters) {
        ArrayList results = new ArrayList();
        try {
            JDBCIdentifiers.bind(parameters, principal);
            Iterator<ResultRow> matches = null;
            try {
                matches = this.query(txn, stmt, parameters);
                Iterators.add(results, (Iterator)Iterators.transform(matches, this.metadata().reader()));
            }
            finally {
                Closeables.close(matches);
            }
        }
        catch (ConnectionPoolException e) {
            return null;
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T entity(CompoundPrincipal principal, Statement stmt, Map<String, Object> expected) {
        CompoundPrincipal apexListener = ApexListenerJDBCPrincipal.apexListener(principal);
        TenantEntity existing = null;
        Transaction txn = null;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.putAll(expected);
        JDBCIdentifiers.bind(parameters, principal);
        this.creator(parameters, principal);
        Iterator<ResultRow> matches = null;
        try {
            txn = this.newTransaction(apexListener);
            matches = this.query(txn, stmt, parameters);
            existing = (TenantEntity)Iterators.nextOrNull((Iterator)Iterators.transform(matches, this.asEntity()));
            if (existing != null) {
                existing = this.retrieved(txn, principal, existing);
            }
        }
        catch (Throwable throwable) {
            Closeables.close((Object[])new Object[]{matches, txn});
            throw throwable;
        }
        Closeables.close((Object[])new Object[]{matches, txn});
        return (T)existing;
    }

    protected T entity(CompoundPrincipal principal, Statement stmt, Object expected, String column) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(column, expected);
        return this.entity(principal, stmt, parameters);
    }

    protected T inserted(Transaction txn, CompoundPrincipal principal, T instance) {
        return instance;
    }

    protected JDBCCallProvider jdbc() {
        return this.jdbc;
    }

    protected JDBCEntityMetaData<T> metadata() {
        return this.metadata;
    }

    protected Iterator<ResultRow> query(Transaction txn, Statement stmt, Map<String, Object> parameters) {
        return this.queryProvider.query(txn, stmt, parameters, false);
    }

    protected QueryProvider queryProvider() {
        return this.queryProvider;
    }

    protected T retrieved(Transaction txn, CompoundPrincipal principal, T existing) {
        return existing;
    }

    protected T updated(Transaction txn, CompoundPrincipal principal, T instance) {
        return instance;
    }

    T upsert(Transaction txn, CompoundPrincipal principal, T instance) throws SQLException {
        if (instance.id() == null) {
            return this.create(txn, principal, instance);
        }
        try {
            return this.update(txn, principal, instance);
        }
        catch (SQLException e) {
            return this.create(txn, principal, instance);
        }
    }

    private Transaction _newTransaction(CompoundPrincipal apexListener) {
        try {
            return this.jdbc().transaction((Principal)apexListener);
        }
        catch (SQLException e) {
            throw JDBCException.wrap((SQLException)e);
        }
    }

    private JDBCEntityMetaData.JDBCEntityReader<T> asEntity() {
        return this.metadata().reader();
    }

    private Statement childIds(JDBCEntityMetaData<T> metadata) {
        JDBCEntityMetaData<?> childEntity = metadata.childEntity();
        JDBCEntityMetaData.TableProjection projection = JDBCEntityMetaData.projection(childEntity.table(), "id", "security_group_id");
        JDBCEntityMetaData.Table childTable = childEntity.table();
        JDBCEntityMetaData.Column parentColumn = metadata.childEntityColumn();
        return JDBCEntityStatementBuilder.query().select().project(projection).from(childTable).where(childTable, JDBCEntityStatementBuilder.eq(JDBCEntityStatementBuilder.column(childTable, parentColumn.column()), JDBCEntityStatementBuilder.parameter("parent_id", parentColumn.type(), ParameterAccess.IN))).defaultOrdering(childTable).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T create(Transaction txn, CompoundPrincipal principal, T instance) throws SQLException {
        T t;
        JDBCCall insert = null;
        try {
            String creator = Text.upper((String)principal.getName());
            Timestamp now = new Timestamp(System.currentTimeMillis());
            insert = this.jdbc().insert(txn, this.insert, new String[]{"ID"});
            Map params = (Map)this.metadata().writer().apply(instance);
            JDBCIdentifiers.bind(params, principal);
            if (creator != null) {
                params.put("created_by", creator);
                params.put("updated_by", creator);
            }
            params.put("created_on", now);
            params.put("updated_on", now);
            insert.bind(params);
            BindableCallResults keys = insert.execute();
            instance.id((TenantIdentifier)JDBCIdentifiers.generatedId(principal, (Map<String, Object>)keys));
            t = this.inserted(txn, principal, instance);
        }
        catch (Throwable throwable) {
            Closeables.close(insert);
            throw throwable;
        }
        Closeables.close((Object)insert);
        return t;
    }

    private Statement deleteChildIds(JDBCEntityMetaData<T> metadata2) {
        JDBCEntityMetaData<?> childEntity = this.metadata.childEntity();
        JDBCEntityMetaData.Table childTable = childEntity.table();
        JDBCEntityMetaData.Column parentColumn = this.metadata.childEntityColumn();
        return JDBCEntityStatementBuilder.call().delete().from(childTable).where(childTable, JDBCEntityStatementBuilder.eq(JDBCEntityStatementBuilder.column(childTable, parentColumn.column()), JDBCEntityStatementBuilder.parameter("parent_id", parentColumn.type(), ParameterAccess.IN))).defaultOrdering(childTable).build();
    }

    private Statement entityByNaturalKey(JDBCEntityMetaData.Table table) {
        JDBCEntityMetaData.Column naturalKey = table.naturalKey();
        JDBCEntityMetaData.NaturalKeyScope scope = table.naturalKeyScope();
        if (JDBCEntityMetaData.NaturalKeyScope.TENANT == scope) {
            return JDBCEntityStatementBuilder.query().selectFrom(table).where(table, JDBCEntityStatementBuilder.eq(JDBCEntityStatementBuilder.column(table, naturalKey.column()), JDBCEntityStatementBuilder.parameter(naturalKey.column(), naturalKey.type(), ParameterAccess.IN))).build();
        }
        if (JDBCEntityMetaData.NaturalKeyScope.PARENT == scope) {
            JDBCEntityMetaData.Column parentColumn = table.parentColumn();
            return JDBCEntityStatementBuilder.query().selectFrom(table).where(table, JDBCEntityStatementBuilder.eq(JDBCEntityStatementBuilder.column(table, parentColumn.column()), JDBCEntityStatementBuilder.parameter(parentColumn.column(), parentColumn.type(), ParameterAccess.IN)), JDBCEntityStatementBuilder.eq(JDBCEntityStatementBuilder.column(table, naturalKey.column()), JDBCEntityStatementBuilder.parameter(naturalKey.column(), naturalKey.type(), ParameterAccess.IN))).build();
        }
        throw new IllegalStateException();
    }

    private boolean hasNaturalKey() {
        return this.metadata().table().naturalKeyScope() != JDBCEntityMetaData.NaturalKeyScope.NONE;
    }

    private Map<String, Object> naturalKeys(T instance) {
        HashMap<String, Object> naturalKeyColumns = new HashMap<String, Object>();
        JDBCEntityMetaData.NaturalKeyScope scope = this.metadata.table().naturalKeyScope();
        JDBCEntityMetaData.Column naturalKey = this.metadata.table().naturalKey();
        naturalKeyColumns.put(naturalKey.column(), Reflections.fieldValue(instance, (String)naturalKey.field()));
        if (JDBCEntityMetaData.NaturalKeyScope.PARENT == scope) {
            JDBCEntityMetaData.Column parentColumn = this.metadata.table().parentColumn();
            Object parentId = Reflections.fieldValue(instance, (String)parentColumn.field());
            if (parentId instanceof TenantIdentifier) {
                parentId = JDBCIdentifiers.entityId((TenantIdentifier)parentId);
            }
            naturalKeyColumns.put(parentColumn.column(), parentId);
        }
        return naturalKeyColumns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T update(Transaction txn, CompoundPrincipal principal, T instance) throws SQLException {
        T t;
        JDBCCall update = null;
        try {
            JDBCEntityProviderBase.verifyTenant(principal, (TenantIdentifier)instance.id(), true);
            String updator = Text.upper((String)principal.getName());
            Timestamp now = new Timestamp(System.currentTimeMillis());
            update = this.jdbc().call(txn, this.update);
            Map params = (Map)this.metadata().writer().apply(instance);
            JDBCIdentifiers.bind(params, principal, (TenantIdentifier)instance.id());
            if (updator != null) {
                params.put("created_by", updator);
                params.put("updated_by", updator);
            }
            params.put("updated_on", now);
            update.bind(params);
            update.execute();
            t = this.updated(txn, principal, instance);
        }
        catch (Throwable throwable) {
            Closeables.close(update);
            throw throwable;
        }
        Closeables.close((Object)update);
        return t;
    }

    protected static void verifyTenant(CompoundPrincipal principal, TenantIdentifier id, boolean write) {
        JDBCIdentifiers.verify(principal, id, write);
    }
}

