/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.jdbc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import oracle.dbtools.common.config.db.DatabasePoolConfig;
import oracle.dbtools.common.config.db.PoolMap;
import oracle.dbtools.common.diagnostics.DiagnosticContext;
import oracle.dbtools.common.diagnostics.Diagnostics;
import oracle.dbtools.common.jdbc.ConnectionPoolException;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.jdbc.JDBCPrincipal;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.Log;

public class DatabaseConnectionFilter
extends HttpServletRequestWrapper {
    private final String contextPath;
    private final PoolMap poolMap;
    private final JDBCPrincipal jdbcPrincipal;
    private final String pathInfo;
    private final String tenantIdentifier;
    public static final String POOL_MAP_ATTRIBUTE = "DatabaseConnectionFilter.poolMap";
    public static final String JDBC_PRINCIPAL_ATTRIBUTE = "jdbcPrincipal";
    public static final String TENANT_IDENTIFIER_ATTRIBUTE = "tenantIdentifier";
    private static final Log LOG = Log.get(DatabaseConnectionFilter.class);

    private DatabaseConnectionFilter(HttpServletRequest request, PoolMap poolInfo) {
        super(request);
        String contextPath = request.getContextPath();
        String uri = DatabaseConnectionFilter.uri(request);
        String poolIdentifier = poolInfo.poolIdentifier(contextPath, uri);
        this.contextPath = poolInfo.contextPath(contextPath, uri);
        this.pathInfo = poolInfo.pathInfo(contextPath, uri);
        this.jdbcPrincipal = this.jdbcProvider().principal(poolIdentifier);
        this.tenantIdentifier = poolInfo.workspaceIdentifier();
        this.poolMap = poolInfo;
    }

    public PoolMap poolMap() {
        return this.poolMap;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public Object getAttribute(String name) {
        if (JDBC_PRINCIPAL_ATTRIBUTE.equals(name)) {
            return this.jdbcPrincipal;
        }
        if (TENANT_IDENTIFIER_ATTRIBUTE.equals(name)) {
            return this.tenantIdentifier;
        }
        if (POOL_MAP_ATTRIBUTE.equals(name)) {
            return this.poolMap;
        }
        return super.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        Enumeration existing = super.getAttributeNames();
        ArrayList all = Collections.list(existing);
        Iterables.add(all, (Iterable)Iterables.iterable((Object[])new String[]{POOL_MAP_ATTRIBUTE, JDBC_PRINCIPAL_ATTRIBUTE, TENANT_IDENTIFIER_ATTRIBUTE}));
        return Iterators.enumeration(all.iterator());
    }

    private JDBCCallProvider jdbcProvider() {
        return (JDBCCallProvider)ServiceLocator.acquire(JDBCCallProvider.class);
    }

    private static PoolMap poolInfo(HttpServletRequest request) {
        return DatabasePoolConfig.getInstance().getPoolInfo(request.getContextPath(), DatabaseConnectionFilter.uri(request));
    }

    private static String uri(HttpServletRequest req) {
        StringBuffer requestURL = req.getRequestURL();
        String queryString = req.getQueryString();
        if (queryString != null) {
            requestURL.append('?');
            requestURL.append(queryString);
        }
        return requestURL.toString();
    }

    private static void debug(HttpServletRequest request, CharSequence msg) {
        DatabaseConnectionFilter.diagnosticContext(request).log(msg);
    }

    private static DiagnosticContext diagnosticContext(HttpServletRequest req) {
        try {
            Diagnostics diagnostics = (Diagnostics)ServiceLocator.acquire(Diagnostics.class);
            return diagnostics.diagnosticContext(req);
        }
        catch (Throwable t) {
            LOG.fine(t);
            return DiagnosticContext.DISABLED;
        }
    }

    public static HttpServletRequest applyDatabaseConnectionInfo(HttpServletRequest request) {
        try {
            PoolMap poolInfo = DatabaseConnectionFilter.poolInfo(request);
            if (poolInfo == null) {
                DatabaseConnectionFilter.debug(request, "Could not find any database pool to use for this request");
                return request;
            }
            DatabaseConnectionFilter.debug(request, "Mapping request to database pool: " + poolInfo);
            return new DatabaseConnectionFilter(request, poolInfo);
        }
        catch (ConnectionPoolException e) {
            LOG.warning((Throwable)e);
            return request;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DatabaseConnectionFilter [contextPath=");
        builder.append(this.contextPath);
        builder.append(", pathInfo=");
        builder.append(this.pathInfo);
        builder.append(", jdbcPrincipal=");
        builder.append(this.jdbcPrincipal);
        builder.append(", tenantIdentifier=");
        builder.append(this.tenantIdentifier);
        builder.append("]");
        return builder.toString();
    }
}

