/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.html;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Stack;
import javax.xml.namespace.QName;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.AbstractIterator;
import oracle.dbtools.common.util.ChunkedInputStream;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.StringBuilders;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.common.util.URIs;
import oracle.dbtools.common.x3p.X3PAttributes;
import oracle.dbtools.common.x3p.X3PFactory;
import oracle.dbtools.common.x3p.X3PHandler;
import oracle.dbtools.common.x3p.X3PHandlerAdaptor;
import oracle.dbtools.common.x3p.X3PReader;
import oracle.dbtools.json.JSONBuilder;
import oracle.dbtools.json.JSONNode;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.microdata.MicrodataBuilder;
import oracle.dbtools.rt.microdata.MicrodataToJson;
import oracle.dbtools.rt.transcode.Transcoder;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.ContentTypes;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.Requests;
import oracle.dbtools.rt.web.WebException;

@Service
public class HTMLToJSON
implements Transcoder {
    private static final String CONTENT = "content";
    private static final String DATA = "data";
    private static final String DATETIME = "datetime";
    private static final String HREF = "href";
    private static final List<String> HREF_TAGS = Arrays.asList("a", "area", "link");
    private static final String ITEM_ID = "itemid";
    private static final String ITEM_PROP = "itemprop";
    private static final String ITEM_SCOPE = "itemscope";
    private static final String ITEM_TYPE = "itemtype";
    private static final String META_TAG = "meta";
    private static final String OBJECT_TAG = "object";
    private static final String SRC = "src";
    private static final List<String> SRC_TAGS = Arrays.asList("audio", "embed", "iframe", "img", "source", "video");
    private static final String TIME_TAG = "time";
    public static final byte[] NOT_FINISHED = new byte[0];

    public Entity apply(Entity entity) {
        try {
            String documentBase = Requests.documentBase(entity);
            return Entities.entity((InputStream)((Object)new MicrodataStream(entity.body(), documentBase)), Entities.headers(new CharSequence[]{HttpHeader.CONTENT_TYPE, ContentTypes.JSON}));
        }
        catch (IOException e) {
            throw WebException.internalError(e, new Reason[0]);
        }
    }

    @Override
    public boolean canTransform(ContentType from, ContentType ... to) {
        return from.matches(ContentTypes.APEX_HTML) && ContentType.matches(ContentTypes.JSON_TYPES, to);
    }

    private static String[] names(String itemprop) {
        if (itemprop == null) {
            return null;
        }
        return itemprop.trim().split("\\s+");
    }

    private static class HtmlToMicrodata
    extends X3PHandlerAdaptor {
        private final StringBuilder bytes = new StringBuilder();
        private final MicrodataBuilder microdata;
        private final Stack<MicrodataContext> context = new Stack();
        private boolean read = false;
        private boolean finished = false;

        public HtmlToMicrodata(String documentBase) {
            URI base = null;
            if (documentBase != null) {
                base = URIs.create((String)documentBase);
            }
            this.microdata = MicrodataBuilder.microdata(base);
        }

        public byte[] bytes() {
            if (this.read && !this.finished) {
                MicrodataToJson json = new MicrodataToJson();
                this.finished = true;
                return Text.getBytes((String)JSONBuilder.render((JSONNode)json.apply(this.microdata)));
            }
            return NOT_FINISHED;
        }

        public void characters(char[] ch, int start, int length) {
            MicrodataContext element = this.findEnclosingItemProp();
            if (element != null) {
                element.value.append(ch, start, length);
            }
        }

        public void endDocument() {
            this.read = true;
        }

        public void endElement(QName name) {
            MicrodataContext element = this.context.pop();
            switch (element.kind) {
                case NESTED_ITEM: 
                case ITEM: {
                    this.microdata.exit();
                    break;
                }
                case INNER_TEXT_PROPERTY: {
                    this.property(element);
                }
            }
        }

        private void property(MicrodataContext element) {
            String value = element.value.toString();
            switch (element.microdataKind) {
                case URI: {
                    this.microdata.uri(value, element.propertyNames);
                    break;
                }
                case TEXT: {
                    this.microdata.text(value, element.propertyNames);
                    break;
                }
                case TIMESTAMP: {
                    this.microdata.timestamp(value, element.propertyNames);
                }
            }
        }

        public void reset() {
            StringBuilders.reset((StringBuilder)this.bytes);
        }

        public void startElement(QName name, X3PAttributes atts) {
            boolean itemscope = atts.get(HTMLToJSON.ITEM_SCOPE) != null;
            String itemprop = atts.get(HTMLToJSON.ITEM_PROP);
            String type = atts.get(HTMLToJSON.ITEM_TYPE);
            String id = atts.get(HTMLToJSON.ITEM_ID);
            String value = null;
            Kind kind = Kind.NOT_ITEM;
            MicrodataBuilder.Kind microdataKind = null;
            String[] names = HTMLToJSON.names(itemprop);
            if (itemscope && itemprop == null) {
                kind = Kind.ITEM;
            } else if (itemscope && itemprop != null) {
                kind = Kind.NESTED_ITEM;
            } else if (!itemscope && itemprop != null) {
                value = this.value(name.getLocalPart(), atts);
                microdataKind = this.microdataKind(name.getLocalPart());
                kind = value == null ? Kind.INNER_TEXT_PROPERTY : Kind.PROPERTY;
            }
            MicrodataContext element = new MicrodataContext(kind, microdataKind, value, names);
            this.context.push(element);
            switch (kind) {
                case PROPERTY: {
                    this.property(element);
                    break;
                }
                case NESTED_ITEM: 
                case ITEM: {
                    this.microdata.enter(type, id, names);
                }
            }
        }

        private MicrodataContext findEnclosingItemProp() {
            for (int i = this.context.size() - 1; i >= 0; --i) {
                MicrodataContext element = (MicrodataContext)this.context.get(i);
                if (element.kind != Kind.INNER_TEXT_PROPERTY || element.propertyNames.length == 0) continue;
                return element;
            }
            return null;
        }

        private String hyperlink(String attributeName, X3PAttributes atts) {
            String value = null;
            value = atts.get(attributeName);
            if (value == null) {
                value = "";
            }
            return value;
        }

        private String value(String tag, X3PAttributes atts) {
            String value = null;
            tag = tag.toLowerCase();
            if (SRC_TAGS.contains(tag)) {
                value = this.hyperlink(HTMLToJSON.SRC, atts);
            } else if (HREF_TAGS.contains(tag)) {
                value = this.hyperlink(HTMLToJSON.HREF, atts);
            } else if (HTMLToJSON.META_TAG.equals(tag)) {
                value = atts.get(HTMLToJSON.CONTENT);
                if (value == null) {
                    value = "";
                }
            } else if (HTMLToJSON.OBJECT_TAG.equals(tag)) {
                value = this.hyperlink(HTMLToJSON.DATA, atts);
            } else if (HTMLToJSON.TIME_TAG.equals(tag)) {
                value = atts.get(HTMLToJSON.DATETIME);
            }
            return value;
        }

        private MicrodataBuilder.Kind microdataKind(String tag) {
            tag = tag.toLowerCase();
            MicrodataBuilder.Kind kind = MicrodataBuilder.Kind.TEXT;
            if (SRC_TAGS.contains(tag)) {
                kind = MicrodataBuilder.Kind.URI;
            } else if (HREF_TAGS.contains(tag)) {
                kind = MicrodataBuilder.Kind.URI;
            } else if (HTMLToJSON.OBJECT_TAG.equals(tag)) {
                kind = MicrodataBuilder.Kind.URI;
            } else if (HTMLToJSON.TIME_TAG.equals(tag)) {
                kind = MicrodataBuilder.Kind.TIMESTAMP;
            }
            return kind;
        }
    }

    private static class MicrodataStream
    extends ChunkedInputStream {
        private MicrodataStream(InputStream html, String documentBase) {
            super((ChunkedInputStream.Chunker)new MicrodataChunker(html, documentBase));
        }
    }

    private static class MicrodataContext {
        final MicrodataBuilder.Kind microdataKind;
        final Kind kind;
        final String[] propertyNames;
        final StringBuilder value = new StringBuilder();

        private MicrodataContext(Kind kind, MicrodataBuilder.Kind microdataKind, String value, String[] names) {
            this.kind = kind;
            this.microdataKind = microdataKind;
            if (value != null) {
                this.value.append(value);
            }
            if (names == null) {
                this.propertyNames = null;
            } else {
                LinkedHashSet<String> unique = new LinkedHashSet<String>();
                for (String propertyName : names) {
                    unique.add(propertyName);
                }
                this.propertyNames = unique.toArray(new String[unique.size()]);
            }
        }
    }

    private static class MicrodataChunker
    extends AbstractIterator<byte[]>
    implements ChunkedInputStream.Chunker {
        private final X3PReader r;
        private final HtmlToMicrodata w;

        public MicrodataChunker(InputStream html, String documentBase) {
            try {
                this.r = X3PFactory.newReader((InputStream)html);
                this.w = new HtmlToMicrodata(documentBase);
                this.r.setHandler((X3PHandler)this.w);
            }
            catch (IOException e) {
                throw WebException.internalError(e, new Reason[0]);
            }
        }

        public void close() throws IOException {
            Closeables.close((Object)this.r);
        }

        protected byte[] advance() {
            try {
                byte[] chunk = null;
                boolean empty = true;
                boolean more = true;
                while (empty && more) {
                    more = this.r.next();
                    byte[] written = this.w.bytes();
                    empty = written.length == 0;
                    if (empty) continue;
                    chunk = written;
                    this.w.reset();
                }
                return chunk;
            }
            catch (IOException e) {
                throw WebException.internalError(e, new Reason[0]);
            }
        }
    }

    private static enum Kind {
        INNER_TEXT_PROPERTY,
        ITEM,
        NESTED_ITEM,
        NOT_ITEM,
        PROPERTY;

    }
}

