/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.home;

import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.rt.home.EntityStorage;
import oracle.dbtools.rt.home.GenericEntity;
import oracle.dbtools.rt.home.StoreMode;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

public class EntityStores<PK, T extends GenericEntity<PK>> {
    public Iterable<PK> childIds(Transaction txn, CompoundPrincipal principal, Class<? extends GenericEntity<PK>> type, PK id) {
        EntityStorage<PK, Class<GenericEntity<PK>>> storage = this.storage((T)type);
        return storage.childIds(txn, principal, id);
    }

    public void delete(Transaction txn, CompoundPrincipal principal, Class<? extends GenericEntity<PK>> type, PK entityId) {
        EntityStorage<PK, Class<GenericEntity<PK>>> storage = this.storage((T)type);
        storage.delete(txn, principal, entityId);
    }

    public void deleteChildren(Transaction txn, CompoundPrincipal principal, Class<? extends GenericEntity<PK>> type, PK entityId) {
        EntityStorage<PK, Class<GenericEntity<PK>>> storage = this.storage((T)type);
        storage.deleteChildren(txn, principal, entityId);
    }

    public T entity(Transaction txn, CompoundPrincipal principal, Class<? extends T> type, PK entityId) {
        EntityStorage<PK, T> storage = this.typedStorage(type);
        return storage.entity(txn, principal, entityId);
    }

    public Transaction newTransaction(CompoundPrincipal principal, T instance) {
        return this.storage(instance).newTransaction(principal);
    }

    public <E extends T> E store(StoreMode storeMode, Transaction txn, CompoundPrincipal principal, E instance) {
        return this.storage(instance).store(storeMode, txn, principal, instance);
    }

    private <E extends GenericEntity<PK>> EntityStorage<PK, E> storage(Class<E> type) {
        EntityStorage storage = (EntityStorage)ServiceLocator.acquire(EntityStorage.class, (String[])new String[]{"oracle.dbtools.rt.home.ExistingEntity", type.getName()});
        if (storage == null) {
            throw WebException.internalError(new IllegalStateException("No Service found to store instance of: " + type), new Reason[0]);
        }
        return storage;
    }

    private EntityStorage<PK, T> typedStorage(Class<? extends T> type) {
        EntityStorage storage = (EntityStorage)ServiceLocator.acquire(EntityStorage.class, (String[])new String[]{"oracle.dbtools.rt.home.ExistingEntity", type.getName()});
        if (storage == null) {
            throw WebException.internalError(new IllegalStateException("No Service found to store instance of: " + type), new Reason[0]);
        }
        return storage;
    }

    private EntityStorage<PK, T> storage(T instance) {
        Class<?> type = instance.getClass();
        EntityStorage<PK, ?> storage = this.typedStorage(type);
        return storage;
    }
}

