/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.entity;

import java.io.IOException;
import java.io.InputStream;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.entity.EntityHeaders;

class EntityImpl
implements Entity {
    private final InputStream body;
    private final EntityHeaders headers;

    EntityImpl(InputStream body, EntityHeaders headers) {
        this.body = body == null ? StreamCopy.emptyStream() : body;
        this.headers = headers;
    }

    @Override
    public InputStream body() throws IOException {
        return this.body;
    }

    @Override
    public void close() throws IOException {
        Closeables.close((Object)this.headers);
        Closeables.close((Object)this.body);
    }

    @Override
    public EntityHeaders headers() {
        return this.headers;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.headers);
        b.append("\r\n");
        if (this.body != null) {
            b.append(this.body.toString());
        }
        return b.toString();
    }
}

