/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.config.setup;

import java.io.Console;
import java.io.File;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import oracle.dbtools.common.config.Configurations;
import oracle.dbtools.common.config.ConfigurationsBuilder;
import oracle.dbtools.common.config.MutableConfigurations;
import oracle.dbtools.common.di.Factory;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Passwords;
import oracle.dbtools.plugin.api.cmdline.CommandProvider;
import oracle.dbtools.plugin.api.cmdline.annotations.Command;
import oracle.dbtools.plugin.api.cmdline.annotations.Option;
import oracle.dbtools.plugin.api.di.annotations.Provides;
import oracle.dbtools.plugin.api.i18n.annotations.TranslatableText;
import oracle.dbtools.rt.config.setup.ConfigurationBuilder;
import oracle.dbtools.rt.config.setup.InstallParams;
import oracle.dbtools.rt.config.setup.SchemaSetup;
import oracle.dbtools.rt.config.setup.Setting;
import oracle.dbtools.rt.config.setup.SetupMessages;

@Provides
@Command(name="setup", description=@TranslatableText(type=SetupMessages.class, id="DESCRIPTION"), options={@Option(name="database", description=@TranslatableText(type=SetupMessages.class, id="DB_OPTION"))})
public class Setup
implements CommandProvider {
    private final MutableConfigurations confs;
    private final Factory factory;
    private final File war;
    static final String APEX_PUBLIC_USER = "APEX_PUBLIC_USER";
    static final String MD_SUFFIX = "_md";
    static final String AL_SUFFIX = "_al";
    static final String ORDS_PUBLIC_USER = "ORDS_PUBLIC_USER";
    private static Setting PASSWORD = Setting.setting("DB_PWD", "db.password", null, true, new String[0]);
    private static Setting PORT = Setting.setting("DB_SERVER_PORT", "db.port", "1521");
    static final String RT_SUFFIX = "_rt";
    static final String PU_SUFFIX = "_pu";
    private static Setting SERVER = Setting.setting("DB_SERVER_NAME", "db.hostname", "localhost");
    private static Setting SERVICE_NAME = Setting.setting("DB_SERVICE_NAME", "db.servicename", null);
    private static final Setting SERVICE_OR_SID = Setting.setting("DB_CHOOSE_SID_OR_SERVICE", null, "1", false, "1", "2");
    private static Setting SID = Setting.setting("DB_SERVICE_ID", "db.sid", "xe");
    private static Setting USER = Setting.setting("DB_USER", "db.username", "APEX_PUBLIC_USER");
    private static final Setting PROMPT_USE_APEX_REST = Setting.setting("PROMPT_REST_CREDENTIALS", null, "1", false, "1", "2");
    private static final Setting PROMPT_USE_PLSQL_GATEWAY = Setting.setting("PROMPT_PLSQL_GATEWAY", null, "1", false, "1", "2");
    private static final Setting PROMPT_INSTALL_ORDS_SCHEMA = Setting.setting("PROMPT_ORDS_SCHEMA", null, "1", false, "1", "2");
    private static Setting PROMPT_ENTER_GATEWAY_USER = Setting.setting("PLSQL_GATEWAY_USER", "db.username", "APEX_PUBLIC_USER");
    private static boolean isSimpleInstall;

    @Inject
    Setup(MutableConfigurations confs, @Named(value="war") File war, Factory factory) {
        this.confs = confs;
        this.war = war;
        this.factory = factory;
    }

    public void execute(Map<String, Object> values) throws Exception {
        String confName = (String)values.get("database");
        if (confName == null) {
            confName = "apex";
        }
        confName = confName.toLowerCase();
        Map<String, String> installParams = InstallParams.getInstallParameters(this.war, (String)values.get("installtype"), (String)values.get("paramfile"));
        if (installParams == null) {
            throw new Exception(SetupMessages.getString("ERR_INSTALL_PARAMS"));
        }
        isSimpleInstall = InstallParams.simpleInstall(installParams);
        Console console = System.console();
        MutableConfigurations existing = this.confs;
        ConfigurationBuilder defaults = ConfigurationBuilder.defaults((Configurations)existing);
        ConfigurationBuilder conf = ConfigurationBuilder.builder(defaults, (Configurations)existing, confName);
        Setup.settingValue(console, conf, installParams, "db.hostname", SERVER);
        Setup.settingValue(console, conf, installParams, "db.port", PORT);
        if (installParams.containsKey("db.servicename")) {
            Setup.settingValue(console, conf, installParams, "db.servicename", SERVICE_NAME);
        } else if (installParams.containsKey("db.sid")) {
            Setup.settingValue(console, conf, installParams, "db.sid", SID);
        } else if (console != null) {
            String choice = SERVICE_OR_SID.prompt(console, new String[0]);
            if ("1".equals(choice)) {
                Setup.settingValue(console, conf, installParams, "db.servicename", SERVICE_NAME);
            } else {
                Setup.settingValue(console, conf, installParams, "db.sid", SID);
            }
        } else {
            if (isSimpleInstall) {
                String keys = "db.servicename or db.sid";
                throw new Exception(SetupMessages.format("ERR_MISSING_VALUE_SIMPLE", keys));
            }
            throw new Exception(SetupMessages.getString("ERR_NO_CONSOLE_ADVANCED"));
        }
        if (!NullOrEmpty.nullOrEmpty((CharSequence)installParams.get("security.verifySSL"))) {
            conf.add("security.verifySSL", installParams.get("security.verifySSL"));
        }
        ConfigurationsBuilder cb = ConfigurationsBuilder.builder((Configurations)existing);
        cb.configuration("defaults", defaults.build());
        for (String name : existing) {
            if (name.equals("defaults") || name.equals(confName) || name.equals(confName + "_")) continue;
            cb.configuration(name, ConfigurationBuilder.builder(defaults, (Configurations)existing, name).build());
        }
        Configurations defaultConfigs = cb.build();
        Configurations ordsConfigs = Setup.restfulServicesConf(console, defaultConfigs, confName, installParams);
        boolean isInstallSchema = Boolean.valueOf(installParams.get("rest.services.ords.add"));
        if (isInstallSchema) {
            SchemaSetup.schemaParams(console, this.war, installParams);
        }
        Configurations basicConfigs = this.plsqlGatewayConfig(console, ordsConfigs, confName, installParams);
        Configurations fullConf = Setup.apexRestfulServicesConf(console, basicConfigs, confName, installParams);
        this.confs.update(fullConf);
        InstallParams.writeInstallProperties(installParams);
        if (isInstallSchema) {
            SchemaSetup.install(installParams, (Class)values.get("installer"), this.factory);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Configurations plsqlGatewayConfig(Console console, Configurations existing, String confName, Map<String, String> installParams) throws Exception {
        String isAddGateway;
        boolean promptPlsqlGateway = true;
        if (isSimpleInstall && !NullOrEmpty.nullOrEmpty((CharSequence)(isAddGateway = installParams.get("plsql.gateway.add")))) {
            if (!isAddGateway.equals("true")) return existing;
            promptPlsqlGateway = false;
        }
        if (promptPlsqlGateway) {
            if (console == null) return existing;
            String choice = PROMPT_USE_PLSQL_GATEWAY.prompt(console, new String[0]);
            if ("1".equals(choice)) {
                installParams.put("plsql.gateway.add", "true");
            } else {
                installParams.put("plsql.gateway.add", "false");
                return existing;
            }
        }
        ConfigurationBuilder defaults = ConfigurationBuilder.defaults(existing);
        ConfigurationBuilder gatewayConf = ConfigurationBuilder.builder(defaults, existing, confName);
        String userName = Setup.settingValue(console, gatewayConf, installParams, "db.username", PROMPT_ENTER_GATEWAY_USER);
        Setup.settingValue(console, gatewayConf, installParams, "db.password", PASSWORD, true, userName);
        return ConfigurationsBuilder.builder((Configurations)existing).configuration(confName, gatewayConf.build());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Configurations restfulServicesConf(Console console, Configurations existing, String confName, Map<String, String> installParams) throws Exception {
        String isInstallSchema;
        isSimpleInstall = InstallParams.simpleInstall(installParams);
        boolean promptInstallSchema = true;
        if (isSimpleInstall && !NullOrEmpty.nullOrEmpty((CharSequence)(isInstallSchema = installParams.get("rest.services.ords.add")))) {
            if (!isInstallSchema.equals("true")) return existing;
            promptInstallSchema = false;
        }
        if (promptInstallSchema) {
            if (console == null) return existing;
            String choice = PROMPT_INSTALL_ORDS_SCHEMA.prompt(console, new String[0]);
            if ("1".equals(choice)) {
                installParams.put("rest.services.ords.add", "true");
            } else {
                installParams.put("rest.services.ords.add", "false");
                return existing;
            }
        }
        String puConfName = confName + PU_SUFFIX;
        ConfigurationBuilder defaults = ConfigurationBuilder.defaults(existing);
        ConfigurationBuilder pu = ConfigurationBuilder.builder(defaults, existing, puConfName);
        pu.add("db.username", ORDS_PUBLIC_USER);
        installParams.put("user.name.public", ORDS_PUBLIC_USER);
        Setup.settingValue(console, pu, installParams, "db.password", PASSWORD, true, ORDS_PUBLIC_USER);
        return ConfigurationsBuilder.builder((Configurations)existing).configuration(puConfName, pu.build());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Configurations apexRestfulServicesConf(Console console, Configurations existing, String confName, Map<String, String> installParams) throws Exception {
        String isAddAPEXRest;
        boolean promptUseApex = true;
        if (isSimpleInstall && !NullOrEmpty.nullOrEmpty((CharSequence)(isAddAPEXRest = installParams.get("rest.services.apex.add")))) {
            if (!isAddAPEXRest.equals("true")) return existing;
            promptUseApex = false;
        }
        if (promptUseApex) {
            if (console == null) return existing;
            String choice = PROMPT_USE_APEX_REST.prompt(console, new String[0]);
            if ("1".equals(choice)) {
                installParams.put("rest.services.apex.add", "true");
            } else {
                installParams.put("rest.services.apex.add", "false");
                return existing;
            }
        }
        String alConfName = confName + AL_SUFFIX;
        String rtConfName = confName + RT_SUFFIX;
        ConfigurationBuilder defaults = ConfigurationBuilder.defaults(existing);
        ConfigurationBuilder al = ConfigurationBuilder.builder(defaults, existing, alConfName);
        ConfigurationBuilder rt = ConfigurationBuilder.builder(defaults, existing, rtConfName);
        al.add("db.username", "APEX_LISTENER");
        installParams.put("user.name.apex.listener", "APEX_LISTENER");
        Setup.settingValue(console, al, installParams, "db.password", PASSWORD, true, "APEX_LISTENER");
        rt.add("db.username", "APEX_REST_PUBLIC_USER");
        installParams.put("user.name.apex.restpublic", "APEX_REST_PUBLIC_USER");
        Setup.settingValue(console, rt, installParams, "db.password", PASSWORD, true, "APEX_REST_PUBLIC_USER");
        return ConfigurationsBuilder.builder((Configurations)existing).configuration(alConfName, al.build()).configuration(rtConfName, rt.build());
    }

    private static String settingValue(Console console, ConfigurationBuilder conf, Map<String, String> installParams, String key, Setting setting) throws Exception {
        return Setup.settingValue(console, conf, installParams, key, setting, false, null);
    }

    private static String settingValue(Console console, ConfigurationBuilder conf, Map<String, String> installParams, String key, Setting setting, boolean isPassword, String user) throws Exception {
        String val = null;
        String pwKey = null;
        if (isPassword) {
            pwKey = user.equalsIgnoreCase(ORDS_PUBLIC_USER) ? "user.public.password" : (user.equalsIgnoreCase("APEX_LISTENER") ? "user.apex.listener.password" : (user.equalsIgnoreCase("APEX_REST_PUBLIC_USER") ? "user.apex.restpublic.password" : "db.password"));
            val = installParams.get(pwKey);
            if (!NullOrEmpty.nullOrEmpty((CharSequence)val) && !val.startsWith("@")) {
                val = "@" + Passwords.goingOut((String)val);
                installParams.put(pwKey, val);
            }
        } else {
            val = installParams.get(key);
        }
        if (console != null) {
            if (isSimpleInstall && !NullOrEmpty.nullOrEmpty((CharSequence)val)) {
                conf.add(key, val);
            } else if (isPassword) {
                val = setting.prompt(console, user);
                installParams.put(pwKey, val);
                conf.add("db.password", val);
            } else {
                if (!NullOrEmpty.nullOrEmpty((CharSequence)val)) {
                    setting.setDefaultValue(val);
                }
                val = setting.prompt(console, conf, new String[0]);
                installParams.put(key, val);
            }
        } else if (isSimpleInstall) {
            if (NullOrEmpty.nullOrEmpty((CharSequence)val)) {
                throw new Exception(SetupMessages.format("ERR_MISSING_VALUE_SIMPLE", isPassword ? pwKey : key));
            }
            conf.add(key, val);
        } else {
            throw new Exception(SetupMessages.getString("ERR_NO_CONSOLE_ADVANCED"));
        }
        return val;
    }
}

