/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.config.setup;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import oracle.dbtools.common.config.Configurations;
import oracle.dbtools.common.config.ConfigurationsBuilder;
import oracle.dbtools.common.util.ConfigFiles;
import oracle.dbtools.common.util.SortedProperties;
import oracle.dbtools.rt.config.setup.ConfigurationBuilder;

abstract class ApexConfig {
    private static final List<String> KEEP_APEX_PREFIX = Arrays.asList("apex.docTable", "apex.excel2collection", "apex.excel2collection.name", "apex.excel2collection.onecollection", "apex.excelcollection.useSheetName", "apex.log.enable", "apex.log.procedure", "apex.extensions");
    private static final String OLD_PREFIX = "apex.";

    private ApexConfig() {
    }

    static Configurations migrate(File apexConfig, Configurations confs) throws IOException {
        if (apexConfig.exists()) {
            SortedProperties oldProps = new SortedProperties();
            ConfigFiles.load((Properties)oldProps, (File)apexConfig);
            return ApexConfig.migrate((Properties)oldProps, confs);
        }
        return null;
    }

    static Configurations migrate(Properties apexConfig, Configurations confs) {
        if (apexConfig == null) {
            return null;
        }
        ConfigurationBuilder defaults = ConfigurationBuilder.defaults(confs);
        ConfigurationBuilder apex = ConfigurationBuilder.builder(defaults, confs, "apex");
        for (Object key : apexConfig.keySet()) {
            String name = (String)key;
            String value = apexConfig.getProperty(name);
            String newName = KEEP_APEX_PREFIX.contains(name) ? name : name.substring(OLD_PREFIX.length());
            if ("db.username".equals(newName)) {
                apex.add(newName, value);
                continue;
            }
            defaults.add(newName, value);
        }
        ConfigurationsBuilder updatedConfs = ConfigurationsBuilder.builder((Configurations)confs);
        updatedConfs.configuration("defaults", defaults.build());
        updatedConfs.configuration("apex", apex.build());
        return updatedConfs.build();
    }
}

