/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authorization.apex;

import java.security.Principal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import oracle.dbtools.common.jdbc.JDBCCallProvider;
import oracle.dbtools.common.jdbc.JDBCException;
import oracle.dbtools.common.jdbc.JDBCQuery;
import oracle.dbtools.common.jdbc.JDBCTransaction;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.stmt.Statement;
import oracle.dbtools.common.stmt.StatementBuilder;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.rt.authorization.AuthorizationPolicy;
import oracle.dbtools.rt.authorization.BaseScopeAuthorizationPolicy;
import oracle.dbtools.rt.authorization.RoleMappers;
import oracle.dbtools.rt.authorization.ScopeAuthorizationPolicy;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.jdbc.entity.JDBCIdentifiers;
import oracle.dbtools.rt.resource.templates.jdbc.ApexListenerJDBCPrincipal;

@Service(provides={ScopeAuthorizationPolicy.class})
public class IDMScopeAuthorization
extends BaseScopeAuthorizationPolicy {
    @Reference
    private JDBCCallProvider jdbc;
    @Reference
    private RoleMappers roles;
    private static final String GET_APEX_GROUP_NAME = "select group_name from wwv_flow_rt$idm_privs\nwhere security_group_id in (10,:tenant_id)\nand privilege_id      = :id";
    private static final Statement GET_APEX_GROUP_NAME_STMT = JDBCIdentifiers.keyParameter(StatementBuilder.query().append((CharSequence)"select group_name from wwv_flow_rt$idm_privs\nwhere security_group_id in (10,:tenant_id)\nand privilege_id      = :id")).build();
    private static final Log LOG = Log.get(IDMScopeAuthorization.class);

    @Override
    protected AuthorizationPolicy.Access authorize(CompoundPrincipal principal, TenantIdentifier scopeId) {
        Iterator matches;
        JDBCQuery call;
        AuthorizationPolicy.Access access;
        block9: {
            access = AuthorizationPolicy.Access.PRINCIPAL_UNKNOWN;
            CompoundPrincipal apexListener = ApexListenerJDBCPrincipal.apexListener(principal);
            call = null;
            JDBCTransaction txn = null;
            matches = null;
            try {
                txn = this.jdbc.transaction((Principal)apexListener);
                call = this.jdbc.query((Transaction)txn, GET_APEX_GROUP_NAME_STMT, true);
                HashMap<String, Object> params = new HashMap<String, Object>();
                JDBCIdentifiers.bind(params, principal, scopeId);
                call.bind(params);
                matches = call.execute();
                if (matches.hasNext()) {
                    ResultRow match = (ResultRow)matches.next();
                    String requiredRole = (String)match.get(1, String.class);
                    if (this.roles.isPrincipalInRole(principal, requiredRole)) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("The user: " + principal + " does have the required role: " + requiredRole);
                        }
                        access = AuthorizationPolicy.Access.READ_WRITE;
                    } else {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("The user: " + principal + " does not have the required role: " + requiredRole);
                        }
                        access = AuthorizationPolicy.Access.NONE;
                    }
                    break block9;
                }
                LOG.fine("no role found for: " + scopeId);
            }
            catch (SQLException e) {
                try {
                    throw JDBCException.wrap((SQLException)e);
                }
                catch (Throwable throwable) {
                    Closeables.close((Object[])new Object[]{matches, call});
                    throw throwable;
                }
            }
        }
        Closeables.close((Object[])new Object[]{matches, call});
        return access;
    }
}

