/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authentication;

import java.security.Principal;
import java.util.LinkedHashSet;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.rt.authentication.RolePrincipal;
import oracle.dbtools.rt.authentication.UserPrincipal;

public abstract class Principals {
    private Principals() {
    }

    public static Principal[] principals(String userName, String ... roles) {
        UserPrincipal user = Principals.user(userName);
        RolePrincipal[] rolePrincipals = Principals.roles(roles);
        Principal[] principals = new Principal[1 + roles.length];
        principals[0] = user;
        for (int i = 1; i < principals.length; ++i) {
            principals[i] = rolePrincipals[i - 1];
        }
        return principals;
    }

    public static RolePrincipal role(String role) {
        if (!NullOrEmpty.nullOrEmpty((CharSequence)role)) {
            role = role.trim();
            return new RolePrincipalImpl(role);
        }
        return null;
    }

    public static RolePrincipal[] roles(String ... roles) {
        LinkedHashSet<RolePrincipal> principals = new LinkedHashSet<RolePrincipal>(roles.length);
        for (int i = 0; i < roles.length; ++i) {
            String role = roles[i];
            if (NullOrEmpty.nullOrEmpty((CharSequence)role)) continue;
            principals.add(Principals.role(role));
        }
        return principals.toArray(new RolePrincipal[principals.size()]);
    }

    public static UserPrincipal user(String name) {
        if (!NullOrEmpty.nullOrEmpty((CharSequence)(name = name.trim()))) {
            return new UserPrincipalImpl(name);
        }
        return null;
    }

    private static final class UserPrincipalImpl
    extends PrincipalBase
    implements UserPrincipal {
        private static final long serialVersionUID = -3166891960670200959L;

        private UserPrincipalImpl(String name) {
            super(name);
        }
    }

    private static final class RolePrincipalImpl
    extends PrincipalBase
    implements RolePrincipal {
        private static final long serialVersionUID = 3007372614181764273L;

        private RolePrincipalImpl(String name) {
            super(name);
        }
    }

    private static abstract class PrincipalBase
    implements Comparable<Principal> {
        private final String name;

        protected PrincipalBase(String name) {
            this.name = name;
        }

        @Override
        public int compareTo(Principal o) {
            String name = this.getName();
            String otherName = o.getName();
            if (name == null) {
                if (otherName == null) {
                    return 0;
                }
                return -1;
            }
            if (otherName == null) {
                return 1;
            }
            return name.compareTo(otherName);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PrincipalBase other = (PrincipalBase)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            builder.append(" [name=");
            builder.append(this.name);
            builder.append("]");
            return builder.toString();
        }
    }
}

