/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authentication;

import java.security.Principal;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import oracle.dbtools.auth.AuthenticationResult;
import oracle.dbtools.auth.AuthenticationStatus;
import oracle.dbtools.common.service.ServiceLocator;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.MultiAssociativeArray;
import oracle.dbtools.common.util.MultiAssociativeArrays;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.plugin.api.security.AuthenticationChallenge;
import oracle.dbtools.rt.authentication.Authenticates;
import oracle.dbtools.rt.authentication.AuthenticationException;
import oracle.dbtools.rt.authentication.AuthenticationRealm;
import oracle.dbtools.rt.authentication.HttpAuthorizationHandler;
import oracle.dbtools.rt.authentication.RealmAuthenticator;
import oracle.dbtools.rt.authentication.SecurityConfig;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.WebException;

@Service
public class AuthenticationService {
    private MultiAssociativeArray<AuthenticationRealm, RealmAuthenticator> authenticators;

    public AuthenticationResult authenticate(SecurityConfig scope, CallbackHandler cb) {
        RealmAuthenticator authenticator;
        AuthenticationResult result = AuthenticationResult.unknown();
        Iterable realmAuthenticators = this.authenticators.values((Object)scope.realm());
        if (NullOrEmpty.nullOrEmpty((Iterable)realmAuthenticators)) {
            throw WebException.internalError(new IllegalStateException(), new Reason[0]);
        }
        Iterator i$ = realmAuthenticators.iterator();
        while (i$.hasNext() && AuthenticationStatus.UNKNOWN.equals((Object)(result = (authenticator = (RealmAuthenticator)i$.next()).authenticate(cb)).status())) {
        }
        return result;
    }

    public CompoundPrincipal verify(SecurityConfig scope, RequestEntity request) {
        HttpAuthorizationHandler cb = new HttpAuthorizationHandler(request);
        AuthenticationResult result = this.authenticate(scope, cb);
        if (result.isPublic()) {
            return null;
        }
        if (result.isValid()) {
            CompoundPrincipal principal = CompoundPrincipal.compound((Iterable)result);
            AuthenticationStatus status = scope.logonRealm().authorize(principal);
            if (AuthenticationStatus.VALID == status) {
                return principal;
            }
            throw this.invalidSession(request, scope, result.challenge(), status);
        }
        throw this.invalidSession(request, scope, result.challenge(), result.status());
    }

    public static Iterable<Principal> principals(Subject subject) {
        Set<Principal> principals = subject.getPrincipals();
        Principal first = (Principal)Iterables.first(principals);
        if (first instanceof CompoundPrincipal) {
            return (CompoundPrincipal)first;
        }
        return principals;
    }

    protected void activate(ServiceProperties properties) throws Exception {
        MultiAssociativeArrays.Builder authenticators = MultiAssociativeArrays.builder();
        for (RealmAuthenticator authenticator : ServiceLocator.acquireAll(RealmAuthenticator.class, (String[])new String[0])) {
            Authenticates target = authenticator.getClass().getAnnotation(Authenticates.class);
            if (target == null) continue;
            authenticators.add((Object)target.value(), (Object)authenticator);
        }
        this.authenticators = authenticators.build();
    }

    private WebException invalidSession(RequestEntity request, SecurityConfig scope, AuthenticationChallenge challenge, AuthenticationStatus status) {
        WebException exception = scope.logonRealm().notAuthorized(request, status);
        return AuthenticationException.authenticationException(exception, challenge, status);
    }
}

