/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.dbtools.migration.workbench.plugin.TeradataArb;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class TeradataPreferencePanel
extends DefaultTraversablePanel {
    private static final long serialVersionUID = 0L;
    public static final String TITLE = "Teradata";
    private static TeradataPreferencePanel s_instance = null;
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JSpinner fexpMinSessionsSpinner = new JSpinner();
    private JLabel fexpMinSessionsLabel = new JLabel();
    private SpinnerNumberModel fexpMinSessionsModel = new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1);
    private JSpinner fexpMaxSessionsSpinner = new JSpinner();
    private JLabel fexpMaxSessionsLabel = new JLabel();
    private SpinnerNumberModel fexpMaxSessionsModel = new SpinnerNumberModel(4, 1, Integer.MAX_VALUE, 1);
    private JPanel fillPanel = new JPanel();
    private boolean ignoreUpdate = false;

    public static TeradataPreferencePanel getInstance() {
        if (s_instance == null) {
            s_instance = new TeradataPreferencePanel();
        }
        return s_instance;
    }

    public void onEntry(TraversableContext traversableContext) {
        DBConfig dBConfig = DBConfig.getInstance((TraversableContext)traversableContext);
        boolean bl = dBConfig.getBoolean("TERADATAUSEFEXP");
        this.fexpMaxSessionsLabel.setEnabled(bl);
        this.fexpMaxSessionsSpinner.setEnabled(bl);
        this.fexpMaxSessionsModel.setValue(dBConfig.getInt("TERADATAFEXPMAXSESSIONS"));
        this.fexpMinSessionsLabel.setEnabled(bl);
        this.fexpMinSessionsSpinner.setEnabled(bl);
        this.fexpMinSessionsModel.setValue(dBConfig.getInt("TERADATAFEXPMINSESSIONS"));
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        DBConfig dBConfig = DBConfig.getInstance((TraversableContext)traversableContext);
        dBConfig.putBoolean("TERADATAUSEFEXP", Boolean.TRUE.booleanValue());
        dBConfig.putInt("TERADATAFEXPMAXSESSIONS", this.fexpMaxSessionsModel.getNumber().intValue());
        dBConfig.putInt("TERADATAFEXPMINSESSIONS", this.fexpMinSessionsModel.getNumber().intValue());
    }

    private void jbInit() throws Exception {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.fexpMinSessionsSpinner.setName("fexpMinSessionsSpinner");
        this.fexpMinSessionsLabel.setName("fexpMinSessionsLabel");
        this.fexpMaxSessionsSpinner.setName("fexpMaxSessionsSpinner");
        this.fexpMaxSessionsLabel.setName("fexpMaxSessionsLabel");
        this.fillPanel.setName("fillPanel");
        this.setLayout(this.gridBagLayout1);
        this.fexpMaxSessionsLabel.setText(TeradataArb.getString("TERADATA_PREFS_FEXP_MAX_SESSIONS"));
        this.fexpMaxSessionsSpinner.setModel(this.fexpMaxSessionsModel);
        this.fexpMaxSessionsSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TeradataPreferencePanel.this.sessionsMinMaxUpdated(changeEvent);
            }
        });
        this.fexpMinSessionsLabel.setText(TeradataArb.getString("TERADATA_PREFS_FEXP_MIN_SESSIONS"));
        this.fexpMinSessionsSpinner.setModel(this.fexpMinSessionsModel);
        ResourceUtils.resSpinner((JLabel)this.fexpMinSessionsLabel, (JSpinner)this.fexpMinSessionsSpinner, (String)TeradataArb.getString("TERADATA_PREFS_FEXP_MIN_SESSIONS"));
        ResourceUtils.resSpinner((JLabel)this.fexpMaxSessionsLabel, (JSpinner)this.fexpMaxSessionsSpinner, (String)TeradataArb.getString("TERADATA_PREFS_FEXP_MAX_SESSIONS"));
        this.fexpMinSessionsSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                TeradataPreferencePanel.this.sessionsMinMaxUpdated(changeEvent);
            }
        });
        this.add(this.fexpMinSessionsSpinner, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add(this.fexpMinSessionsLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add(this.fexpMaxSessionsSpinner, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add(this.fexpMaxSessionsLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.add(this.fillPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public TeradataPreferencePanel() {
        this.setHelpID("f1_dbteradatasparams_html");
        this.setDefaultTitle(TITLE);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sessionsMinMaxUpdated(ChangeEvent changeEvent) {
        if (!this.ignoreUpdate) {
            this.ignoreUpdate = true;
            try {
                Object object = changeEvent.getSource();
                if (object instanceof JSpinner) {
                    int n = this.fexpMinSessionsModel.getNumber().intValue();
                    int n2 = this.fexpMaxSessionsModel.getNumber().intValue();
                    JSpinner jSpinner = (JSpinner)object;
                    if (jSpinner.getName().equals(this.fexpMaxSessionsSpinner.getName())) {
                        if (n2 < n) {
                            this.fexpMinSessionsModel.setValue(n2);
                        }
                    } else if (jSpinner.getName().equals(this.fexpMinSessionsSpinner.getName()) && n2 < n) {
                        this.fexpMaxSessionsModel.setValue(n);
                    }
                }
            }
            finally {
                this.ignoreUpdate = false;
            }
        }
    }

    public static boolean isUseFExp() {
        DBConfig dBConfig = DBConfig.getInstance();
        return dBConfig.getBoolean("TERADATAUSEFEXP");
    }

    public static int getFexpMaxSessions() {
        DBConfig dBConfig = DBConfig.getInstance();
        return dBConfig.getInt("TERADATAFEXPMAXSESSIONS");
    }

    public static int getFexpMinSessions() {
        DBConfig dBConfig = DBConfig.getInstance();
        return dBConfig.getInt("TERADATAFEXPMINSESSIONS");
    }
}

