/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.teradata.offline;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.datamove.offline.streams.MdColumnComparator;
import oracle.dbtools.migration.datamove.offline.streams.OfflineDMSAbstract;
import oracle.dbtools.migration.teradata.offline.AbstractTeradataOfflineStream;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import org.antlr.stringtemplate.StringTemplateGroup;

public class OfflineBTEQCSVTeradataDMStream
extends AbstractTeradataOfflineStream {
    public static final String REPLACEALLSTRING = "[ \\\\/$]";
    Logger LOGGER = Logger.getLogger(MigrationUtils.class.getName());
    protected StringTemplateGroup m_templateGroup = null;
    private static final String FILENAME = "csv";
    private static final String EXTENSION = "csv";
    private static final String TYPE = "csv";
    private PrintWriter csvPW;

    public OfflineBTEQCSVTeradataDMStream(String string, MigrationPlugin migrationPlugin) {
        super(string, "csv");
        this.setPlugin(migrationPlugin);
    }

    public String getExtension() {
        return "csv";
    }

    public String getFileName() {
        return "csv";
    }

    public String getGenType() {
        return "csv";
    }

    public String getDataFileName(String string, String string2) {
        return this.getPlugin().createDataFileName(string, string2);
    }

    public String getRowDelimiter() {
        return null;
    }

    public String getFieldTerminator() {
        return null;
    }

    public ArrayList<String> getColumnList() {
        return null;
    }

    public void println(PrintWriter printWriter, String string, boolean bl) {
        try {
            printWriter.print(bl ? OfflineDMSAbstract.makeWindows((CharSequence)string) : OfflineDMSAbstract.makeUnix((CharSequence)string));
            printWriter.print(bl ? "\r\n" : "\n");
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
    }

    public void finished() {
    }

    public void start(MdConnection mdConnection, PersistenceManager persistenceManager) {
        try {
            this.setPlugin(MigrationUtils.getPluginForConnection((MdConnection)mdConnection));
        }
        catch (MigrationPluginException migrationPluginException) {
            this.LOGGER.log(Level.SEVERE, "Migration Plugin cannot be found");
        }
        this.mdConnection = mdConnection;
        this.m_persistenceManager = persistenceManager;
    }

    public void startDatabase(String string, String string2) {
        this.setCatalogDir("Teradata");
    }

    public void endDatabase() {
    }

    public void startSchema(String string, String string2) {
        this.setCatalogDir("Teradata");
        this.schemaDir = string2;
    }

    public void endSchema() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTable(String string) {
        String string2 = this.getSchemaDir() + File.separator + "data";
        OfflineBTEQCSVTeradataDMStream.setWriteDir(string2);
        String string3 = string2 + File.separator + string.replaceAll(REPLACEALLSTRING, "_") + "." + this.getExtension();
        try {
            this.csvPW = new PrintWriter(string3);
            MdColumn[] mdColumnArray = this.m_descriptor.getSourceColumns();
            Arrays.sort(mdColumnArray, new MdColumnComparator());
            String string4 = this.generateCSV(this.m_descriptor.getSourceTableName(), mdColumnArray, false);
            this.println(this.csvPW, string4, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (this.csvPW != null) {
                this.csvPW.close();
                this.csvPW = null;
            }
        }
        finally {
            if (this.csvPW != null) {
                this.csvPW.close();
                this.csvPW = null;
            }
        }
    }

    public void endTable() {
    }

    public String generateCSV(String string, MdColumn[] mdColumnArray, boolean bl) {
        String string2 = this.getTeradataPlugin().getBTEQState().generateCSV(this.getTeradataPlugin(), string, mdColumnArray);
        return string2;
    }
}

