/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.views;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.spatial.mapviewer.components.MapViewerHelper;
import oracle.dbtools.spatial.tools.ISpatialTool;
import oracle.dbtools.spatial.tools.SpatialToolRegistry;
import oracle.dbtools.spatial.views.SpatialUtil;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.controls.Toolbar;
import oracle.javatools.db.DBException;

public class SpatialViewController
implements ActionListener,
ContextMenuListener {
    private boolean modelEnable = false;
    private Toolbar geometryToolbar;
    private Toolbar baseToolbar;
    private JLabel sridLabel;

    private SpatialViewController() {
    }

    public static synchronized SpatialViewController getInstance() {
        return SingletonHolder.instance;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void menuWillShow(ContextMenu contextMenu) {
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void installToolbar(Toolbar toolbar) {
        this.baseToolbar = toolbar;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                List<String> list = SpatialToolRegistry.getTypes(0);
                for (String string : list) {
                    ISpatialTool iSpatialTool = SpatialToolRegistry.getTool(string);
                    IdeAction ideAction = iSpatialTool.getAction();
                    ideAction.setEnabled(false);
                    SpatialViewController.this.handleButton(ideAction, SpatialViewController.this.baseToolbar, iSpatialTool.isVisible());
                }
            }
        });
    }

    public void installGeometryToolbar(Toolbar toolbar, ArrayList<Component> arrayList) {
        Object object;
        this.geometryToolbar = toolbar;
        List<String> list = SpatialToolRegistry.getTypes(3);
        for (String object2 : list) {
            object = SpatialToolRegistry.getTool(object2);
            IdeAction ideAction = object.getAction();
            this.handleButton(ideAction, toolbar, object.isVisible());
        }
        for (Component component : arrayList) {
            this.geometryToolbar.addSeparator();
            if (component instanceof JComboBox) {
                object = new JPanel();
                ((JComponent)object).setPreferredSize(new Dimension(500, 20));
                this.geometryToolbar.add((Component)object);
            }
            this.geometryToolbar.add(component, (Object)"After");
        }
    }

    public void toggleToolbar() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                List<String> list = SpatialToolRegistry.getTypes();
                block6: for (String string : list) {
                    ISpatialTool iSpatialTool = SpatialToolRegistry.getTool(string);
                    if (!iSpatialTool.isAlwaysEnabled()) {
                        switch (iSpatialTool.getGroup()) {
                            case 0: {
                                continue block6;
                            }
                            case 2: {
                                continue block6;
                            }
                        }
                        if (SpatialUtil.getPanel().getSelectedTabPage().isConnectionSet()) {
                            if (!iSpatialTool.getType().equals("DELETE_QUERY_LAYER")) continue;
                            if (SpatialUtil.getTableModel().getRowCount() > 0 && SpatialUtil.getTableModel().getSelectedRowCount() == 1) {
                                iSpatialTool.setEnabled(true);
                                continue;
                            }
                            iSpatialTool.setEnabled(false);
                            continue;
                        }
                        iSpatialTool.setEnabled(false);
                        continue;
                    }
                    iSpatialTool.setEnabled(true);
                }
                SpatialUtil.getPanel().getSelectedTabPage().getCombobox().getJComboBox().setEnabled(true);
                SpatialUtil.getPanel().getSelectedModel().setEditable(true);
                try {
                    Connection connection = Connections.getInstance().getConnection(SpatialUtil.getPanel().getSelectedTabPage().getCombobox().getCurrentConnectionName());
                    if (MapViewerHelper.isConnectionValid(connection)) {
                        SpatialUtil.getPanel().getSelectedModel().setEditable(true);
                    }
                }
                catch (DBException dBException) {
                    dBException.printStackTrace();
                }
            }
        });
    }

    public void lockUI() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                List<String> list = SpatialToolRegistry.getTypes();
                for (String string : list) {
                    ISpatialTool iSpatialTool = SpatialToolRegistry.getTool(string);
                    iSpatialTool.getAction().setEnabled(false);
                }
                SpatialUtil.getPanel().getSelectedTabPage().getCombobox().getJComboBox().setEnabled(false);
                SpatialUtil.getPanel().getSelectedModel().setEditable(false);
            }
        });
    }

    private void handleButton(IdeAction ideAction, Toolbar toolbar, boolean bl) {
        JComponent jComponent = (JComponent)ideAction.getValue("BUTTON");
        jComponent = toolbar.add((ToggleAction)ideAction);
        jComponent.setVisible(bl);
        jComponent.setName(ideAction.getValue("Name").toString());
        jComponent.setFocusable(true);
        ideAction.putValue("BUTTON", (Object)jComponent);
        UIUtils.setupAccelerator((IdeAction)ideAction, (String)"oracle/dbtools/spatial/accelerators.xml");
    }

    public void setModelEnable(boolean bl) {
        this.modelEnable = bl;
    }

    private static class SingletonHolder {
        public static final SpatialViewController instance = new SpatialViewController();

        private SingletonHolder() {
        }
    }
}

