/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.mapviewer.view;

import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImagingOpException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeListener;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.spatial.SpatialArb;
import oracle.dbtools.spatial.mapviewer.ShowContextDialog;
import oracle.dbtools.spatial.mapviewer.model.MainCanvasDataSource;
import oracle.dbtools.spatial.mapviewer.model.RenderingPanelModel;
import oracle.maps.core.GeoObject;
import oracle.maps.core.Layer;
import oracle.maps.core.MapCanvas;
import oracle.maps.core.SelectionEvent;
import oracle.maps.core.SelectionListener;
import oracle.maps.layer.ui.SimpleBGLayer;
import oracle.maps.tools.FeaturePickTool;
import oracle.mdeditor.MapConstants;
import oracle.spatial.edit.layer.GeometrySetLayer;
import oracle.spatial.edit.model.AbstractDataSource;

public class RenderingPanelView
extends JPanel {
    private static final long serialVersionUID = 3992440415662781441L;
    private MapCanvas canvas;
    private transient RenderingPanelModel panelModel;
    JMenuItem geomContextMenu;
    transient FeaturePickTool pickTool;
    transient SelectionListener selListener;
    String selectedObjKey;
    int selectionCount;

    public RenderingPanelView(RenderingPanelModel renderingPanelModel) {
        this.panelModel = renderingPanelModel;
        this.canvas = new MapCanvas();
        this.initBgLayer();
        this.initContextMenu();
        this.initLsnrs();
    }

    public void initContextMenu() {
        this.geomContextMenu = new JMenuItem();
        this.geomContextMenu.setText(StringUtils.stripMnemonic((String)SpatialArb.getString("MapViewerImagePanelShowGeometryContext")));
        this.geomContextMenu.setName("ShowGeometryContextMenuItem");
        this.geomContextMenu.setAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (RenderingPanelView.this.selectedObjKey != null) {
                    ShowContextDialog showContextDialog = new ShowContextDialog((Frame)new JFrame(), true, RenderingPanelView.this.selectedObjKey, RenderingPanelView.this.panelModel.getTableModel());
                    showContextDialog.setVisible(true);
                }
            }
        });
        this.geomContextMenu.setMnemonic(StringUtils.getMnemonicKeyCode((String)SpatialArb.getString("MapViewerImagePanelShowGeometryContext")));
    }

    public void initLsnrs() {
        this.pickTool = new FeaturePickTool(this.canvas){

            public boolean handleEvent(EventObject eventObject) {
                if (eventObject instanceof MouseEvent) {
                    MouseEvent mouseEvent = (MouseEvent)eventObject;
                    int n = mouseEvent.getModifiers();
                    if (mouseEvent.getButton() == 3) {
                        n = 16;
                    }
                    if (mouseEvent.isShiftDown()) {
                        n &= 0x40;
                    }
                    MouseEvent mouseEvent2 = new MouseEvent(mouseEvent.getComponent(), mouseEvent.getID(), mouseEvent.getWhen(), n, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    super.handleEvent((EventObject)mouseEvent2);
                }
                return true;
            }
        };
        this.pickTool.setMultiSelection(false);
        this.selListener = new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                List list = null;
                Layer layer = selectionEvent.getSource();
                if (selectionEvent.getType() == 0 && layer instanceof GeometrySetLayer && layer.isVisible()) {
                    Object object;
                    GeometrySetLayer geometrySetLayer = (GeometrySetLayer)layer;
                    list = geometrySetLayer.getSelection();
                    RenderingPanelView.this.selectionCount = list.size();
                    if (RenderingPanelView.this.selectionCount > 0 && (object = ((GeoObject)list.get(0)).getKey()) instanceof String) {
                        String string;
                        RenderingPanelView.this.selectedObjKey = string = (String)object;
                    }
                } else {
                    RenderingPanelView.this.selectedObjKey = null;
                }
            }
        };
    }

    public RenderingPanelView(boolean bl) {
        super(bl);
    }

    public RenderingPanelView(LayoutManager layoutManager) {
        super(layoutManager);
    }

    public RenderingPanelView(LayoutManager layoutManager, boolean bl) {
        super(layoutManager, bl);
    }

    private void initBgLayer() {
        double[] dArray = this.panelModel.getInitialDataWindow();
        SimpleBGLayer simpleBGLayer = new SimpleBGLayer(this.canvas);
        this.canvas.setPreferredSize(this.panelModel.getInitialDimension());
        this.setDataWindow(dArray[0], dArray[1], dArray[2], dArray[3]);
        this.canvas.getLayerManager().add((Layer)simpleBGLayer, MapConstants.POSITION_BACKGROUND_LAYERS);
        ArrayList arrayList = simpleBGLayer.getMenuItems();
        for (JMenuItem jMenuItem : arrayList) {
            if (jMenuItem.getText().equals("Center here")) {
                jMenuItem.setText(StringUtils.stripMnemonic((String)SpatialArb.getString("CenterHere")));
                jMenuItem.setMnemonic(StringUtils.getMnemonicKeyCode((String)SpatialArb.getString("CenterHere")));
                jMenuItem.setName("CenterhereMenuItem");
                continue;
            }
            if (jMenuItem.getText().equals("Zoom in")) {
                jMenuItem.setText(StringUtils.stripMnemonic((String)SpatialArb.getString("ZoomIn")));
                jMenuItem.setMnemonic(StringUtils.getMnemonicKeyCode((String)SpatialArb.getString("ZoomIn")));
                jMenuItem.setName("ZoominMenuItem");
                continue;
            }
            if (!jMenuItem.getText().equals("Zoom out")) continue;
            jMenuItem.setText(StringUtils.stripMnemonic((String)SpatialArb.getString("ZoomOut")));
            jMenuItem.setMnemonic(StringUtils.getMnemonicKeyCode((String)SpatialArb.getString("ZoomOut")));
            jMenuItem.setName("ZoomoutMenuItem");
        }
    }

    public void setDataWindow(double d, double d2, double d3, double d4) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, (d3 *= 1.01) - d, (d4 *= 1.01) - d2);
        this.canvas.getMapRegion().setDataWindow((Rectangle2D)double_);
    }

    public void setChangeListener(ChangeListener changeListener) {
        this.canvas.addChangeListener(changeListener);
    }

    public void setMouseListener(MouseListener mouseListener) {
        this.canvas.addMouseListener(mouseListener);
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        this.canvas.setPopupMenu(jPopupMenu);
    }

    public void addGeometrySetLayer(Properties properties, int n, List<String> list, Map map, HashMap<String, String> hashMap) {
        boolean bl = Boolean.parseBoolean(properties.getProperty("true"));
        GeometrySetLayer geometrySetLayer = new GeometrySetLayer(){

            public boolean handleEvent(EventObject eventObject) {
                Component[] componentArray;
                boolean bl = true;
                JPopupMenu jPopupMenu = this.canvas.getPopupMenu();
                if (jPopupMenu != null && (componentArray = jPopupMenu.getComponents()) != null) {
                    ArrayList<Component> arrayList = new ArrayList<Component>(Arrays.asList(componentArray));
                    if (!arrayList.contains(RenderingPanelView.this.geomContextMenu)) {
                        RenderingPanelView.this.geomContextMenu.setText(StringUtils.stripMnemonic((String)SpatialArb.getString("MapViewerImagePanelShowGeometryContext")));
                        jPopupMenu.add(RenderingPanelView.this.geomContextMenu);
                        RenderingPanelView.this.geomContextMenu.setEnabled(true);
                        RenderingPanelView.this.geomContextMenu.setVisible(true);
                    } else if (RenderingPanelView.this.selectionCount == 1 && RenderingPanelView.this.selectedObjKey != null) {
                        RenderingPanelView.this.geomContextMenu.setEnabled(true);
                    } else {
                        RenderingPanelView.this.geomContextMenu.setEnabled(false);
                    }
                }
                return bl;
            }
        };
        MainCanvasDataSource mainCanvasDataSource = new MainCanvasDataSource((Layer)geometrySetLayer);
        mainCanvasDataSource.setLayerConnection(this.panelModel.getConnection());
        mainCanvasDataSource.setGeomKeys(list);
        mainCanvasDataSource.setGeometryMap(map);
        mainCanvasDataSource.setLabelMap(hashMap);
        boolean bl2 = mainCanvasDataSource.init(properties);
        if (!bl2) {
            System.err.println("Data layer source not initialized! :c");
        } else {
            geometrySetLayer.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.renderOnMapviewer", "false");
            geometrySetLayer.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.baseTable", "dummy");
            geometrySetLayer.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.spatialColumn", "dummy");
            geometrySetLayer.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.keyColumn", "dummy");
            geometrySetLayer.setDataSource((AbstractDataSource)mainCanvasDataSource);
            geometrySetLayer.buildDataSet();
        }
        try {
            geometrySetLayer.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.renderStyle", properties.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.renderStyle"));
            geometrySetLayer.setName(properties.getProperty("sublayer_type") + "_" + properties.getProperty("query"));
            geometrySetLayer.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.labelColumn", "label");
            geometrySetLayer.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.labelStyle", properties.getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.labelStyle"));
            this.canvas.getLayerManager().add((Layer)geometrySetLayer, Integer.valueOf(n));
        }
        catch (ImagingOpException imagingOpException) {
            imagingOpException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.canvas.getLayerManager().tag((Layer)geometrySetLayer, "dataLayer");
        this.canvas.getLayerManager().tag((Layer)geometrySetLayer, "selectionLayer");
        this.canvas.getLayerManager().add((Layer)this.pickTool, MapConstants.POSITION_OVERDATA_LAYERS);
        this.canvas.getLayerManager().addSelectionListener(this.selListener);
        double[] dArray = new double[4];
        if (properties.getProperty("layermbr_xmin") != null && properties.getProperty("layermbr_ymin") != null && properties.getProperty("layermbr_xmax") != null && properties.getProperty("layermbr_ymax") != null) {
            dArray[0] = Double.parseDouble(properties.getProperty("layermbr_xmin"));
            dArray[1] = Double.parseDouble(properties.getProperty("layermbr_ymin"));
            dArray[2] = Double.parseDouble(properties.getProperty("layermbr_xmax"));
            dArray[3] = Double.parseDouble(properties.getProperty("layermbr_ymax"));
            if (((MainCanvasDataSource)geometrySetLayer.getDataSource()).getGeomKeys().size() > 0) {
                this.setDataWindow(dArray[0], dArray[1], dArray[2], dArray[3]);
            }
        }
        geometrySetLayer.setVisible(bl);
    }

    public void setLastLayerSelectable() {
        Layer layer;
        int n;
        int n2 = this.canvas.getLayerManager().size();
        int n3 = 0;
        for (n = 1; n < n2; ++n) {
            try {
                layer = this.canvas.getLayerManager().get(n);
                if (!(layer instanceof GeometrySetLayer)) continue;
                ((GeometrySetLayer)layer).setSelection(null);
                this.canvas.getLayerManager().untag(layer, "selectionLayer");
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, indexOutOfBoundsException.getStackTrace()[0].toString(), indexOutOfBoundsException);
                continue;
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
        for (n = n2; n > 0; --n) {
            try {
                layer = this.canvas.getLayerManager().get(n);
                if (layer instanceof GeometrySetLayer) {
                    ++n3;
                    ((GeometrySetLayer)layer).setSelection(null);
                    this.canvas.getLayerManager().tag(layer, "selectionLayer");
                }
                if (n3 <= 2) continue;
                break;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, indexOutOfBoundsException.getStackTrace()[0].toString(), indexOutOfBoundsException);
                continue;
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }

    public void moveLayer(int n, int n2) {
        if (n == n2) {
            return;
        }
        int n3 = this.panelModel.getTranslatedLayerIndex(n, 0);
        int n4 = this.panelModel.getTranslatedLayerIndex(n, 1);
        int n5 = this.panelModel.getTranslatedLayerIndex(n, 2);
        int n6 = 3 * (n - n2);
        Layer layer = this.canvas.getLayerManager().get(n3);
        Layer layer2 = this.canvas.getLayerManager().get(n4);
        Layer layer3 = this.canvas.getLayerManager().get(n5);
        if (layer == null || layer2 == null || layer3 == null) {
            return;
        }
        if (n6 < 0) {
            int n7;
            n6 *= -1;
            for (n7 = 0; n7 < n6; ++n7) {
                this.canvas.getLayerManager().moveDown(layer, true);
            }
            for (n7 = 0; n7 < n6; ++n7) {
                this.canvas.getLayerManager().moveDown(layer2, true);
            }
            for (n7 = 0; n7 < n6; ++n7) {
                this.canvas.getLayerManager().moveDown(layer3, true);
            }
        } else {
            int n8;
            for (n8 = 0; n8 < n6; ++n8) {
                this.canvas.getLayerManager().moveUp(layer3, true);
            }
            for (n8 = 0; n8 < n6; ++n8) {
                this.canvas.getLayerManager().moveUp(layer2, true);
            }
            for (n8 = 0; n8 < n6; ++n8) {
                this.canvas.getLayerManager().moveUp(layer, true);
            }
        }
        this.setLastLayerSelectable();
    }

    public JPanel getMapPanel() {
        return this.canvas;
    }

    public void removeAllLayers() {
        int n = this.canvas.getLayerManager().size();
        ArrayList<Layer> arrayList = new ArrayList<Layer>();
        for (int i = 1; i < n; ++i) {
            try {
                Layer layer = this.canvas.getLayerManager().get(i);
                if (!(layer instanceof GeometrySetLayer)) continue;
                arrayList.add(layer);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.canvas.getLayerManager().removeAll(arrayList);
    }

    public void removeLayer(int n) {
        int n2 = this.panelModel.getTranslatedLayerIndex(n, 0);
        int n3 = this.panelModel.getTranslatedLayerIndex(n, 1);
        int n4 = this.panelModel.getTranslatedLayerIndex(n, 2);
        Layer layer = this.canvas.getLayerManager().get(n2);
        Layer layer2 = this.canvas.getLayerManager().get(n3);
        Layer layer3 = this.canvas.getLayerManager().get(n4);
        ArrayList<Layer> arrayList = new ArrayList<Layer>();
        arrayList.add(layer3);
        arrayList.add(layer2);
        arrayList.add(layer);
        this.canvas.getLayerManager().removeAll(arrayList);
        this.setLastLayerSelectable();
    }

    public void refreshLayers() {
        int n = this.canvas.getLayerManager().size();
        for (int i = 0; i < n; ++i) {
            this.canvas.getLayerManager().get(i).mapRegionChanged(null);
        }
    }

    public void refreshLayer(int n) {
        Layer layer = this.canvas.getLayerManager().get(n + 1);
        Layer layer2 = this.canvas.getLayerManager().get(n + 2);
        Layer layer3 = this.canvas.getLayerManager().get(n + 3);
        layer.mapRegionChanged(null);
        layer2.mapRegionChanged(null);
        layer3.mapRegionChanged(null);
    }

    public void updateLayer(Layer layer, Properties properties) {
        layer.setVisible(Boolean.parseBoolean(properties.getProperty("true")));
    }

    public MapCanvas getCanvas() {
        return this.canvas;
    }

    public String getSelectedObjKey() {
        return this.selectedObjKey;
    }

    public void clearSelectedObjKey() {
        this.selectedObjKey = null;
    }
}

