/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.dialogs.newquery.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.spatial.SpatialArb;
import oracle.dbtools.spatial.dialogs.newquery.model.NewQueryModel;
import oracle.dbtools.spatial.mapviewer.view.SpatialDelayedComboBox;
import oracle.ide.Ide;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.util.IdeUtil;
import oracle.javatools.editor.BasicEditorPane;

public class NewQueryDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JLabel areaBorderColorLabel;
    private JLabel areaFillColorLabel;
    private JPanel areaFillColorPanel;
    private JLabel areasLabel;
    private JPanel borderColorPanel;
    private JButton cancelButton;
    private JPanel curveColorPanel;
    private JLabel curvesColorLabel;
    private JLabel curvesLabel;
    private JLabel curvesWidthLabel;
    private JButton helpButton;
    private JLabel labelColorLabel;
    private JPanel labelColorPanel;
    private JLabel labelColumnLabel;
    private JComboBox labelComboBox;
    private JLabel labelLabel;
    private JSpinner lineWidthSpinner;
    private JLabel mapTitleLabel;
    private JTextField mapTitleTextField;
    private JPanel markerBorderColorPanel;
    private JLabel markerBorderLabel;
    private JComboBox markerComboBox;
    private JPanel markerFillColorPanel;
    private JLabel markerFillLabel;
    private JLabel markerLabel;
    private JLabel markerSizeLabel;
    private JButton okButton;
    private JLabel pointLabel;
    private JSpinner pointSizeSpinner;
    private JEditorPane queryEditorPane;
    private JPanel queryPanel;
    private JScrollPane queryScrollPane;
    private JPanel stylePanel;
    private NewQueryModel model;

    public NewQueryDialog(Frame frame, boolean bl, NewQueryModel newQueryModel) {
        super(frame, bl);
        this.model = newQueryModel;
        this.initComponents();
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this);
    }

    private void initComponents() {
        this.queryPanel = new JPanel();
        this.queryScrollPane = new JScrollPane();
        this.queryEditorPane = EditorFactory.createIdeEditorPane();
        this.stylePanel = new JPanel();
        this.pointLabel = new JLabel();
        this.markerLabel = new JLabel();
        this.markerComboBox = new JComboBox();
        this.markerSizeLabel = new JLabel();
        this.pointSizeSpinner = new JSpinner();
        this.markerBorderLabel = new JLabel();
        this.markerBorderColorPanel = new JPanel();
        this.curvesLabel = new JLabel();
        this.curvesWidthLabel = new JLabel();
        this.lineWidthSpinner = new JSpinner();
        this.curvesColorLabel = new JLabel();
        this.curveColorPanel = new JPanel();
        this.areasLabel = new JLabel();
        this.areaBorderColorLabel = new JLabel();
        this.borderColorPanel = new JPanel();
        this.areaFillColorLabel = new JLabel();
        this.areaFillColorPanel = new JPanel();
        this.labelLabel = new JLabel();
        this.labelComboBox = new SpatialDelayedComboBox("LabelColumnLoader", "", this.model.getComboLoader());
        this.labelColumnLabel = new JLabel();
        this.markerFillLabel = new JLabel();
        this.markerFillColorPanel = new JPanel();
        this.labelColorLabel = new JLabel();
        this.labelColorPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.mapTitleLabel = new JLabel();
        this.mapTitleTextField = new JTextField();
        this.helpButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(SpatialArb.getString("MapViewerQueryEditDialogTitle"));
        this.setModal(true);
        this.setName("newQueryDialog");
        this.setResizable(false);
        this.queryPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(128, 128, 128)), SpatialArb.getString("MapViewerQueryEditDialogTitle"), 0, 0, null, new Color(0, 0, 0)));
        this.queryPanel.setName("queryPanel");
        this.queryPanel.setBorder(BorderFactory.createTitledBorder(null, SpatialArb.getString("MapViewerQueryEditDialogMapQuery")));
        this.queryEditorPane.setName("Query text area");
        this.queryScrollPane.setViewportView(this.queryEditorPane);
        GroupLayout groupLayout = new GroupLayout(this.queryPanel);
        this.queryPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.queryScrollPane, -2, 236, -2).addGap(0, 0, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.queryScrollPane, -2, 365, -2).addGap(0, 0, Short.MAX_VALUE)));
        this.stylePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(new Color(128, 128, 128)), SpatialArb.getString("MapViewerQueryEditDialogMapStyles"), 0, 0, null, new Color(0, 0, 0)));
        this.stylePanel.setName("Style panel");
        this.pointLabel.setFont(new Font("Dialog", 1, 11));
        this.pointLabel.setText(SpatialArb.getString("NewQueryDialogPoints"));
        this.pointLabel.setName("Points title label");
        this.markerLabel.setText(SpatialArb.getString("NewQueryDialogmarkerLabel"));
        this.markerLabel.setName("Marker label");
        this.markerComboBox.setModel(new DefaultComboBoxModel<String>(this.model.getMarkerItems()));
        this.markerComboBox.setName("marker type selector");
        this.markerSizeLabel.setText(SpatialArb.getString("NewQueryDialogmarkerSizeLabel"));
        this.markerSizeLabel.setName("Size label");
        this.pointSizeSpinner.setModel(new SpinnerNumberModel((Number)8, Integer.valueOf(1), null, (Number)1));
        this.pointSizeSpinner.setName("marker size spinner");
        this.pointSizeSpinner.setValue(8);
        this.markerBorderLabel.setText(SpatialArb.getString("NewQueryDialogareaBorderColorLabel"));
        this.markerBorderLabel.setName("marker border color label");
        this.markerBorderColorPanel.setBackground(this.model.getMarker_color());
        this.markerBorderColorPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.markerBorderColorPanel.setName("markerBorderColorPanel");
        this.markerBorderColorPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                NewQueryDialog.this.markerBorderColorPanelMouseClicked(mouseEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout(this.markerBorderColorPanel);
        this.markerBorderColorPanel.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 90, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.curvesLabel.setFont(new Font("Dialog", 1, 11));
        this.curvesLabel.setText(SpatialArb.getString("NewQueryDialogcurvesLabel"));
        this.curvesLabel.setName("Curves label");
        this.curvesWidthLabel.setText(SpatialArb.getString("NewQueryDialogwidthLabel"));
        this.curvesWidthLabel.setName("Curves width label");
        this.lineWidthSpinner.setModel(new SpinnerNumberModel((Number)1, Integer.valueOf(1), null, (Number)1));
        this.lineWidthSpinner.setName("curve width spinner");
        this.lineWidthSpinner.setValue(1);
        this.curvesColorLabel.setText(SpatialArb.getString("NewQueryDialogColorLabel"));
        this.curvesColorLabel.setName("Curves color label");
        this.curveColorPanel.setBackground(this.model.getLine_color());
        this.curveColorPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.curveColorPanel.setName("curveColorPanel");
        GroupLayout groupLayout3 = new GroupLayout(this.curveColorPanel);
        this.curveColorPanel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 90, Short.MAX_VALUE));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.areasLabel.setFont(new Font("Dialog", 1, 11));
        this.areasLabel.setText(SpatialArb.getString("NewQueryDialogareasLabel"));
        this.areasLabel.setName("Areas label");
        this.areaBorderColorLabel.setText(SpatialArb.getString("NewQueryDialogareaBorderColorLabel"));
        this.areaBorderColorLabel.setName("areas border color label");
        this.borderColorPanel.setBackground(this.model.getArea_border_color());
        this.borderColorPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.borderColorPanel.setName("areaBorderColorPanel");
        GroupLayout groupLayout4 = new GroupLayout(this.borderColorPanel);
        this.borderColorPanel.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 90, Short.MAX_VALUE));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 17, Short.MAX_VALUE));
        this.areaFillColorLabel.setText(SpatialArb.getString("NewQueryDialogareaFillColorLabel"));
        this.areaFillColorLabel.setName("areas fill color label");
        this.areaFillColorPanel.setBackground(this.model.getArea_fill_color());
        this.areaFillColorPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.areaFillColorPanel.setName("areaFillColorPanel");
        GroupLayout groupLayout5 = new GroupLayout(this.areaFillColorPanel);
        this.areaFillColorPanel.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 90, Short.MAX_VALUE));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 17, Short.MAX_VALUE));
        this.labelLabel.setFont(new Font("Dialog", 1, 11));
        this.labelLabel.setText(SpatialArb.getString("NewQueryDialoglabelLabel"));
        this.labelLabel.setName("Label label");
        this.labelComboBox.setMinimumSize(new Dimension(96, 21));
        this.labelComboBox.setName("labelComboBox");
        this.labelColumnLabel.setText(SpatialArb.getString("NewQueryDialoglabelColumnLabel"));
        this.labelColumnLabel.setName("label column label");
        this.markerFillLabel.setText(SpatialArb.getString("NewQueryDialogareaFillColorLabel"));
        this.markerFillLabel.setName("marker fill color label");
        this.markerFillColorPanel.setBackground(this.model.getMarkerFillColor());
        this.markerFillColorPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.markerFillColorPanel.setName("markerFillPanel");
        this.markerFillColorPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                NewQueryDialog.this.markerFillColorPanelMouseClicked(mouseEvent);
            }
        });
        GroupLayout groupLayout6 = new GroupLayout(this.markerFillColorPanel);
        this.markerFillColorPanel.setLayout(groupLayout6);
        groupLayout6.setHorizontalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 90, Short.MAX_VALUE));
        groupLayout6.setVerticalGroup(groupLayout6.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 20, Short.MAX_VALUE));
        this.labelColorLabel.setText(SpatialArb.getString("NewQueryDialogLabelColorLabel"));
        this.labelColorLabel.setName("label color label");
        this.labelColorPanel.setBackground(this.model.getLabelColor());
        this.labelColorPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.labelColorPanel.setName("labelColorPanel");
        GroupLayout groupLayout7 = new GroupLayout(this.labelColorPanel);
        this.labelColorPanel.setLayout(groupLayout7);
        groupLayout7.setHorizontalGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        groupLayout7.setVerticalGroup(groupLayout7.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GroupLayout groupLayout8 = new GroupLayout(this.stylePanel);
        this.stylePanel.setLayout(groupLayout8);
        groupLayout8.setHorizontalGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout8.createSequentialGroup().addContainerGap().addGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pointLabel).addComponent(this.areasLabel).addGroup(groupLayout8.createSequentialGroup().addGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout8.createSequentialGroup().addGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.markerLabel).addComponent(this.curvesWidthLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.markerComboBox, -2, -1, -2).addComponent(this.lineWidthSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.markerSizeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pointSizeSpinner, -2, -1, -2)).addGroup(groupLayout8.createSequentialGroup().addGap(12, 12, 12).addGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.areaBorderColorLabel).addComponent(this.labelColumnLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.borderColorPanel, -1, -1, Short.MAX_VALUE).addComponent(this.labelComboBox, 0, -1, Short.MAX_VALUE)))).addGap(12, 12, Short.MAX_VALUE).addGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.labelColorLabel).addComponent(this.areaFillColorLabel).addComponent(this.curvesColorLabel).addComponent(this.markerFillLabel).addComponent(this.markerBorderLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.labelColorPanel, -1, -1, Short.MAX_VALUE).addComponent(this.areaFillColorPanel, -2, -1, -2).addComponent(this.curveColorPanel, -2, -1, -2).addComponent(this.markerFillColorPanel, -2, -1, -2).addComponent(this.markerBorderColorPanel, -2, -1, -2)).addGap(8, 8, 8)).addComponent(this.labelLabel).addComponent(this.curvesLabel)).addContainerGap(16, Short.MAX_VALUE)));
        groupLayout8.setVerticalGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout8.createSequentialGroup().addContainerGap().addComponent(this.pointLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.markerBorderColorPanel, -1, -1, Short.MAX_VALUE).addGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.markerLabel).addComponent(this.markerComboBox, -2, -1, -2).addComponent(this.markerSizeLabel).addComponent(this.pointSizeSpinner, -2, -1, -2).addComponent(this.markerBorderLabel))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.markerFillLabel).addComponent(this.markerFillColorPanel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.curvesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.curvesWidthLabel).addComponent(this.lineWidthSpinner, -2, -1, -2).addComponent(this.curvesColorLabel)).addComponent(this.curveColorPanel, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addComponent(this.areasLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.areaBorderColorLabel).addComponent(this.borderColorPanel, -2, -1, -2).addComponent(this.areaFillColorLabel).addComponent(this.areaFillColorPanel, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.labelLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(groupLayout8.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelComboBox, -2, -1, -2).addComponent(this.labelColumnLabel).addComponent(this.labelColorLabel)).addComponent(this.labelColorPanel, -1, -1, Short.MAX_VALUE)).addGap(103, 103, 103)));
        this.okButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)SpatialArb.getString("MapViewerQueryEditDialogOK")));
        this.okButton.setText(StringUtils.stripMnemonic((String)SpatialArb.getString("MapViewerQueryEditDialogOK")));
        this.okButton.setName("OK button");
        this.cancelButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)SpatialArb.getString("MapViewerQueryEditDialogCancel")));
        this.cancelButton.setText(StringUtils.stripMnemonic((String)SpatialArb.getString("MapViewerQueryEditDialogCancel")));
        this.cancelButton.setName("cancel button");
        this.mapTitleLabel.setText(SpatialArb.getString("MapViewerQueryEditDialogMapTitle"));
        this.mapTitleLabel.setName("Map title label");
        this.mapTitleTextField.setName("Map title textfield");
        this.helpButton.setText(StringUtils.stripMnemonic((String)SpatialArb.getString("MapViewerQueryEditDialogHelp")));
        this.helpButton.setName("Help button");
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewQueryDialog.this.helpButtonActionPerformed(actionEvent);
            }
        });
        this.helpButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)SpatialArb.getString("MapViewerQueryEditDialogHelp")));
        GroupLayout groupLayout9 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout9);
        groupLayout9.setHorizontalGroup(groupLayout9.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout9.createSequentialGroup().addContainerGap().addGroup(groupLayout9.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout9.createSequentialGroup().addComponent(this.helpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton, -2, 95, -2).addGap(43, 43, 43).addComponent(this.cancelButton, -2, 95, -2)).addGroup(groupLayout9.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(groupLayout9.createSequentialGroup().addComponent(this.queryPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stylePanel, -2, -1, -2)).addGroup(groupLayout9.createSequentialGroup().addComponent(this.mapTitleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mapTitleTextField)))).addContainerGap(45, Short.MAX_VALUE)));
        groupLayout9.setVerticalGroup(groupLayout9.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout9.createSequentialGroup().addContainerGap().addGroup(groupLayout9.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.mapTitleLabel).addComponent(this.mapTitleTextField, -2, -1, -2)).addGap(15, 15, 15).addGroup(groupLayout9.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.queryPanel, -2, -1, -2).addComponent(this.stylePanel, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(groupLayout9.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout9.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton)).addComponent(this.helpButton)).addContainerGap(35, Short.MAX_VALUE)));
        this.pack();
    }

    private void helpButtonActionPerformed(ActionEvent actionEvent) {
    }

    private void markerFillColorPanelMouseClicked(MouseEvent mouseEvent) {
    }

    private void markerBorderColorPanelMouseClicked(MouseEvent mouseEvent) {
    }

    public BasicEditorPane getQueryEditorPane() {
        return (BasicEditorPane)this.queryEditorPane;
    }

    public void setOkButtonListener(ActionListener actionListener) {
        this.okButton.addActionListener(actionListener);
    }

    public void setCancelButtonListener(ActionListener actionListener) {
        this.cancelButton.addActionListener(actionListener);
    }

    public void setHelpButtonListener(MouseListener mouseListener) {
        this.helpButton.addMouseListener(mouseListener);
    }

    public void setHelpButtonActionListener(ActionListener actionListener) {
        this.helpButton.addActionListener(actionListener);
    }

    public void setMarkerColorPanelListener(MouseListener mouseListener) {
        this.markerBorderColorPanel.addMouseListener(mouseListener);
    }

    public void setMarKerColorPanelKeyListener(KeyListener keyListener) {
        this.markerBorderColorPanel.addKeyListener(keyListener);
    }

    public void setMarkerFillPanelListener(MouseListener mouseListener) {
        this.markerFillColorPanel.addMouseListener(mouseListener);
    }

    public void setCurveColorPanelListener(MouseListener mouseListener) {
        this.curveColorPanel.addMouseListener(mouseListener);
    }

    public void setCurveColorPanelKeyListener(KeyListener keyListener) {
        this.curveColorPanel.addKeyListener(keyListener);
    }

    public void setBorderColorPanelListener(MouseListener mouseListener) {
        this.borderColorPanel.addMouseListener(mouseListener);
    }

    public void setBorderColorPanelKeyListener(KeyListener keyListener) {
        this.borderColorPanel.addKeyListener(keyListener);
    }

    public void setAreaFillColorPanelListener(MouseListener mouseListener) {
        this.areaFillColorPanel.addMouseListener(mouseListener);
    }

    public void setAreaFillColorPanelKeyListener(KeyListener keyListener) {
        this.areaFillColorPanel.addKeyListener(keyListener);
    }

    public void setQueryAreaKeyListener(KeyListener keyListener) {
        this.queryEditorPane.addKeyListener(keyListener);
    }

    public void setLabelComboBoxKeyListener(KeyListener keyListener) {
        this.labelComboBox.addKeyListener(keyListener);
    }

    public void setLabelComboBoxClickListener(MouseListener mouseListener) {
        this.labelComboBox.addMouseListener(mouseListener);
    }

    public void setLabelColoPanelClickListener(MouseListener mouseListener) {
        this.labelColorPanel.addMouseListener(mouseListener);
    }

    public void setLabelColorPanelKeyListener(KeyListener keyListener) {
        this.labelColorPanel.addKeyListener(keyListener);
    }

    public SpatialDelayedComboBox getDelayedComboBox() {
        return (SpatialDelayedComboBox)this.labelComboBox;
    }

    public String getQueryText() {
        return this.queryEditorPane.getText().trim();
    }

    public String getTitleText() {
        return this.mapTitleTextField.getText().trim();
    }

    public String getLabelColumn() {
        return (String)this.labelComboBox.getSelectedItem();
    }

    public Color getMarkerBorderColor() {
        return this.markerBorderColorPanel.getBackground();
    }

    public Color getMarkerFillColor() {
        return this.markerFillColorPanel.getBackground();
    }

    public int getMarkerSize() {
        return (Integer)this.pointSizeSpinner.getValue();
    }

    public String getMarkerType() {
        return (String)this.markerComboBox.getSelectedItem();
    }

    public Color getCurveColor() {
        return this.curveColorPanel.getBackground();
    }

    public int getCurveWidth() {
        return (Integer)this.lineWidthSpinner.getValue();
    }

    public Color getAreaBorderColor() {
        return this.borderColorPanel.getBackground();
    }

    public Color getAreaFillColor() {
        return this.areaFillColorPanel.getBackground();
    }

    public Color getLabelColor() {
        return this.labelColorPanel.getBackground();
    }
}

