/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.dialogs.metadata.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.controls.PropertyPanel;
import oracle.dbtools.raptor.images.RaptorImage;
import oracle.dbtools.spatial.SpatialArb;
import oracle.dbtools.spatial.dialogs.metadata.model.SpatialDimension;
import oracle.dbtools.spatial.dialogs.metadata.model.SpatialMetadataModel;
import oracle.dbtools.spatial.dialogs.metadata.model.SpatialTableModel;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.util.IdeUtil;

public class SpatialMetadataView {
    private static final int FIELD_WIDTH = 150;
    private static final int FIELD_HEIGHT = 20;
    private static final int VAL_ERROR_DIM_BOUNDARIES = 1;
    private static final int VAL_ERROR_DIM_NOT_NUMERIC = 2;
    private static final int VAL_ERROR_SRID_NOT_NUMERIC = 3;
    private static final int VAL_ERROR_TOLERANCE_NOT_POS = 4;
    private static final int VAL_ERROR_DIM_NAME_LENGHT = 5;
    private Dimension defaultSize = new Dimension(150, 20);
    private JTable dimTable = null;
    private JButton btnAddDimension = new JButton(RaptorImage.getIcon((String)SpatialArb.getString("SpatialAddIcon")));
    private JButton btnRemoveDimension = new JButton(RaptorImage.getIcon((String)SpatialArb.getString("SpatialRemoveIcon")));
    private JComboBox<String> spatialColumn = new JComboBox();
    private JTextField srid = new JTextField();
    JPanel mainPanel = null;
    JTextField tfName = new JTextField();
    JTextField spatialIndex = new JTextField();
    private SpatialMetadataModel model;
    private JEWTDialog dlg = null;

    public SpatialMetadataView(SpatialMetadataModel spatialMetadataModel) {
        this.model = spatialMetadataModel;
    }

    private JPanel createRow(JLabel jLabel, Component component) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jLabel, "West");
        jPanel.add(component, "Center");
        return jPanel;
    }

    public void updatePanel() {
        this.dimTable.updateUI();
        this.srid.setText(this.model.getSpatialRefID());
        this.spatialIndex.setText(this.model.getSpatialIndex());
    }

    public void updateDimensionPanel() {
        this.dimTable.updateUI();
    }

    public void enableSpatialColumn(boolean bl) {
        this.spatialColumn.setEnabled(bl);
    }

    public void createMainPanel() {
        this.mainPanel = new JPanel(new BorderLayout(10, 10));
        this.mainPanel.setBorder(BorderFactory.createTitledBorder(SpatialArb.getString("SpatialProperties")));
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        JPanel jPanel2 = new JPanel(new GridLayout(0, 1, 10, 10));
        JLabel jLabel = new JLabel(SpatialArb.getString("SpatialTableName"));
        jLabel.setPreferredSize(this.defaultSize);
        this.tfName.setPreferredSize(this.defaultSize);
        this.tfName.setEnabled(false);
        jPanel2.add(this.createRow(jLabel, this.tfName));
        JLabel jLabel2 = new JLabel(SpatialArb.getString("SpatialIndexName"));
        jLabel2.setPreferredSize(this.defaultSize);
        this.spatialIndex.setPreferredSize(this.defaultSize);
        this.spatialIndex.setEnabled(false);
        jPanel2.add(this.createRow(jLabel2, this.spatialIndex));
        JLabel jLabel3 = new JLabel(StringUtils.stripMnemonic((String)SpatialArb.getString("SpatialColumnName")));
        jLabel3.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)SpatialArb.getString("SpatialColumnName")));
        jLabel3.setPreferredSize(this.defaultSize);
        this.spatialColumn.setPreferredSize(this.defaultSize);
        this.spatialColumn.setEditable(true);
        jLabel3.setLabelFor(this.spatialColumn);
        jPanel2.add(this.createRow(jLabel3, this.spatialColumn));
        JLabel jLabel4 = new JLabel(StringUtils.stripMnemonic((String)SpatialArb.getString("SpatialReferenceName")));
        jLabel4.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)SpatialArb.getString("SpatialReferenceName")));
        jLabel4.setPreferredSize(this.defaultSize);
        this.srid.setPreferredSize(this.defaultSize);
        this.srid.setEditable(true);
        jLabel4.setLabelFor(this.srid);
        jPanel2.add(this.createRow(jLabel4, this.srid));
        this.dimTable = new JTable(new SpatialTableModel(this.model.getDimensionList()));
        this.dimTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.dimTable.setSelectionMode(0);
        this.dimTable.setGridColor(Color.gray);
        JScrollPane jScrollPane = new JScrollPane(this.dimTable);
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2));
        jPanel3.setPreferredSize(new Dimension(400, 20));
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setBorder(BorderFactory.createTitledBorder(SpatialArb.getString("SpatialDimensions")));
        this.btnAddDimension.setToolTipText(SpatialArb.getString("SpatialAddTooltip"));
        this.btnRemoveDimension.setToolTipText(SpatialArb.getString("SpatialRemoveTooltip"));
        JToolBar jToolBar = new JToolBar(0);
        jToolBar.setFloatable(false);
        jToolBar.add(this.btnAddDimension);
        jToolBar.add(this.btnRemoveDimension);
        jPanel3.add(jToolBar);
        jPanel4.add((Component)jPanel3, "North");
        jScrollPane.setPreferredSize(new Dimension(325, 100));
        jPanel4.add(jScrollPane);
        jPanel.add((Component)jPanel2, "North");
        this.mainPanel.add((Component)jPanel, "North");
        this.mainPanel.add((Component)jPanel4, "Center");
        this.mainPanel.setBackground(UIManager.getColor("EWTDialog.background"));
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public void decorateMainPanel() {
        String string;
        this.btnRemoveDimension.setEnabled(true);
        this.btnAddDimension.setEnabled(true);
        this.tfName.setText(this.model.getTableName());
        this.spatialIndex.setText(this.model.getSpatialIndex());
        this.spatialColumn.removeAllItems();
        if (this.model.getIsColumnSelected()) {
            if (this.model.isSingleColumnSpatial()) {
                string = this.model.getCurrentColumn();
                this.spatialColumn.addItem(string);
                this.spatialColumn.setSelectedItem(string);
            }
        } else {
            for (int i = 0; i < this.model.getSpatialColumnSize(); ++i) {
                this.spatialColumn.addItem(this.model.getSpatialColumn(i));
            }
        }
        this.srid.setText(this.model.getSpatialRefID());
        string = null;
        if (!this.model.getIsColumnSelected() && (string = this.model.getFirstColumn()) != null) {
            this.spatialColumn.setSelectedItem(string);
        }
        this.updateDimensionPanel();
        if (this.model.getDimensionSize() == 0) {
            this.btnRemoveDimension.setEnabled(false);
        }
        if (this.model.getDimensionSize() == 4) {
            this.btnAddDimension.setEnabled(false);
        }
    }

    public String getSpatialColumnValue() {
        return (String)this.spatialColumn.getSelectedItem();
    }

    public String getSrid() {
        return this.srid.getText();
    }

    public void setSrid(String string) {
        this.srid.setText(string);
    }

    public int getDimensionRow() {
        return this.dimTable.getSelectedRow();
    }

    public boolean isDimensionAddEnabled() {
        return this.btnAddDimension.isEnabled();
    }

    public void setDimensionAddEnabled(boolean bl) {
        this.btnAddDimension.setEnabled(bl);
    }

    public boolean isDimensionRemoveEnabled() {
        return this.btnRemoveDimension.isEnabled();
    }

    public void setDimensionRemoveEnabled(boolean bl) {
        this.btnRemoveDimension.setEnabled(bl);
    }

    public void addSpatialColumnBoxListener(ActionListener actionListener) {
        this.spatialColumn.addActionListener(actionListener);
    }

    public void addDimensionAddListener(ActionListener actionListener) {
        this.btnAddDimension.addActionListener(actionListener);
    }

    public void addDimensionRemoveListener(ActionListener actionListener) {
        this.btnRemoveDimension.addActionListener(actionListener);
    }

    public void addSridListener(DocumentListener documentListener) {
        this.srid.getDocument().addDocumentListener(documentListener);
    }

    public void removeSpatialColumnBoxListener(ActionListener actionListener) {
        this.spatialColumn.removeActionListener(actionListener);
    }

    public void removeDimensionAddListener(ActionListener actionListener) {
        this.btnAddDimension.removeActionListener(actionListener);
    }

    public void removeDimensionRemoveListener(ActionListener actionListener) {
        this.btnRemoveDimension.removeActionListener(actionListener);
    }

    public void removeSridListener(DocumentListener documentListener) {
        this.srid.getDocument().removeDocumentListener(documentListener);
    }

    public boolean checkInput() {
        Vector<Integer> vector = new Vector<Integer>();
        String string = this.model.getSpatialRefID();
        if (string.length() > 0) {
            try {
                Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                vector.add(3);
            }
        }
        Vector vector2 = this.model.getDimensionList();
        try {
            for (int i = 0; i < this.model.getDimensionSize(); ++i) {
                Double d;
                SpatialDimension spatialDimension = (SpatialDimension)vector2.elementAt(i);
                if (spatialDimension.getName().length() > 64) {
                    vector.add(5);
                }
                try {
                    d = Double.parseDouble(spatialDimension.getLowBoundary());
                    Double d2 = Double.parseDouble(spatialDimension.getUpperBoundary());
                    if (d > d2) {
                        vector.add(1);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    vector.add(2);
                }
                try {
                    d = Double.parseDouble(spatialDimension.getTolerance());
                    if (!(d <= 0.0)) continue;
                    vector.add(4);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    vector.add(2);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            vector.add(2);
        }
        if (vector.size() > 0) {
            this.showErrorDlg(vector);
            return false;
        }
        return true;
    }

    private void showErrorDlg(Vector vector) {
        PropertyPanel propertyPanel = new PropertyPanel();
        String string = SpatialArb.getString("SpatialError");
        String string2 = "<html><br>The following errors were encountered:</br>";
        if (vector.contains(3)) {
            string2 = string2 + "<br>" + SpatialArb.getString("SpatialErrorInInputForSRID") + "</br>";
        }
        if (vector.contains(4)) {
            string2 = string2 + "<br>" + SpatialArb.getString("SpatialErrorInInputForTolerance") + "</br>";
        }
        if (vector.contains(1)) {
            string2 = string2 + "<br>" + SpatialArb.getString("SpatialErrorInInputForBounds") + "</br>";
        }
        if (vector.contains(2)) {
            string2 = string2 + "<br>" + SpatialArb.getString("SpatialerrorInInputforNotNumericDim") + "</br>";
        }
        if (vector.contains(5)) {
            string2 = string2 + "<br>" + SpatialArb.getString("SpatialErrorInInputForDimensionNameLen") + "</br>";
        }
        string2 = string2 + "</html>";
        JLabel jLabel = new JLabel(string2);
        propertyPanel.addSingleComp((JComponent)jLabel);
        propertyPanel.setBackground(UIManager.getColor("EWTDialog.background"));
        this.dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)propertyPanel, null, (String)string, (int)1);
        this.dlg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SpatialMetadataView.this.dlg.dispose();
            }
        });
        Dimension dimension = propertyPanel.getPreferredSize();
        int n = (int)dimension.getHeight() + 100;
        int n2 = (int)dimension.getWidth() + 100;
        this.dlg.setSize(n2, n);
        this.dlg.setPreferredSize(n2, n);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.dlg);
        this.dlg.setVisible(true);
    }
}

