/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.dialogs.metadata.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.spatial.SpatialUtils;
import oracle.dbtools.spatial.dialogs.metadata.model.SpatialDimension;

public class ProcessSQL {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getSpatialColumns(DBObject dBObject) {
        Vector<String> vector;
        block8: {
            vector = new Vector<String>();
            ResultSet resultSet = null;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Connection connection = dBObject.getConnection();
            String string = dBObject.getObjectName();
            String string2 = dBObject.getSchemaName();
            if (Connections.getInstance().lock(connection)) {
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(false);
                    String string3 = SpatialUtils.getQuery("spatialcols", connection);
                    hashMap.put("OWNER_NAME", string2);
                    hashMap.put("TABLE_NAME", string);
                    resultSet = dBUtil.executeOracleQuery(string3, hashMap);
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            String string4 = resultSet.getString("COLUMN_NAME");
                            vector.add(string4);
                        }
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    break block8;
                }
                finally {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getSpatialDimensions(DBObject dBObject, String string) {
        Vector<SpatialDimension> vector;
        block8: {
            vector = new Vector<SpatialDimension>();
            ResultSet resultSet = null;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Connection connection = dBObject.getConnection();
            String string2 = dBObject.getObjectName();
            String string3 = dBObject.getSchemaName();
            if (Connections.getInstance().lock(connection)) {
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(false);
                    String string4 = SpatialUtils.getQuery("spatialmetadatadims", connection);
                    hashMap.put("OWNER_NAME", string3);
                    hashMap.put("TABLE_NAME", string2);
                    hashMap.put("COLUMN_NAME", string);
                    resultSet = dBUtil.executeOracleQuery(string4, hashMap);
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            SpatialDimension spatialDimension = new SpatialDimension();
                            String string5 = resultSet.getString("SDO_DIMNAME");
                            Double d = resultSet.getDouble("SDO_LB");
                            Double d2 = resultSet.getDouble("SDO_UB");
                            Double d3 = resultSet.getDouble("SDO_TOLERANCE");
                            spatialDimension.setName(string5);
                            spatialDimension.setLowBoundary(d.toString());
                            spatialDimension.setUpperBoundary(d2.toString());
                            spatialDimension.setTolerance(d3.toString());
                            vector.add(spatialDimension);
                        }
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    break block8;
                }
                finally {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSpatialSRID(DBObject dBObject, String string) {
        String string2;
        block9: {
            ResultSet resultSet = null;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Connection connection = dBObject.getConnection();
            String string3 = dBObject.getObjectName();
            String string4 = dBObject.getSchemaName();
            string2 = "";
            if (Connections.getInstance().lock(connection)) {
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(false);
                    String string5 = SpatialUtils.getQuery("spatialmetadatasrid", connection);
                    hashMap.put("OWNER_NAME", string4);
                    hashMap.put("TABLE_NAME", string3);
                    hashMap.put("COLUMN_NAME", string);
                    resultSet = dBUtil.executeOracleQuery(string5, hashMap);
                    if (resultSet != null && resultSet.next()) {
                        if (resultSet.getObject("SRID") == null) {
                            string2 = "";
                        } else {
                            Integer n = resultSet.getInt("SRID");
                            string2 = n.toString();
                        }
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    break block9;
                }
                finally {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSpatialIndex(DBObject dBObject, String string) {
        String string2;
        block7: {
            ResultSet resultSet = null;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Connection connection = dBObject.getConnection();
            String string3 = dBObject.getObjectName();
            String string4 = dBObject.getSchemaName();
            string2 = "";
            if (Connections.getInstance().lock(connection)) {
                try {
                    DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                    dBUtil.setRaiseError(false);
                    String string5 = SpatialUtils.getQuery("spatialindex", connection);
                    hashMap.put("OWNER_NAME", string4);
                    hashMap.put("TABLE_NAME", string3);
                    hashMap.put("COLUMN_NAME", string);
                    resultSet = dBUtil.executeOracleQuery(string5, hashMap);
                    if (resultSet != null && resultSet.next()) {
                        string2 = resultSet.getString("INDEX_NAME");
                    }
                    DBUtil.closeResultSet((ResultSet)resultSet);
                }
                catch (SQLException sQLException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                    break block7;
                }
                finally {
                    DBUtil.closeResultSet(resultSet);
                    Connections.getInstance().unlock(connection);
                }
                Connections.getInstance().unlock(connection);
            }
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSpatialMetadata(DBObject dBObject, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = dBObject.getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                String string2 = SpatialUtils.getQuery("deletespatialmetadata", connection);
                hashMap.put("TABLE_NAME", dBObject.getObjectName());
                hashMap.put("COLUMN_NAME", string);
                dBUtil.executeUpdate(string2, hashMap);
                if (connection.getAutoCommit()) {
                    connection.commit();
                }
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertSpatialMetadata(DBObject dBObject, String string, Vector vector, String string2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Connection connection = dBObject.getConnection();
        SpatialDimension spatialDimension = null;
        String string3 = "";
        if (Connections.getInstance().lock(connection)) {
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                for (int i = 0; i < vector.size(); ++i) {
                    spatialDimension = (SpatialDimension)vector.elementAt(i);
                    if (i != 0) {
                        string3 = string3 + ",";
                    }
                    string3 = string3 + "MDSYS.SDO_DIM_ELEMENT(" + "'" + spatialDimension.getName() + "'" + "," + spatialDimension.getLowBoundary() + "," + spatialDimension.getUpperBoundary() + "," + spatialDimension.getTolerance() + ")";
                }
                String string4 = "MDSYS.SDO_DIM_ARRAY(" + string3 + ")";
                String string5 = SpatialUtils.getQuery("insertspatialmetadata", connection);
                String string6 = SpatialUtils.replaceAll(string5, "<DIMS>", string4);
                hashMap.put("TABLE_NAME", dBObject.getObjectName());
                hashMap.put("COLUMN_NAME", string);
                if (string2.length() == 0) {
                    hashMap.put("SRID", null);
                } else {
                    try {
                        Integer n = Integer.parseInt(string2);
                        hashMap.put("SRID", n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        hashMap.put("SRID", null);
                    }
                }
                dBUtil.executeUpdate(string6, hashMap);
                if (connection.getAutoCommit()) {
                    connection.commit();
                }
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
    }
}

