/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf.was;

import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagement;
import com.ibm.websphere.management.application.AppManagementProxy;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import oracle.jrf.InternalJrfUtils;
import oracle.jrf.JRFService;
import oracle.jrf.JrfUtils;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.ServerPlatformSupportFactory;
import oracle.jrf.i18n.JRFMessageBundleHelper;
import oracle.jrf.templates.Application;
import oracle.jrf.templates.EnvConfig;
import oracle.jrf.templates.JRFTemplateHelper;
import oracle.jrf.templates.Library;
import oracle.jrf.templates.StartupClass;
import oracle.jrf.templates.URLProvider;
import oracle.jrf.was.WasJRFUtils;

public class WasJRFService
extends JRFService {
    protected static String CONFIG_GROUP_XML = "config-groups.xml";
    private static String ORACLE_JDBC_DRIVER_PATH = "ORACLE_JDBC_DRIVER_PATH";
    private static String OJDBC_JAR_NAME = "${COMMON_COMPONENTS_HOME}/modules/oracle.jdbc_11.1.1/ojdbc6.jar";
    protected static String NAME_TAG = "name";
    private static String CLASSPATH_TAG = "classPath";
    public static String DMGR_SERVER = "dmgr";
    public static String ORACLE_ADMIN_SERVER = "OracleAdminServer";
    private Logger logger = Logger.getLogger(JrfUtils.JRF_LOGGER);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyJRF(String target) throws Exception {
        Session configSession = new Session();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        try {
            if (target.equals("*")) {
                this.applyToAllStandAloneServers(configService, configSession);
                this.applyToAllClusters(configService, configSession);
            } else {
                ObjectName targetId = this.getIdFromPath(configService, configSession, target);
                if (targetId.toString().indexOf("/clusters") != -1) {
                    this.applyJRFToCluster(configService, configSession, targetId);
                } else {
                    this.applyJRFToServer(configService, configSession, targetId);
                }
            }
            configService.save(configSession, false);
        }
        finally {
            configService.discard(configSession);
        }
    }

    @Override
    public boolean checkIfJRFApplied(String target) throws Exception {
        Session configSession = new Session();
        ConfigService configService = ConfigServiceFactory.getConfigService();
        ObjectName targetId = this.getIdFromPath(configService, configSession, target);
        if (WasJRFUtils.isDmgrServer(targetId)) {
            return this.verifyJrfDmgr(configService, configSession, targetId);
        }
        if (targetId.toString().indexOf("/clusters") != -1) {
            return this.verifyJrfCluster(configService, configSession, targetId);
        }
        if (this.verifyJrfServer(configService, configSession, targetId)) {
            return true;
        }
        String clusterName = (String)configService.getAttribute(configSession, targetId, "clusterName");
        if (clusterName != null && !clusterName.equals("")) {
            String cellName = WasJRFUtils.getCellNameFromId(targetId);
            ObjectName clusterId = this.getIdFromPath(configService, configSession, "Cell=" + cellName + ":ServerCluster=" + clusterName);
            return this.verifyJrfCluster(configService, configSession, clusterId);
        }
        return false;
    }

    private boolean verifyJrfCluster(ConfigService service, Session session, ObjectName targetId) throws Exception {
        return this.verifyLibraries(service, session, targetId);
    }

    private boolean verifyJrfServer(ConfigService service, Session session, ObjectName targetId) throws Exception {
        if (!this.verifyCustomServices(service, session, targetId)) {
            return false;
        }
        return this.verifyLibraries(service, session, targetId);
    }

    private boolean verifyJrfDmgr(ConfigService service, Session session, ObjectName targetId) throws Exception {
        if (!this.verifyCustomServices(service, session, targetId)) {
            return false;
        }
        return this.verifyApplications(service, session, targetId);
    }

    private boolean verifyCustomServices(ConfigService service, Session session, ObjectName targetId) throws Exception {
        ObjectName customServiceQuery = ConfigServiceHelper.createObjectName(null, (String)"CustomService", null);
        HashSet<String> installedCustomServices = new HashSet<String>();
        for (ObjectName customService : service.queryConfigObjects(session, targetId, customServiceQuery, null)) {
            installedCustomServices.add((String)service.getAttribute(session, customService, "displayName"));
        }
        for (StartupClass jrfCustomService : WasJRFUtils.getJRFCustomServicesFromTemplate(targetId)) {
            if (installedCustomServices.contains(jrfCustomService.getName())) continue;
            this.logger.log(Level.WARNING, JRFMessageBundleHelper.msg.getString("JRF-20009", new String[]{"customService", jrfCustomService.getName(), targetId.toString()}));
            return false;
        }
        return true;
    }

    private boolean verifyLibraries(ConfigService service, Session session, ObjectName targetId) throws Exception {
        ObjectName libQuery = ConfigServiceHelper.createObjectName(null, (String)"Library", null);
        HashSet<String> installedLibs = new HashSet<String>();
        for (ObjectName lib : service.queryConfigObjects(session, targetId, libQuery, null)) {
            installedLibs.add(ConfigServiceHelper.getDisplayName((ObjectName)lib));
        }
        for (Library jrfLib : WasJRFUtils.getJRFLibrariesFromTemplate(targetId)) {
            if (installedLibs.contains(jrfLib.getName())) continue;
            this.logger.log(Level.WARNING, JRFMessageBundleHelper.msg.getString("JRF-20009", new String[]{"library", jrfLib.getName(), targetId.toString()}));
            return false;
        }
        return true;
    }

    private boolean verifyApplications(ConfigService service, Session session, ObjectName targetId) throws Exception {
        String targetName = ConfigServiceHelper.getDisplayName((ObjectName)targetId);
        for (Application jrfApp : WasJRFUtils.getJRFApplicationsFromTemplate(targetId)) {
            boolean deployed = false;
            ObjectName rootID = service.resolve(session, "Deployment=" + jrfApp.getName())[0];
            for (ObjectName target : (List)service.getAttribute(session, rootID, "deploymentTargets", false)) {
                if (!targetName.equals(ConfigServiceHelper.getDisplayName((ObjectName)target))) continue;
                deployed = true;
                break;
            }
            if (deployed) continue;
            this.logger.log(Level.WARNING, JRFMessageBundleHelper.msg.getString("JRF-20009", new String[]{"application", jrfApp.getName(), targetId.toString()}));
            return false;
        }
        return true;
    }

    private void applyToAllStandAloneServers(ConfigService service, Session session) throws Exception {
        ObjectName cellsQuery = ConfigServiceHelper.createObjectName(null, (String)"Cell");
        for (ObjectName cellId : service.queryConfigObjects(session, null, cellsQuery, null)) {
            if (!this.isCellJrfEnabled(service, session, cellId)) {
                throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20025", new String[0]));
            }
            for (ObjectName serverId : this.getApplicationServerIds(service, session, cellId)) {
                String clusterName = (String)service.getAttribute(session, serverId, "clusterName");
                if (clusterName != null && !clusterName.equals("")) continue;
                this.applyJRFToServer(service, session, serverId);
            }
        }
    }

    private void applyToAllClusters(ConfigService service, Session session) throws Exception {
        ObjectName clustersQuery = ConfigServiceHelper.createObjectName(null, (String)"ServerCluster");
        for (ObjectName clusterId : service.queryConfigObjects(session, null, clustersQuery, null)) {
            this.applyJRFToCluster(service, session, clusterId);
        }
    }

    private void applyJRFToServer(ConfigService service, Session session, ObjectName targetId) throws Exception {
        List<StartupClass> customServiceList;
        String cellName = WasJRFUtils.getCellNameFromId(targetId);
        ObjectName cellId = this.getIdFromPath(service, session, "Cell=" + cellName);
        String nodeName = WasJRFUtils.getNodeNameFromId(targetId);
        String serverName = ConfigServiceHelper.getDisplayName((ObjectName)targetId);
        String clusterName = (String)service.getAttribute(session, targetId, "clusterName");
        if (clusterName != null && !clusterName.equals("")) {
            ObjectName clusterId = this.getIdFromPath(service, session, "Cell=" + cellName + ":ServerCluster=" + clusterName);
            this.applyJRFToCluster(service, session, clusterId);
        }
        if (this.isServerJrfEnabled(service, session, targetId, customServiceList = WasJRFUtils.getJRFCustomServicesFromTemplate(targetId))) {
            return;
        }
        List<Library> jrfLibs = WasJRFUtils.getJRFLibrariesFromTemplate(targetId);
        this.createLibraries(service, session, cellId, targetId, jrfLibs);
        this.createCustomService(service, session, targetId, customServiceList);
        this.setJvmMemArgs(service, session, serverName);
        this.setJvmSystemProperty(service, session, serverName);
        this.createUrlProvider(service, session, targetId);
        this.createJDBCDriver(service, session, nodeName);
        this.enableStartupBeansService(service, session, serverName);
        this.deployApplication(service, session, targetId, cellName, cellId, "", nodeName, serverName);
        this.copyServerConfigFiles(service, session, cellName, nodeName, serverName);
    }

    private void applyJRFToCluster(ConfigService service, Session session, ObjectName clusterId) throws Exception {
        Object[] nodes;
        String clusterName = ConfigServiceHelper.getDisplayName((ObjectName)clusterId);
        String cellName = WasJRFUtils.getCellNameFromClusterId(clusterId);
        ObjectName cellId = this.getIdFromPath(service, session, "Cell=" + cellName);
        List<Library> jrfLibs = WasJRFUtils.getJRFLibrariesFromTemplate(clusterId);
        boolean isJrfInstalled = this.isClusterJrfEnabled(service, session, cellName, clusterId, jrfLibs);
        if (!isJrfInstalled) {
            this.createLibraries(service, session, cellId, clusterId, jrfLibs);
            this.deployApplication(service, session, clusterId, cellName, cellId, clusterName, "", "");
        }
        ArrayList svrList = this.getAllServersOfACluster(service, session, clusterName, cellName);
        HashSet<String> nodeSet = new HashSet<String>();
        for (int i = 0; i < svrList.size(); ++i) {
            List<StartupClass> customServiceList;
            ObjectName svrId = (ObjectName)svrList.get(i);
            if (this.isServerJrfEnabled(service, session, svrId, customServiceList = WasJRFUtils.getJRFCustomServicesFromTemplate(svrId))) continue;
            this.createCustomService(service, session, svrId, customServiceList);
            String serverName = ConfigServiceHelper.getDisplayName((ObjectName)svrId);
            this.setJvmMemArgs(service, session, serverName);
            this.setJvmSystemProperty(service, session, serverName);
            this.createUrlProvider(service, session, svrId);
            this.enableStartupBeansService(service, session, serverName);
            String nodeName = WasJRFUtils.getNodeNameFromId(svrId);
            this.copyServerConfigFiles(service, session, cellName, nodeName, serverName);
            nodeSet.add(nodeName);
        }
        for (Object name : nodes = nodeSet.toArray()) {
            this.createJDBCDriver(service, session, (String)name);
        }
    }

    private boolean isCellJrfEnabled(ConfigService service, Session session, ObjectName cellId) throws PortabilityLayerException {
        String commonComponentsHome = this.getVariable(service, session, cellId, "COMMON_COMPONENTS_HOME");
        return commonComponentsHome != null && !commonComponentsHome.equals("");
    }

    private boolean isNodeJrfEnabled(ConfigService service, Session session, ObjectName nodeId) throws PortabilityLayerException {
        String jdbcPath = this.getVariable(service, session, nodeId, ORACLE_JDBC_DRIVER_PATH);
        return jdbcPath != null && jdbcPath.indexOf("modules/oracle.jdbc_11.1.1/ojdbc6.jar") != -1;
    }

    private ArrayList<ObjectName> getApplicationServerIds(ConfigService service, Session session, ObjectName cellId) throws Exception {
        ObjectName qryName = ConfigServiceHelper.createObjectName(null, (String)"Server");
        ObjectName[] serverIds = service.queryConfigObjects(session, cellId, qryName, null);
        ArrayList<ObjectName> retIds = new ArrayList<ObjectName>();
        for (ObjectName svr : serverIds) {
            String svrType = (String)service.getAttribute(session, svr, "serverType");
            if (svrType == null || !svrType.equals("APPLICATION_SERVER")) continue;
            retIds.add(svr);
        }
        return retIds;
    }

    private String getJvmArg() throws PortabilityLayerException {
        boolean is64Bit = System.getProperty("sun.arch.data.model").equals("64");
        for (EnvConfig config : WasJRFUtils.getJRFEnvConfigsFromTemplate()) {
            if (config.getInitialHeapSize32() == null) continue;
            return config.getMemoryArgsAsString(is64Bit);
        }
        return "";
    }

    private void createLibraries(ConfigService service, Session session, ObjectName cellId, ObjectName targetId, List<Library> libraries) throws PortabilityLayerException {
        AttributeList attrList = new AttributeList();
        for (Library lib : libraries) {
            ConfigServiceHelper.setAttributeValue((AttributeList)attrList, (String)NAME_TAG, (Object)lib.getName());
            ArrayList<String> classpath = new ArrayList<String>(1);
            classpath.add(this.convertSrcPath(service, session, cellId, lib.getSourcePath()));
            ConfigServiceHelper.setAttributeValue((AttributeList)attrList, (String)CLASSPATH_TAG, classpath);
            ConfigServiceHelper.setAttributeValue((AttributeList)attrList, (String)"isolatedClassLoader", (Object)new Boolean(lib.getIsolatedClassLoader()));
            try {
                service.createConfigData(session, targetId, "Library", "Library", attrList);
            }
            catch (Exception e) {
                throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20014", new String[]{ConfigServiceHelper.getDisplayName((ObjectName)targetId)}), e);
            }
        }
    }

    private void deployApplication(ConfigService service, Session session, ObjectName targetId, String cellName, ObjectName cellId, String clusterName, String nodeName, String serverName) throws Exception {
        List<Application> appList = WasJRFUtils.getJRFApplicationsFromTemplate(targetId);
        AppManagement appMgmt = AppManagementProxy.getJMXProxyForServer();
        if (clusterName != null && !clusterName.equals("")) {
            String appTarget = "WebSphere:cell=" + cellName + ",cluster=" + clusterName;
            for (Application app : appList) {
                this.editApplication(appMgmt, app, appTarget);
            }
        } else {
            String appTarget = "WebSphere:cell=" + cellName + ",node=" + nodeName + ",server=" + serverName;
            for (Application app : appList) {
                if (!this.isApplicationDeployed(appMgmt, app.getName())) {
                    this.installApplication(service, session, appMgmt, app, appTarget, cellId);
                    continue;
                }
                this.editApplication(appMgmt, app, appTarget);
            }
        }
    }

    private boolean isApplicationDeployed(AppManagement appMgmt, String appName) throws Exception {
        Hashtable<String, Locale> prefs = new Hashtable<String, Locale>();
        prefs.put("app.client.locale", Locale.getDefault());
        Vector apps = appMgmt.listApplications(prefs, null);
        for (int k = 0; k < apps.size(); ++k) {
            if (!apps.get(k).toString().equals(appName)) continue;
            return true;
        }
        return false;
    }

    private void createCustomService(ConfigService service, Session session, ObjectName targetId, List<StartupClass> list) throws PortabilityLayerException {
        for (StartupClass startup : list) {
            AttributeList attrList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attrList, (String)"classname", (Object)startup.getClassName());
            ConfigServiceHelper.setAttributeValue((AttributeList)attrList, (String)"enable", (Object)new Boolean(startup.getEnable()));
            ConfigServiceHelper.setAttributeValue((AttributeList)attrList, (String)"classpath", (Object)startup.getClassPath());
            ConfigServiceHelper.setAttributeValue((AttributeList)attrList, (String)"displayName", (Object)startup.getName());
            try {
                service.createConfigData(session, targetId, "customServices", "CustomService", attrList);
            }
            catch (Exception e) {
                throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20015", new String[]{ConfigServiceHelper.getDisplayName((ObjectName)targetId)}), e);
            }
        }
    }

    private void createUrlProvider(ConfigService service, Session session, ObjectName targetId) throws PortabilityLayerException {
        for (URLProvider urlProvider : WasJRFUtils.getJRFUrlProvidersFromTemplate(targetId)) {
            AttributeList attrList = new AttributeList();
            ConfigServiceHelper.setAttributeValue((AttributeList)attrList, (String)"streamHandlerClassName", (Object)urlProvider.getStreamHandlerClassName());
            ConfigServiceHelper.setAttributeValue((AttributeList)attrList, (String)"name", (Object)urlProvider.getName());
            ConfigServiceHelper.setAttributeValue((AttributeList)attrList, (String)"description", (Object)"");
            ConfigServiceHelper.setAttributeValue((AttributeList)attrList, (String)"protocol", (Object)urlProvider.getProtocol());
            try {
                service.createConfigData(session, targetId, "URLProvider", "URLProvider", attrList);
            }
            catch (Exception e) {
                throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20016", new String[]{ConfigServiceHelper.getDisplayName((ObjectName)targetId)}), e);
            }
        }
    }

    private void enableStartupBeansService(ConfigService service, Session session, String serverName) throws PortabilityLayerException {
        ObjectName rootID = this.getIdFromPath(service, session, "Server=" + serverName + ":PMEServerExtension=:StartupBeansService=:");
        AttributeList attrList = new AttributeList();
        attrList.add(new Attribute("enable", new Boolean("true")));
        try {
            service.setAttributes(session, rootID, attrList);
        }
        catch (Exception e) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20030", new String[]{serverName}), e);
        }
    }

    private void setJvmMemArgs(ConfigService service, Session session, String serverName) throws PortabilityLayerException {
        ObjectName rootID = this.getIdFromPath(service, session, "Server=" + serverName + ":JavaProcessDef=:JavaVirtualMachine=");
        String genericArgs = this.getJvmArg();
        AttributeList attrList = new AttributeList();
        attrList.add(new Attribute("genericJvmArguments", genericArgs));
        try {
            service.setAttributes(session, rootID, attrList);
        }
        catch (Exception e) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20017", new String[]{serverName}), e);
        }
    }

    private void setJvmSystemProperty(ConfigService service, Session session, String serverName) throws PortabilityLayerException {
        ObjectName rootID = this.getIdFromPath(service, session, "Server=" + serverName + ":JavaProcessDef=:JavaVirtualMachine=");
        for (EnvConfig config : WasJRFUtils.getJRFEnvConfigsFromTemplate()) {
            for (Map.Entry<Object, Object> entry : config.getProperties().entrySet()) {
                AttributeList attrList = new AttributeList();
                attrList.add(new Attribute("name", entry.getKey()));
                attrList.add(new Attribute("value", entry.getValue()));
                try {
                    service.addElement(session, rootID, "systemProperties", (Object)attrList, -1);
                }
                catch (Exception e) {
                    throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20018", new String[]{serverName}), e);
                }
            }
        }
    }

    private boolean isClusterJrfEnabled(ConfigService service, Session session, String cellName, ObjectName targetId, List<Library> jrfLibs) throws Exception {
        if (!jrfLibs.isEmpty()) {
            String libName = jrfLibs.get(0).getName();
            ObjectName queryLib = ConfigServiceHelper.createObjectName(null, (String)"Library");
            ObjectName[] libIds = service.queryConfigObjects(session, targetId, queryLib, null);
            if (libIds != null && libIds.length != 0) {
                for (ObjectName obj : libIds) {
                    String name = (String)service.getAttribute(session, obj, "name");
                    if (!name.equals(libName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void createJDBCDriver(ConfigService service, Session session, String nodeName) throws PortabilityLayerException {
        ObjectName nodeId = this.getIdFromPath(service, session, "Node=" + nodeName);
        if (this.isNodeJrfEnabled(service, session, nodeId)) {
            return;
        }
        ObjectName queryName = ConfigServiceHelper.createObjectName(null, (String)"VariableSubstitutionEntry");
        try {
            ObjectName[] varSub;
            for (ObjectName var : varSub = service.queryConfigObjects(session, nodeId, queryName, null)) {
                String name = (String)service.getAttribute(session, var, "symbolicName");
                if (!name.equals(ORACLE_JDBC_DRIVER_PATH)) continue;
                AttributeList attrList = new AttributeList();
                ConfigServiceHelper.setAttributeValue((AttributeList)attrList, (String)"symbolicName", (Object)ORACLE_JDBC_DRIVER_PATH);
                ConfigServiceHelper.setAttributeValue((AttributeList)attrList, (String)"value", (Object)OJDBC_JAR_NAME);
                service.setAttributes(session, var, attrList);
                break;
            }
        }
        catch (Exception e) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20022", new String[]{ORACLE_JDBC_DRIVER_PATH}), e);
        }
    }

    private boolean isServerJrfEnabled(ConfigService service, Session session, ObjectName serverId, List<StartupClass> list) throws Exception {
        boolean ret = false;
        if (!list.isEmpty()) {
            String customServiceName = list.get(0).getName();
            ObjectName customServiceQuery = ConfigServiceHelper.createObjectName(null, (String)"CustomService");
            ObjectName[] queryRes = service.queryConfigObjects(session, serverId, customServiceQuery, null);
            if (queryRes != null && queryRes.length != 0) {
                for (ObjectName obj : queryRes) {
                    String name = (String)service.getAttribute(session, obj, "displayName");
                    if (!name.equals(customServiceName)) continue;
                    ret = true;
                    break;
                }
            }
        }
        return ret;
    }

    private ArrayList getAllServersOfACluster(ConfigService service, Session session, String clusterName, String cellName) throws Exception {
        ArrayList<ObjectName> list = new ArrayList<ObjectName>();
        ObjectName cellId = this.getIdFromPath(service, session, "Cell=" + cellName);
        ArrayList<ObjectName> serverIds = this.getApplicationServerIds(service, session, cellId);
        String name = "";
        for (int i = 0; i < serverIds.size(); ++i) {
            ObjectName serverId = serverIds.get(i);
            try {
                name = (String)service.getAttribute(session, serverId, "clusterName");
            }
            catch (Exception e) {
                throw new PortabilityLayerException(e);
            }
            if (name == null || !name.equals(clusterName)) continue;
            list.add(serverId);
        }
        return list;
    }

    private void installApplication(ConfigService service, Session session, AppManagement appMgmt, Application app, String target, ObjectName cellId) throws PortabilityLayerException {
        Hashtable<String, Cloneable> options = new Hashtable<String, Cloneable>();
        options.put("app.client.locale", Locale.getDefault());
        Hashtable<String, String> module2server = new Hashtable<String, String>();
        module2server.put("*", target);
        options.put("moduleToServer", module2server);
        try {
            appMgmt.installApplication(this.convertSrcPath(service, session, cellId, app.getSourcePath()), app.getName(), options, null);
        }
        catch (Exception e) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20023", new String[]{app.getName()}), e);
        }
    }

    private void editApplication(AppManagement appMgmt, Application app, String target) throws PortabilityLayerException {
        if (JRFTemplateHelper.getJRFTemplateForWAS().getApplications("JRF-DMGR-APPS").contains(app)) {
            return;
        }
        if (JRFTemplateHelper.getJRFTemplateForWAS().getApplications("JRF-DMGR-APPS").contains(app) && !target.equals(ORACLE_ADMIN_SERVER)) {
            return;
        }
        try {
            Hashtable<String, Locale> prefs = new Hashtable<String, Locale>();
            prefs.put("app.client.locale", Locale.getDefault());
            Vector allTasks = appMgmt.getApplicationInfo(app.getName(), prefs, null);
            for (int i = 0; i < allTasks.size(); ++i) {
                String[][] data;
                String[] colNames;
                AppDeploymentTask task = (AppDeploymentTask)allTasks.get(i);
                if (!task.getName().equals("MapModulesToServers")) continue;
                if (task.isTaskDisabled()) {
                    throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20029", new String[]{app.getName()}));
                }
                int serverCol = -1;
                for (String colName : colNames = task.getColumnNames()) {
                    if (!colName.trim().equals("server")) continue;
                    serverCol = i;
                    break;
                }
                for (String[] d : data = task.getTaskData()) {
                    if (d[serverCol].trim().equals("server")) continue;
                    int n = serverCol;
                    d[n] = d[n] + "+" + target;
                }
                task.setTaskData(data);
            }
            prefs = new Hashtable();
            prefs.put("app.client.locale", Locale.getDefault());
            appMgmt.setApplicationInfo(app.getName(), prefs, null, allTasks);
        }
        catch (Exception e) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20021", new String[]{app.getName()}), e);
        }
    }

    private File getServerConfigDir(ConfigService service, Session session, String cellName, String nodeName, String serverName) throws PortabilityLayerException {
        String targetPath = "Cell=" + cellName + ":Node=" + nodeName;
        ObjectName targetId = this.getIdFromPath(service, session, targetPath);
        String installRoot = this.getVariable(service, session, targetId, "USER_INSTALL_ROOT");
        return new File(installRoot + "/config/cells/" + cellName + "/nodes/" + nodeName + "/servers/" + serverName + "/fmwconfig");
    }

    private String getVariable(ConfigService service, Session session, ObjectName targetId, String variableName) throws PortabilityLayerException {
        ObjectName name = ConfigServiceHelper.createObjectName(null, (String)"VariableMap");
        String varValue = "";
        try {
            ObjectName[] vars = service.queryConfigObjects(session, targetId, name, null);
            ArrayList entries = (ArrayList)service.getAttribute(session, vars[0], "entries");
            String varName = "";
            AttributeList var = null;
            for (int i = 0; i < entries.size(); ++i) {
                var = (AttributeList)entries.get(i);
                varName = (String)ConfigServiceHelper.getAttributeValue((AttributeList)var, (String)"symbolicName");
                if (!varName.equals(variableName)) continue;
                varValue = (String)ConfigServiceHelper.getAttributeValue((AttributeList)var, (String)"value");
                break;
            }
        }
        catch (Exception e) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20020", new String[]{variableName, ConfigServiceHelper.getDisplayName((ObjectName)targetId)}));
        }
        return varValue;
    }

    private ObjectName getIdFromPath(ConfigService service, Session session, String path) throws PortabilityLayerException {
        ObjectName[] resIds = null;
        try {
            resIds = service.resolve(session, path);
        }
        catch (Exception e) {
            new PortabilityLayerException(e);
        }
        if (resIds == null || resIds.length == 0) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20013", new String[]{path}));
        }
        return resIds[0];
    }

    private void copyServerConfigFiles(ConfigService service, Session session, String cellName, String nodeName, String serverName) throws PortabilityLayerException {
        File serverConfigDir = this.getServerConfigDir(service, session, cellName, nodeName, serverName);
        File oraHomeDir = new File(JrfUtils.getCommonComponentsHome());
        File domainConfigDir = new File(ServerPlatformSupportFactory.getInstance().getDomainConfigDirectory());
        try {
            InternalJrfUtils.copyServerConfigTemplateToServerDir(domainConfigDir, oraHomeDir, serverConfigDir);
        }
        catch (Exception e) {
            throw new PortabilityLayerException(e);
        }
    }

    private String convertSrcPath(ConfigService service, Session session, ObjectName id, String src) throws PortabilityLayerException {
        String dest = src.replaceAll("\\$ORACLE_HOME\\$", this.getVariable(service, session, id, "ORACLE_HOME"));
        dest = dest.replaceAll("\\$COMMON_COMPONENTS_HOME\\$", this.getVariable(service, session, id, "COMMON_COMPONENTS_HOME"));
        return dest;
    }
}

