/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf.templates;

import java.util.jar.JarFile;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.templates.AbstractTemplateBuilder;
import oracle.jrf.templates.Application;
import oracle.jrf.templates.JDBCSystemResource;
import oracle.jrf.templates.Library;
import oracle.jrf.templates.ShutdownClass;
import oracle.jrf.templates.StartupClass;
import oracle.jrf.templates.WLDFSystemResource;
import oracle.jrf.templates.WlsTemplate;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WlsTemplateBuilder
extends AbstractTemplateBuilder {
    private static final String WLS_CONFIG_XML = "config/config.xml";
    private static final String WLS_APPLICATION = "app-deployment";
    private static final String WLS_STARTUP = "startup-class";
    private static final String WLS_SHUTDOWN = "shutdown-class";
    private static final String WLS_SOURCE_PATH = "source-path";
    private static final String WLS_JDBC_SYS_RESOURCES = "jdbc-system-resource";
    private static final String WLS_WLDF_SYS_RESOURCES = "wldf-system-resource";

    public WlsTemplateBuilder() {
        this.template = new WlsTemplate();
    }

    @Override
    protected void readConfigXml(JarFile templateJar) throws PortabilityLayerException {
        Element root = this.getDocumentElement(templateJar, WLS_CONFIG_XML);
        this.readApplications(root.getElementsByTagName(WLS_APPLICATION));
        this.readLibraries(root.getElementsByTagName("library"));
        this.readStartupClasses(root.getElementsByTagName(WLS_STARTUP));
        this.readShutdownClasss(root.getElementsByTagName(WLS_SHUTDOWN));
        this.readJdbcSystemResources(root.getElementsByTagName(WLS_JDBC_SYS_RESOURCES));
        this.readWldfSystemResources(root.getElementsByTagName(WLS_WLDF_SYS_RESOURCES));
    }

    protected void readStartupClasses(NodeList startups) {
        for (int i = 0; i < startups.getLength(); ++i) {
            StartupClass startup = new StartupClass();
            NodeList children = startups.item(i).getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                if (!children.item(j).getNodeName().equals("name")) continue;
                startup.name = children.item(j).getTextContent();
                break;
            }
            this.template.allStartupClasses.put(startup.getName(), startup);
        }
    }

    protected void readShutdownClasss(NodeList shutdowns) {
        for (int i = 0; i < shutdowns.getLength(); ++i) {
            ShutdownClass shutdown = new ShutdownClass();
            NodeList children = shutdowns.item(i).getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                if (!children.item(j).getNodeName().equals("name")) continue;
                shutdown.name = children.item(j).getTextContent();
                break;
            }
            this.template.allShutdownClasses.put(shutdown.getName(), shutdown);
        }
    }

    protected void readJdbcSystemResources(NodeList jdbcSysResources) {
        for (int i = 0; i < jdbcSysResources.getLength(); ++i) {
            JDBCSystemResource jdbcSysResource = new JDBCSystemResource();
            NodeList children = jdbcSysResources.item(i).getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                if (!children.item(j).getNodeName().equals("name")) continue;
                jdbcSysResource.name = children.item(j).getTextContent();
                break;
            }
            this.template.allJdbcSystemResources.put(jdbcSysResource.getName(), jdbcSysResource);
        }
    }

    protected void readWldfSystemResources(NodeList wldfSysResources) {
        for (int i = 0; i < wldfSysResources.getLength(); ++i) {
            WLDFSystemResource wldfSysResource = new WLDFSystemResource();
            NodeList children = wldfSysResources.item(i).getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                if (!children.item(j).getNodeName().equals("name")) continue;
                wldfSysResource.name = children.item(j).getTextContent();
                break;
            }
            this.template.allWldfSystemResources.put(wldfSysResource.getName(), wldfSysResource);
        }
    }

    @Override
    protected void processApplicationChildNode(Application app, String nodeName, String nodeValue) {
        if (nodeName.equals("name")) {
            app.name = nodeValue;
        } else if (nodeName.equals(WLS_SOURCE_PATH)) {
            app.sourcePath = nodeValue;
        }
    }

    @Override
    protected void processLibraryChildNode(Library lib, String nodeName, String nodeValue) {
        if (nodeName.equals("name")) {
            lib.name = nodeValue;
        } else if (nodeName.equals(WLS_SOURCE_PATH)) {
            lib.sourcePath = nodeValue;
        }
    }

    @Override
    protected void processConfigGroupResource(String nodeName, String nodeValue, String groupName) {
        if (nodeName.equals(WLS_APPLICATION)) {
            this.template.applications.get(groupName).add(this.template.allApplications.get(nodeValue));
        } else if (nodeName.equals(WLS_STARTUP)) {
            this.template.startupClasses.get(groupName).add(this.template.allStartupClasses.get(nodeValue));
        } else if (nodeName.equals(WLS_SHUTDOWN)) {
            this.template.shutdownClasses.get(groupName).add(this.template.allShutdownClasses.get(nodeValue));
        } else if (nodeName.equals(WLS_WLDF_SYS_RESOURCES)) {
            this.template.wldfSystemResources.get(groupName).add(this.template.allWldfSystemResources.get(nodeValue));
        } else if (nodeName.equals(WLS_JDBC_SYS_RESOURCES)) {
            this.template.jdbcSystemResources.get(groupName).add(this.template.allJdbcSystemResources.get(nodeValue));
        } else {
            super.processConfigGroupResource(nodeName, nodeValue, groupName);
        }
    }
}

