/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf.jboss;

import java.io.File;
import oracle.jrf.AbstractServerPlatformSupport;
import oracle.jrf.Application;
import oracle.jrf.ApplicationIdentifier;
import oracle.jrf.PortConfig;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.i18n.JRFMessageBundleHelper;
import oracle.jrf.jboss.JBossPortConfig;

public class JBossServerPlatformSupport
extends AbstractServerPlatformSupport {
    @Override
    public String getDomainName() throws PortabilityLayerException {
        return System.getProperty("jboss.server.name");
    }

    @Override
    public String getPlatformName() {
        return "jboss";
    }

    @Override
    public String getAdminServerName() throws PortabilityLayerException {
        return System.getProperty("jboss.server.name");
    }

    @Override
    public String getServerName() throws PortabilityLayerException {
        return System.getProperty("jboss.server.name");
    }

    @Override
    public String getServerConfigDirectory(String domainName, String serverName) throws PortabilityLayerException {
        return this.getServerConfigDirectory();
    }

    @Override
    public boolean isJBoss() {
        return true;
    }

    @Override
    public String getServerLogPath() throws PortabilityLayerException {
        if (this.serverLogPath == null) {
            this.serverLogPath = System.getProperty("jboss.server.log.dir");
        }
        return this.serverLogPath;
    }

    @Override
    public Application getApplication() throws PortabilityLayerException {
        throw new PortabilityLayerException("getApplication is not supported in JBoss");
    }

    @Override
    public ApplicationIdentifier getApplicationIdentifier() throws PortabilityLayerException {
        ApplicationIdentifier appIdentifier = null;
        try {
            String deploymentName = this.getApplicationName();
            appIdentifier = new ApplicationIdentifier(deploymentName, null, null, true);
        }
        catch (Exception e) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10001", new String[]{e.getMessage()}), e);
        }
        return appIdentifier;
    }

    private String getApplicationName() {
        String applicationName = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        for (int i = 0; applicationName == null && i < 20; ++i) {
            applicationName = this.getApplicationNameFromClassLoader(loader);
            ClassLoader parent = loader.getParent();
            if (parent == null || parent == loader) break;
            loader = parent;
        }
        return applicationName;
    }

    private String getApplicationNameFromClassLoader(ClassLoader cl) {
        String clStr = cl.toString();
        String appNameSegment = null;
        String appName = null;
        if (clStr.indexOf("vfszip:") != -1) {
            appNameSegment = clStr.substring(clStr.indexOf("vfszip:") + 7, clStr.length() - 2);
            appName = appNameSegment.indexOf(".war") != -1 && appNameSegment.indexOf(".ear") != -1 ? new File(appNameSegment.substring(0, appNameSegment.indexOf(".ear") + ".ear".length())).getName() : new File(appNameSegment).getName();
        } else if (clStr.indexOf("vfsfile:") != -1) {
            appNameSegment = clStr.substring(clStr.indexOf("vfsfile:") + 8, clStr.length() - 2);
            appName = new File(appNameSegment).getName();
        }
        return appName;
    }

    @Override
    public String getClusterName() throws PortabilityLayerException {
        return "cluster_unknown";
    }

    @Override
    public PortConfig getNewPortConfig() throws PortabilityLayerException {
        try {
            return new JBossPortConfig();
        }
        catch (Exception e) {
            throw new PortabilityLayerException(e);
        }
    }

    @Override
    public PortConfig getPortConfig(String serverId) throws PortabilityLayerException {
        throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10027"));
    }
}

