/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf.jboss;

import java.net.InetAddress;
import javax.management.AttributeChangeNotificationFilter;
import javax.management.MBeanServer;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import oracle.jrf.Port;
import oracle.jrf.PortConfig;
import oracle.jrf.PortabilityLayerException;
import org.jboss.mx.util.MBeanServerLocator;

public final class JBossPortConfig
extends PortConfig {
    private static final long serialVersionUID = 1L;
    private transient ObjectName webServer;
    private transient ObjectName webServerSevice;
    private transient ObjectName webServerConnector;
    private transient ObjectName namingService;

    JBossPortConfig() throws Exception {
        this.initialize();
    }

    @Override
    public String[] getSupportedPortProtocols() {
        return new String[]{"http", "https", "jnp"};
    }

    protected void initialize() throws Exception {
        ObjectName[] connectors;
        MBeanServer conn = MBeanServerLocator.locateJBoss();
        this.webServer = new ObjectName("jboss.web:type=Server");
        String webServerHost = (String)conn.getAttribute(this.webServer, "address");
        if (webServerHost == null || webServerHost.trim().isEmpty()) {
            webServerHost = this.getLocalHost();
        }
        ObjectName[] webServerSevices = (ObjectName[])conn.getAttribute(this.webServer, "serviceNames");
        this.webServerSevice = webServerSevices[0];
        for (ObjectName connector : connectors = (ObjectName[])conn.getAttribute(this.webServerSevice, "connectorNames")) {
            int port = (Integer)conn.getAttribute(connector, "port");
            String protocol = (String)conn.getAttribute(connector, "protocol");
            boolean secure = (Boolean)conn.getAttribute(connector, "secure");
            if (protocol.indexOf("HTTP") <= -1) continue;
            this.webServerConnector = connector;
            Object connAddr = conn.getAttribute(connector, "address");
            if (connAddr != null) {
                String connectorHost = connAddr instanceof InetAddress ? ((InetAddress)connAddr).getCanonicalHostName() : ((String)connAddr).trim();
                String string = webServerHost = connectorHost.indexOf("0.0.0.0") > -1 ? PortConfig.resolveHost(webServerHost) : connectorHost;
            }
            if (secure) {
                this.addServerPort(new Port("https", webServerHost, port, this));
                this.setFrontEndHttpSslPort(this.getHttpSslPort());
                break;
            }
            this.addServerPort(new Port("http", webServerHost, port, this));
            this.setFrontEndHttpPort(this.getHttpPort());
            break;
        }
        this.namingService = new ObjectName("jboss:service=Naming");
        Integer port = (Integer)conn.getAttribute(this.namingService, "Port");
        this.addServerPort(new Port("jnp", this.getLocalHost(), port, this));
    }

    @Override
    public boolean isClustered() {
        return false;
    }

    @Override
    protected String[] getDefaultJndiProtocols() {
        return new String[]{"jnp"};
    }

    @Override
    protected String[] getDefaultJndiSslProtocols() {
        return this.getDefaultJndiProtocols();
    }

    @Override
    protected void registerPortConfigChangeListener(NotificationListener listener) throws PortabilityLayerException {
        try {
            MBeanServer conn = MBeanServerLocator.locateJBoss();
            AttributeChangeNotificationFilter filter = new AttributeChangeNotificationFilter();
            filter.enableAttribute("address");
            filter.enableAttribute("serviceNames");
            conn.addNotificationListener(this.webServer, listener, (NotificationFilter)filter, null);
            filter = new AttributeChangeNotificationFilter();
            filter.enableAttribute("connectorNames");
            conn.addNotificationListener(this.webServerSevice, listener, (NotificationFilter)filter, null);
            filter = new AttributeChangeNotificationFilter();
            filter.enableAttribute("address");
            filter.enableAttribute("port");
            filter.enableAttribute("protocol");
            filter.enableAttribute("secure");
            conn.addNotificationListener(this.webServerConnector, listener, (NotificationFilter)filter, null);
            filter = new AttributeChangeNotificationFilter();
            filter.enableAttribute("Port");
            conn.addNotificationListener(this.namingService, listener, (NotificationFilter)filter, null);
        }
        catch (Exception e) {
            throw new PortabilityLayerException(e);
        }
    }
}

