/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf.i18n;

import oracle.annotation.logging.Category;
import oracle.annotation.logging.MessageInfo;
import oracle.annotation.logging.Publish;
import oracle.annotation.logging.Severity;

public interface JRFMessageID {
    @MessageInfo(severity=Severity.SEVERE, cause={"The MBean server could not be accessed to retrieve the application name."}, action={"Verify that the MBean server is running and accessible."}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String FAIL_TO_RETRIEVE_APPLICATION_IDENTIFIER = "JRF-10001";
    @MessageInfo(severity=Severity.SEVERE, cause={"The MBean server could not be accessed to retrieve the admin server name."}, action={"Verify that the MBean server is running and accessible."}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String FAIL_TO_RETRIEVE_ADMIN_SERVER_NAME = "JRF-10002";
    @MessageInfo(severity=Severity.SEVERE, cause={"The MBean server could not be accessed to retrieve the server name based on the current thread."}, action={"Verify that the MBean server is running and accessible."}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String FAIL_TO_RETRIEVE_CURRENT_SERVER_NAME = "JRF-10003";
    @MessageInfo(severity=Severity.SEVERE, cause={"The MBean server could not be accessed to verify that the server in the current thread is the admin server."}, action={"Verify that the MBean server is running and accessible."}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String FAIL_TO_CHECK_IF_ADMIN_SERVER = "JRF-10004";
    @MessageInfo(severity=Severity.SEVERE, cause={"The MBean server could not be accessed to retrieve the server log path."}, action={"Verify that the MBean server is running and accessible."}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String FAIL_TO_RETRIEVE_SERVER_LOG_PATH = "JRF-10005";
    @MessageInfo(severity=Severity.SEVERE, cause={"The server config directory could not be accessed."}, action={"Use the applyJRF() wlst command to ensure that the server has been properly configured."}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String FAIL_TO_COPY_CONFIG_TO_SERVER_DIRECTORY = "JRF-10006";
    @MessageInfo(severity=Severity.SEVERE, cause={"The system property domain.home was not specified during WebLogic server startup."}, action={"Specify the system property domain.home when starting the WebLogic server."}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String MISSING_PROPERTY_DOMAIN_HOME = "JRF-10007";
    @MessageInfo(severity=Severity.SEVERE, cause={"The specified JRF template was not accessaible."}, action={"Verify that the template jar from the template location is present and accessible."}, publish=Publish.NO, category=Category.CONFIGURATION)
    public static final String FAIL_TO_ACCESS_TO_JRF_TEMPLATE = "JRF-10008";
    @MessageInfo(severity=Severity.SEVERE, cause={"The config.xml might be missing from the JRF template or the JRF template jar might be corrupted."}, action={"Verify that the JRF template is properly installed within the Oracle Home."}, publish=Publish.NO, category=Category.CONFIGURATION)
    public static final String FAIL_TO_RETRIEVE_CONFIG_XML_FROM_TEMPLATE = "JRF-10009";
    @MessageInfo(severity=Severity.SEVERE, cause={"The config.xml under domain config was missing or corrupted."}, action={"Verify that the domain contains a valid config.xml file."}, publish=Publish.NO, category=Category.CONFIGURATION)
    public static final String DOMAIN_CONFIG_XML_NOT_FOUND = "JRF-10010";
    @MessageInfo(severity=Severity.SEVERE, cause={"The domain config.xml might be missing or the JRF template jar might be corrupted."}, action={"Verify that the JRF template is properly installed within the Oracle Home and that the domain contains a valid config.xml file."}, publish=Publish.NO, category=Category.CONFIGURATION)
    public static final String FAIL_TO_PARSE_JRF_TEMPLATE_CONFIG_XML = "JRF-10011";
    @MessageInfo(severity=Severity.SEVERE, cause={"The Common Components Home property was not set."}, action={"Set the Oracle Home property using the system property common.components.home or the environment variable COMMON_COMPONENTS_HOME."}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String MISSING_PROPERTY_ORACLE_HOME = "JRF-10012";
    @MessageInfo(severity=Severity.SEVERE, cause={"The Common Components Home directory did not exist."}, action={"Verify that Common ComponentsHome, specified through the system property common.components.home or environment variable COMMON_COMPONENTS_HOME, is a valid directory."}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String ORACLE_HOME_NOT_EXIST = "JRF-10013";
    @MessageInfo(severity=Severity.SEVERE, cause={"The MBean server could not be accessed to retrieve the application server platform information."}, action={"Verify that the MBean server is running and accessible."}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String FAIL_TO_RETRIEVE_PLATFORM_ID = "JRF-10014";
    @MessageInfo(severity=Severity.SEVERE, cause={"JRF does not support the specified platform."}, action={"Contact Oracle Support Services for the JRF supported application server platforms."}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String PLATFORM_NOT_SUPPORT = "JRF-10015";
    @MessageInfo(severity=Severity.SEVERE, cause={"Could not retrieve the servers from the domain config.xml file."}, action={"Verify that the domain contains a valid config.xml file."}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String FAIL_TO_INIT_SERVER_CONFIG_DIR = "JRF-10016";
    @MessageInfo(severity=Severity.SEVERE, cause={"Domain has not been extended with JRF template."}, action={"Apply JRF template to the domain."}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String NONE_JRF_EXTENDED_DOMAIN = "JRF-10017";
    @MessageInfo(severity=Severity.SEVERE, cause={"The server or cluster is not found."}, action={"Create the server or cluster."}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String NOT_FOUND_DOMAIN_TARGET = "JRF-10018";
    @MessageInfo(severity=Severity.SEVERE, cause={"Domain is being edited by someone else"}, action={"Wait until the edit lock on the domain is released and retry."}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String FAILED_EDIT_LOCK_DOMAIN = "JRF-10019";
    @MessageInfo(severity=Severity.SEVERE, cause={"Could not load/instantiate a WebLogic server platform support instance."}, action={"Check if the server platform support class can be loaded/instantiated by the classloader."}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String FAIL_TO_CREATE_WLS_PLATFORM = "JRF-10020";
    @MessageInfo(severity=Severity.SEVERE, cause={"Could not load/instantiate a WebSphere server platform support instance."}, action={"Check if the server platform support class can be loaded/instantiated by the classloader."}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String FAIL_TO_CREATE_WAS_PLATFORM = "JRF-10021";
    @MessageInfo(severity=Severity.SEVERE, cause={"Could not load system property 'oracle.domain.config.dir'."}, action={"Verify JRF is installed and provisioned properly and the system property 'oracle.domain.config.dir' is set."}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String MISSING_ORACLE_DOMAIN_CONFIG_DIR_PROP = "JRF-10022";
    @MessageInfo(severity=Severity.SEVERE, cause={"Could not load system property 'oracle.server.config.dir'."}, action={"Verify JRF is installed and provisioned properly and the system property 'oracle.server.config.dir' is set."}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String MISSING_ORACLE_SERVER_CONFIG_DIR_PROP = "JRF-10023";
    @MessageInfo(severity=Severity.SEVERE, cause={"JRF is unable to determine the current platform."}, action={"Contact Oracle Support Services for the JRF supported application server platforms."}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String UNKNOWN_PLATFORM = "JRF-10024";
    @MessageInfo(severity=Severity.SEVERE, cause={"Could not load/instantiate a JBoss server platform support instance."}, action={"Check if the server platform support class can be loaded/instantiated by the classloader."}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String FAIL_TO_CREATE_JBOSS_PLATFORM = "JRF-10025";
    @MessageInfo(severity=Severity.SEVERE, cause={"JRF Failed to retrieve application server edition"}, action={"Verify that the application server is installed and accessible."}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String FAIL_TO_RETRIEVE_SERVER_EDITION = "JRF-10026";
    @MessageInfo(severity=Severity.SEVERE, cause={"Operation is not supported on this platform edition."}, action={"Verify it is the right application server edition."}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String OPERATION_NOT_SUPPORTED = "JRF-10027";
    @MessageInfo(severity=Severity.INFO, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String JRF_INVOKE_STARTUP_SHUTDOWN_CLASS = "JRF-10028";
    @MessageInfo(severity=Severity.SEVERE, cause={"String format is invalid."}, action={"Correct the string format, see example of a correct string format in the exception message"}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String INVALID_STRING_FORMAT = "JRF-10029";
    @MessageInfo(severity=Severity.INFO, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String READ_DOMAIN = "JRF-20001";
    @MessageInfo(severity=Severity.INFO, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String UPDATE_DOMAIN = "JRF-20002";
    @MessageInfo(severity=Severity.INFO, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String TARGET_JRF_COMPONENTS = "JRF-20003";
    @MessageInfo(severity=Severity.WARNING, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String FAIL_COPY = "JRF-20004";
    @MessageInfo(severity=Severity.WARNING, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String ENV_NOT_SET = "JRF-20005";
    @MessageInfo(severity=Severity.INFO, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String COPY_CONFIG_FILES = "JRF-20006";
    @MessageInfo(severity=Severity.WARNING, publish=Publish.NO, category=Category.CONFIGURATION)
    public static final String FAIL_ADD_HELP = "JRF-20007";
    @MessageInfo(severity=Severity.SEVERE, cause={"JRF detects that domain has not been read."}, action={"Read the domain offline or connect online before invoke JRF WLST command."}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String NO_DOMAIN_READ = "JRF-20008";
    @MessageInfo(severity=Severity.SEVERE, cause={"Domain has not been extended with JRF or upgraded with new JRF version, or the applyJRF command is out-of-sync with JRF in the domain"}, action={"Extend domain with JRF template, or invoke upgradeJRF() to upgrade the domain if the install is upgraded."}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String JRF_COMPONENT_NOT_FOUND = "JRF-20009";
    @MessageInfo(severity=Severity.SEVERE, cause={"file not found"}, action={"Verify oraclehomeproperties.xml exist"}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String JRF_ORACLEHOMEPROPERTYFILE_NOT_FOUND = "JRF-20010";
    @MessageInfo(severity=Severity.SEVERE, cause={"node not found or no value"}, action={"Verify oraclehomeproperties.xml exist"}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String JRF_GUID_NOT_EXIST = "JRF-20011";
    @MessageInfo(severity=Severity.WARNING, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String SYS_PROS_NOT_SET = "JRF-20012";
    @MessageInfo(severity=Severity.SEVERE, cause={"target not found or not valid"}, action={"Verify target exists and valid"}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String JRF_TARGET_NOT_EXIST = "JRF-20013";
    @MessageInfo(severity=Severity.SEVERE, cause={"Creating shared library failed"}, action={"Verify server connection"}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String JRF_FAILED_CREATE_LIBRARY = "JRF-20014";
    @MessageInfo(severity=Severity.SEVERE, cause={"Creating custom service failed"}, action={"Verify server connection"}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String JRF_FAILED_CREATE_CUSTOMSERVICE = "JRF-20015";
    @MessageInfo(severity=Severity.SEVERE, cause={"Creating URL Provider failed"}, action={"Verify server connection"}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String JRF_FAILED_CREATE_URLPROVIDER = "JRF-20016";
    @MessageInfo(severity=Severity.SEVERE, cause={"Config JVM memory arguments failed"}, action={"Verify server connection"}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String JRF_FAILED_CONFIG_JVM_MEM_ARG = "JRF-20017";
    @MessageInfo(severity=Severity.SEVERE, cause={"Adding system property failed"}, action={"Verify server connection"}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String JRF_FAILED_ADD_SYSTEM_PROPERTY = "JRF-20018";
    @MessageInfo(severity=Severity.SEVERE, cause={"Template has error"}, action={"Verify template"}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String JRF_PARSE_TEMPLATE_FAILED = "JRF-20019";
    @MessageInfo(severity=Severity.SEVERE, cause={"Get variable failed"}, action={"Verify variable.xml"}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String JRF_GET_VARIABLE_FAILED = "JRF-20020";
    @MessageInfo(severity=Severity.SEVERE, cause={"Failed to update application target"}, action={"Verify application"}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String JRF_UPDATE_APPLICATION_TARGET_FAILED = "JRF-20021";
    @MessageInfo(severity=Severity.SEVERE, cause={"Failed to update oracle jdbc driver path"}, action={"Verify server"}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String JRF_UPDATE_OJDBC_PATH_FAILED = "JRF-20022";
    @MessageInfo(severity=Severity.SEVERE, cause={"Failed to install application"}, action={"Verify application"}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String JRF_INSTALL_APP_FAILED = "JRF-20023";
    @MessageInfo(severity=Severity.SEVERE, cause={"Failed to create variable"}, action={"Verify server"}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String JRF_CREATE_VARIABLE_FAILED = "JRF-20024";
    @MessageInfo(severity=Severity.SEVERE, cause={"Cell is not jrf enabled"}, action={"Apply jrf template to the cell since this cell is not jrf enabled"}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String JRF_CELL_NOT_JRFENABLED = "JRF-20025";
    @MessageInfo(severity=Severity.SEVERE, cause={"Could not load/instantiate a JRFService implementation class instance."}, action={"Check if JRFService implementation class in the error message can be loaded/instantiated by the classloader."}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String FAIL_TO_CREATE_JRFSERVICE_INSTANCE = "JRF-20026";
    @MessageInfo(severity=Severity.SEVERE, cause={"JRFService is not supported."}, action={"Check if the server has related JRFService available."}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String JRFSERVICE_NOT_SUPPORTED = "JRF-20028";
    @MessageInfo(severity=Severity.SEVERE, cause={"MapModulesToServers is disabled, cannot modify target of application."}, action={"Enable MapModulesToServers task for this application"}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String MODIFY_APPLICATION_TARGET_TASK_DISABLED = "JRF-20029";
    @MessageInfo(severity=Severity.SEVERE, cause={"Enable StartupBeansService failed"}, action={"Verify server connection"}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String JRF_FAILED_CONFIG_STARTUP_BEANS_SERVICE = "JRF-20030";
    public static final String FAIL_TO_CREATE_WLS_JRFSERVICE = "FAIL_TO_CREATE_WLS_JRFSERVICE";
    public static final String FAIL_TO_CREATE_WAS_JRFSERVICE = "FAIL_TO_CREATE_WAS_JRFSERVICE";
    @MessageInfo(severity=Severity.INFO, cause={"Avoid a redeployment leak"}, action={"Initializing sun.awt.AppContext"}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String INFO_INITIALIZE_SUN_AWT_APPCONTEXT = "JRF-20031";
    @MessageInfo(severity=Severity.INFO, cause={"sun.awt.AppContext not found"}, action={"Verify jdk"}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String FAIL_INITIALIZE_SUN_AWT_APPCONTEXT = "JRF-20032";
    @MessageInfo(severity=Severity.INFO, cause={"JRF is not configured properly"}, action={"Resolve these issues"}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String JRF_STARTUP_FAILED = "JRF-20033";
    @MessageInfo(severity=Severity.INFO, cause={"JRF is not configured properly"}, action={"Resolve these issues"}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String JRF_SHUTDOWN_FAILED = "JRF-20034";
    @MessageInfo(severity=Severity.INFO, cause={"invalid url format"}, action={"fix url format"}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String JRF_INVALID_URL_FORMAT = "JRF-20035";
    @MessageInfo(severity=Severity.INFO, cause={"The operation that checks if JRF applied to a target server or cluster failed"}, action={"See message and exception stack trace in admin server log to debug"}, publish=Publish.YES, category=Category.CONFIGURATION)
    public static final String JRF_CHECK_JRF_APPLIED_FAILED = "JRF-20036";
}

