/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jrf.JRFServiceFactory;
import oracle.jrf.JRFServiceMBean;
import oracle.jrf.Port;
import oracle.jrf.PortConfig;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.ServerPlatformSupportFactory;
import oracle.jrf.i18n.JRFMessageBundleHelper;

public class JRFService
implements JRFServiceMBean {
    Logger logger = Logger.getLogger(JRFService.class.getName());

    @Override
    public void applyJRF(String target) throws Exception {
        JRFServiceFactory.getJRFService().applyJRF(target);
    }

    @Override
    public boolean checkIfJRFApplied(String target) throws Exception {
        return JRFServiceFactory.getJRFService().checkIfJRFApplied(target);
    }

    @Override
    public Map<String, Integer> checkIfJRFAppliedOnMutipleTargets(String[] targets) throws Exception {
        HashMap<String, Integer> hm = new HashMap<String, Integer>();
        for (String target : targets) {
            try {
                boolean res = this.checkIfJRFApplied(target);
                hm.put(target, res ? 1 : 0);
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, JRFMessageBundleHelper.msg.getString("JRF-20036", new String[]{target, e.getMessage()}));
                hm.put(target, -1);
            }
        }
        return hm;
    }

    private void checkJBossWebSphereAS() throws PortabilityLayerException {
        if (ServerPlatformSupportFactory.getInstance().isJBoss() || ServerPlatformSupportFactory.getInstance().isWebSphereAS()) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-10027"));
        }
    }

    @Override
    public String getServerURL(String serverId, String protocol) throws Exception {
        this.checkJBossWebSphereAS();
        PortConfig config = ServerPlatformSupportFactory.getInstance().getPortConfig(serverId);
        Port port = config.getServerPort(protocol);
        return port == null ? null : port.getURLString();
    }

    @Override
    public String getServerJndiUrl(String serverId) throws Exception {
        this.checkJBossWebSphereAS();
        PortConfig config = ServerPlatformSupportFactory.getInstance().getPortConfig(serverId);
        return config == null ? null : config.getJndiProviderURL();
    }

    @Override
    public String getServerJndiSslUrl(String serverId) throws Exception {
        this.checkJBossWebSphereAS();
        PortConfig config = ServerPlatformSupportFactory.getInstance().getPortConfig(serverId);
        return config == null ? null : config.getJndiSslProviderURL();
    }
}

