/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.index;

import oracle.ide.util.IntHashMap;
import oracle.ideimpl.index.BaseDataCollector;
import oracle.ideimpl.index.DataLocation;
import oracle.ideimpl.index.FileData;
import oracle.ideimpl.index.IndexerStatistics;
import oracle.javatools.util.ArraySortedSet;

public class DataCollectorImpl
extends BaseDataCollector {
    private int id;
    private int count;
    private IntHashMap<ArraySortedSet<FileData>> data;

    DataCollectorImpl(IntHashMap<ArraySortedSet<FileData>> data) {
        this.data = data;
    }

    void setId(int id) {
        this.id = id;
    }

    @Override
    public void add(String key, int hash, int flags, int start, int end) {
        FileData fileData;
        FileData newData;
        FileData oldData;
        int h = key.hashCode() ^ hash;
        ArraySortedSet list = (ArraySortedSet)this.data.get(h);
        if (list == null) {
            list = new ArraySortedSet();
            this.data.put(h, (Object)list);
        }
        if ((oldData = (FileData)list.lookup((Object)(newData = new FileData(this.id)))) == null) {
            list.add((Object)newData);
            fileData = newData;
        } else {
            fileData = oldData;
        }
        fileData.locations.add((Object)new DataLocation(start, end - start));
        IndexerStatistics.addIndexEntry(key);
        ++this.count;
    }

    public int getCount() {
        return this.count;
    }
}

