/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.proxy;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import oracle.dbtools.raptor.proxy.AbstractProxy;
import oracle.jdbc.proxy._Proxy_;

public abstract class ProxyUtils {
    public static String formatMethodCall(Method method, Object[] objectArray, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(method.getName());
        stringBuffer.append("(");
        int n = 0;
        if (objectArray != null) {
            if (bl && objectArray.length != 0) {
                stringBuffer.append("...");
            } else {
                for (Object object : objectArray) {
                    if (n != 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append(ProxyUtils.formatArg(object));
                    ++n;
                }
            }
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public static String formatArg(Object object) {
        Object object2 = object;
        if (object instanceof _Proxy_) {
            object = ((_Proxy_)object)._getDelegate_();
        }
        try {
            if (object instanceof Number || object instanceof Boolean) {
                return object.toString();
            }
            if (object2 instanceof Throwable) {
                return ((Throwable)object2).getLocalizedMessage();
            }
            if (object2 instanceof AbstractProxy) {
                return object.getClass().getName() + '@' + ((AbstractProxy)object2).getProxyContext().getPath();
            }
            if (object != null) {
                return "\"" + object.toString() + "\"";
            }
            return null;
        }
        catch (Exception exception) {
            return "?";
        }
    }

    public static String formatArgMap(Map<Object, String> map) {
        Iterator<Map.Entry<Object, String>> iterator;
        if (map != null && (iterator = map.entrySet().iterator()).hasNext()) {
            StringBuilder stringBuilder = new StringBuilder();
            while (true) {
                Map.Entry<Object, String> entry = iterator.next();
                Object object = entry.getKey();
                String string = entry.getValue();
                stringBuilder.append(ProxyUtils.formatArg(object));
                stringBuilder.append('=');
                stringBuilder.append(string);
                if (!iterator.hasNext()) break;
                stringBuilder.append(',').append(' ');
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public static String scrubClass(String string) {
        if (string != null) {
            return string.replaceAll("oracle[.]", "o.").replaceAll("[.]oracle", ".o").replaceAll("raptor[.]", "r.").replaceAll("[.]raptor", ".r").replaceAll("javatools[.]", "jt.").replaceAll("[.]javatools", ".jt").replaceAll("java[.]", "j.").replaceAll("[.]java", ".j").replaceAll("dbtools[.]", "d.").replaceAll("[.]dbtools", ".d");
        }
        return string;
    }

    public static StackTraceElement[] getSignificantCallerStack(StackTraceElement[] stackTraceElementArray) {
        int n;
        if (stackTraceElementArray == null) {
            return stackTraceElementArray;
        }
        for (int i = n = "getStackTrace".equals(stackTraceElementArray[0].getMethodName()) ? 1 : 0; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            if (!ProxyUtils.isSignificantCaller(stackTraceElement)) continue;
            n = i;
            break;
        }
        return Arrays.copyOfRange(stackTraceElementArray, n, stackTraceElementArray.length);
    }

    public static StackTraceElement getSignificantCaller(StackTraceElement[] stackTraceElementArray) {
        if (stackTraceElementArray != null) {
            int n;
            for (int i = n = "getStackTrace".equals(stackTraceElementArray[0].getMethodName()) ? 1 : 0; i < stackTraceElementArray.length; ++i) {
                StackTraceElement stackTraceElement = stackTraceElementArray[i];
                if (!ProxyUtils.isSignificantCaller(stackTraceElement)) continue;
                return stackTraceElement;
            }
        }
        return null;
    }

    public static boolean isSignificantCaller(StackTraceElement stackTraceElement) {
        return stackTraceElement != null && (stackTraceElement.getClassName().startsWith("oracle.dbtools.", 0) && !stackTraceElement.getClassName().startsWith("oracle.dbtools.raptor.proxy.", 0) || stackTraceElement.getClassName().startsWith("oracle.javatools.", 0));
    }

    public static Level getHigherLogLevel(Level level) {
        if (level == Level.FINEST) {
            return Level.FINER;
        }
        if (level == Level.FINER) {
            return Level.FINE;
        }
        if (level == Level.FINE) {
            return Level.CONFIG;
        }
        if (level == Level.CONFIG) {
            return Level.INFO;
        }
        if (level == Level.INFO) {
            return Level.WARNING;
        }
        if (level == Level.WARNING) {
            return Level.SEVERE;
        }
        return level;
    }

    public static Level getLowerLogLevel(Level level) {
        if (level == Level.FINER) {
            return Level.FINEST;
        }
        if (level == Level.FINEST) {
            return Level.FINEST;
        }
        if (level == Level.FINE) {
            return Level.FINER;
        }
        if (level == Level.CONFIG) {
            return Level.FINE;
        }
        if (level == Level.INFO) {
            return Level.CONFIG;
        }
        if (level == Level.WARNING) {
            return Level.INFO;
        }
        if (level == Level.SEVERE) {
            return Level.WARNING;
        }
        return level;
    }
}

