/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.proxy;

import java.util.Date;
import java.util.Properties;
import javax.swing.event.ChangeEvent;
import oracle.dbtools.raptor.proxy.AbstractProxy;
import oracle.dbtools.raptor.proxy.ProxyRegistry;
import oracle.dbtools.raptor.proxy.ProxyUtils;
import oracle.dbtools.util.GCReapHandler;

public class ProxyContext
implements GCReapHandler {
    private static int topLevelChildren = 0;
    private StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
    private StackTraceElement significantCaller = null;
    private ProxyContext superContext = null;
    private Long openTimestamp;
    private Long closeTimestamp;
    private String prefix;
    private String path;
    private int index;
    private int children;
    private Object delegate;
    private boolean explicitClose;
    private boolean explicitCancel;
    private boolean explicitAbort;
    private Properties properties;
    private AbstractProxy.DelegateCloser closer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int newTopLevelChildIndex() {
        Class<ProxyContext> clazz = ProxyContext.class;
        synchronized (ProxyContext.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return ++topLevelChildren;
        }
    }

    public ProxyContext(String string) {
        this.path = string + "?";
        this.prefix = string;
        this.children = 0;
        this.index = 0;
        this.delegate = null;
        this.explicitClose = false;
        this.explicitCancel = false;
        this.explicitAbort = false;
        this.openTimestamp = new Date().getTime();
        this.closeTimestamp = null;
        this.properties = null;
        this.closer = null;
    }

    protected void initialize(AbstractProxy abstractProxy, Properties properties) {
        this.properties = properties != null ? (Properties)properties.clone() : null;
        this.superContext = abstractProxy.getSuperProxyContext();
        this.index = this.superContext != null ? this.superContext.newChildIndex() : ProxyContext.newTopLevelChildIndex();
        this.path = this.superContext != null ? this.superContext.getPath() + "-" + this.prefix + this.index : this.prefix + this.index;
        this.delegate = abstractProxy.getDelegate();
        this.closer = abstractProxy.getDelegateCloser();
    }

    public ProxyContext getSuperContext() {
        return this.superContext;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int getIndex() {
        return this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int newChildIndex() {
        ProxyContext proxyContext = this;
        synchronized (proxyContext) {
            return ++this.children;
        }
    }

    public String getPath() {
        return this.path;
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public void releaseDelegate() {
        this.closer = null;
        this.delegate = null;
    }

    public StackTraceElement[] getStackTrace() {
        return this.stackTrace;
    }

    public StackTraceElement getSignificantCaller() {
        if (this.significantCaller == null) {
            this.significantCaller = ProxyUtils.getSignificantCaller(this.stackTrace);
        }
        return this.significantCaller;
    }

    public boolean wasExplicitlyClosed() {
        return this.explicitClose;
    }

    public void explicitCloseCalled() {
        this.populateCloseTimestamp();
        this.explicitClose = true;
    }

    public boolean wasExplicitlyCancel() {
        return this.explicitCancel;
    }

    public void explicitCancelCalled() {
        this.explicitCancel = true;
    }

    public boolean wasExplicitlyAbort() {
        return this.explicitAbort;
    }

    public void explicitAbortCalled() {
        this.explicitAbort = true;
    }

    public long getOpenDuration() {
        if (this.closeTimestamp != null && this.openTimestamp != null) {
            return this.closeTimestamp - this.openTimestamp;
        }
        return -1L;
    }

    public long getOpenTimestamp() {
        return this.openTimestamp;
    }

    public void referentDequeued() {
        ProxyRegistry.getInstance().getProxyLogger().stateChanged(new ChangeEvent(this));
        if (!ProxyRegistry.DEBUG_BUILD && this.closer != null) {
            this.closer.close(this, this.delegate);
        }
        this.releaseDelegate();
    }

    public String getConnectionName() {
        ProxyContext proxyContext = this.getSuperContext();
        return proxyContext != null ? proxyContext.getConnectionName() : null;
    }

    public Properties getProperties() {
        return this.properties;
    }

    private void populateCloseTimestamp() {
        if (this.closeTimestamp == null) {
            this.closeTimestamp = new Date().getTime();
        }
    }
}

