/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView.managers;

import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import oracle.dss.dataView.DataviewCommon;
import oracle.dss.dataView.ViewStyleHandle;
import oracle.dss.dataView.managers.RuleManager;
import oracle.dss.dataView.managers.ViewStyle;
import oracle.dss.gridView.GridViewCommon;
import oracle.dss.gridView.GridViewHeaderStyleManager;
import oracle.dss.rules.Mergeable;
import oracle.dss.rules.ResolutionService;
import oracle.dss.rules.RuleBundle;
import oracle.dss.rules.RuleContext;
import oracle.dss.util.EdgeComponentInfo;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.QDR;
import oracle.dss.util.QDRMember;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.xml.ObjectNode;

public class GridViewHeaderRuleStyles
extends RuleManager
implements Cloneable,
GridViewHeaderStyleManager {
    public static final String HEADER_STYLE_MANAGER_NAME = "HeaderStyleManager";
    protected transient EdgeComponentInfo einfo = new EdgeComponentInfo(0, 0, 0);
    private static final String m_method_getMetadataStyle = "ViewStyle getMetadataStyle(GridViewCommon view, Object metaData, ViewStyle initStyle, int edge, int depth, int index)";

    public void dataSourceChanged() {
        this.metadataStyleChanged();
    }

    @Override
    public void metadataStyleChanged() {
    }

    @Override
    public ViewStyle getMetadataStyle(GridViewCommon view, Object metaData, ViewStyle initStyle, int edge, int depth, int index) {
        ViewStyleHandle vsHandle;
        Object obj;
        boolean bRunRules = true;
        boolean bClonedInitStyle = false;
        if (view.isLayerMetaViewStyleSupported()) {
            obj = null;
            try {
                obj = view.getModel().getDataAccess().getLayerMetadata(edge, depth, "viewStyle");
            }
            catch (EdgeOutOfRangeException coore) {
                view.getErrorHandler().log("edge out of range", this.getClass().getName(), m_method_getMetadataStyle);
            }
            catch (LayerOutOfRangeException roore) {
                view.getErrorHandler().log("layer out of range", this.getClass().getName(), m_method_getMetadataStyle);
            }
            vsHandle = null;
            if (obj != null) {
                if (obj instanceof ViewStyleHandle) {
                    vsHandle = (ViewStyleHandle)obj;
                } else {
                    view.getErrorHandler().log("object not ViewStyleHandle type", this.getClass().getName(), m_method_getMetadataStyle);
                }
            }
            if (vsHandle != null) {
                if (vsHandle.getViewStyle() != null) {
                    if (!bClonedInitStyle) {
                        initStyle = (ViewStyle)initStyle.clone();
                        bClonedInitStyle = true;
                    }
                    initStyle.merge((Mergeable)vsHandle.getViewStyle());
                }
                if (vsHandle.getRunRulesForViewStyle() == 0) {
                    bRunRules = false;
                } else if (vsHandle.getRunRulesForViewStyle() == 1) {
                    bRunRules = true;
                }
            }
        }
        if (index > -1 && view.isMetadataViewStyleSupported()) {
            obj = null;
            try {
                obj = view.getModel().getDataAccess().getMemberMetadata(edge, depth, index, "viewStyle");
            }
            catch (EdgeOutOfRangeException coore) {
                view.getErrorHandler().log("edge out of range", this.getClass().getName(), m_method_getMetadataStyle);
            }
            catch (LayerOutOfRangeException roore) {
                view.getErrorHandler().log("layer out of range", this.getClass().getName(), m_method_getMetadataStyle);
            }
            catch (SliceOutOfRangeException soore) {
                view.getErrorHandler().log("slice out of range", this.getClass().getName(), m_method_getMetadataStyle);
            }
            vsHandle = null;
            if (obj != null) {
                if (obj instanceof ViewStyleHandle) {
                    vsHandle = (ViewStyleHandle)obj;
                } else {
                    view.getErrorHandler().log("object not ViewStyleHandle type", this.getClass().getName(), m_method_getMetadataStyle);
                }
            }
            if (vsHandle != null) {
                if (vsHandle.getViewStyle() != null) {
                    if (!bClonedInitStyle) {
                        initStyle = (ViewStyle)initStyle.clone();
                        bClonedInitStyle = true;
                    }
                    initStyle.merge((Mergeable)vsHandle.getViewStyle());
                }
                if (vsHandle.getRunRulesForViewStyle() == 0) {
                    bRunRules = false;
                } else if (vsHandle.getRunRulesForViewStyle() == 1) {
                    bRunRules = true;
                }
            }
        }
        if (!bRunRules) {
            return initStyle;
        }
        this.einfo.setEdgeDepthIndex(edge, depth, index);
        RuleContext location = new RuleContext();
        String type = metaData instanceof Number ? "NUMBER_VALUE" : (metaData instanceof Date ? "DATE_VALUE" : "STRING_VALUE");
        location.put((Object)"POSITION", (Object)this.einfo);
        if (metaData != null) {
            location.put((Object)type, metaData);
        }
        if (view.getModel().getDataAccess() != null) {
            String layerName = null;
            try {
                QDR dimensionQDR = view.getModel().getDataAccess().getLayerQDR(edge, depth, 0);
                if (dimensionQDR != null) {
                    location.put((Object)"DIMENSIONQDR", (Object)dimensionQDR);
                    Enumeration layers = dimensionQDR.getDimensions();
                    if (layers.hasMoreElements()) {
                        layerName = layers.nextElement().toString();
                    }
                }
            }
            catch (EdgeOutOfRangeException ee) {
                view.getErrorHandler().log("edge out of range when getting layer QDR", this.getClass().getName(), m_method_getMetadataStyle);
            }
            catch (LayerOutOfRangeException le) {
                view.getErrorHandler().log("layer out of range when getting layer QDR", this.getClass().getName(), m_method_getMetadataStyle);
            }
            if (index > -1) {
                QDR memberQDR = this.einfo.getQDR(view.getModel().getDataAccess(), 1);
                if (memberQDR != null) {
                    if (layerName != null) {
                        memberQDR.setTarget(new QDRMember(layerName));
                    }
                    location.put((Object)"QDR", (Object)memberQDR);
                }
            } else {
                try {
                    QDR layerQDR = view.getModel().getDataAccess().getLayerQDR(edge, depth, 1);
                    if (layerQDR != null) {
                        if (layerName != null) {
                            layerQDR.setTarget(new QDRMember(layerName));
                        }
                        location.put((Object)"QDR", (Object)layerQDR);
                    }
                }
                catch (EdgeOutOfRangeException eoore) {
                    view.getErrorHandler().log("edge out of range when getting layer QDR", this.getClass().getName(), m_method_getMetadataStyle);
                }
                catch (LayerOutOfRangeException loore) {
                    view.getErrorHandler().log("layer out of range when getting layer QDR", this.getClass().getName(), m_method_getMetadataStyle);
                }
            }
            location.put((Object)"DATA_ACCESS", (Object)view.getModel().getDataAccess());
        }
        if (edge == 0) {
            location.put((Object)"COMPONENT_TYPE", (Object)new Integer(10));
        } else if (edge == 1) {
            location.put((Object)"COMPONENT_TYPE", (Object)new Integer(11));
        } else if (edge == 2) {
            location.put((Object)"COMPONENT_TYPE", (Object)new Integer(3));
        }
        if (initStyle == null) {
            return null;
        }
        ViewStyle style = initStyle;
        Vector bundles = this.m_bundles;
        try {
            if (bundles != null) {
                initStyle = style = (ViewStyle)ResolutionService.resolveRules((RuleContext)location, (Mergeable)initStyle, (Vector)bundles);
            }
            if (this.m_uiBundle != null && initStyle != null) {
                style = (ViewStyle)ResolutionService.resolveRules((RuleContext)location, (Mergeable)initStyle, (RuleBundle)this.m_uiBundle);
            }
        }
        catch (ClassCastException e) {
            return null;
        }
        if (style == null) {
            return null;
        }
        return style;
    }

    @Override
    public void setBundles(DataviewCommon view, Vector bundles) {
        super.setBundles(view, bundles);
        this.metadataStyleChanged();
        if (view != null) {
            view.metadataStyleChanged();
        }
    }

    public void setUIBundle(DataviewCommon view, RuleBundle UIBundle2) {
        super.setUIBundle(view, UIBundle2);
        this.metadataStyleChanged();
        if (view != null) {
            view.metadataStyleChanged();
        }
    }

    public ObjectNode getXML(boolean allProperties, DataviewCommon dataview) {
        return this.getXML(allProperties, HEADER_STYLE_MANAGER_NAME, dataview);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        GridViewHeaderRuleStyles newMgr = new GridViewHeaderRuleStyles();
        newMgr.setBundles(null, this.m_bundles);
        if (this.getUIBundle() != null) {
            newMgr.setUIBundle(null, (RuleBundle)this.getUIBundle().clone());
        } else {
            newMgr.setUIBundle(null, null);
        }
        return newMgr;
    }
}

