/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView.gui;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import oracle.adfdtinternal.model.dvt.util.help.HelpContext;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUtils;
import oracle.dss.gridView.UIFormat;
import oracle.dss.gridView.UIGridView;
import oracle.dss.gridView.gui.FormatsPanel;
import oracle.dss.gridView.gui.StoplightPanel;
import oracle.dss.gridView.gui.StoplightThresholdDialog;

public class StoplightDialog
extends JEWTDialog
implements HelpContext {
    private ResourceBundle m_bundle;
    private StoplightPanel m_panel;
    private HelpProvider m_helpProvider;
    private boolean m_bHelpEnabled;
    private String m_strHelpContextID;
    private UIFormat m_uiFormat;
    private Color m_goodColor;
    private Color m_badColor;
    private Color m_warningColor;

    public StoplightDialog(Frame parent, UIGridView gridView, UIFormat format) {
        super(parent, null, 7);
        this.m_uiFormat = format;
        this._initialize(gridView);
        this.pack();
        this.setResizable(true);
    }

    public StoplightDialog(Dialog parent, UIGridView gridView, UIFormat format) {
        super(parent, null, 7);
        this.m_uiFormat = format;
        this._initialize(gridView);
        this.pack();
        this.setResizable(true);
    }

    public StoplightDialog(Dialog parent, UIGridView gridView, UIFormat format, Color badColor, Color warningColor, Color goodColor) {
        super(parent, null, 7);
        this.m_uiFormat = format;
        this.m_badColor = badColor;
        this.m_goodColor = goodColor;
        this.m_warningColor = warningColor;
        this._initialize(gridView);
        this.pack();
        this.setResizable(true);
    }

    public StoplightDialog(Frame parent, UIGridView gridView, UIFormat format, Color badColor, Color warningColor, Color goodColor) {
        super(parent, null, 7);
        this.m_uiFormat = format;
        this.m_badColor = badColor;
        this.m_goodColor = goodColor;
        this.m_warningColor = warningColor;
        this._initialize(gridView);
        this.pack();
        this.setResizable(true);
    }

    private void _initialize(UIGridView gridView) {
        if (gridView.getLocale() != null) {
            this.setLocale(gridView.getLocale());
        } else {
            this.updateResourceBundle(null);
        }
        this.setTitle(this.m_bundle.getString("STOPLIGHT.TITLE"));
        this.m_panel = new StoplightPanel((Dialog)((Object)this), gridView, this.m_uiFormat, this.m_badColor, this.m_warningColor, this.m_goodColor);
        this.setContent(this.m_panel);
        this.getContent().setSize(this.m_panel.getPreferredSize());
    }

    protected void dismissDialog(boolean cancelled) {
        if (!cancelled) {
            boolean _flag;
            String _unaccept = this.m_panel.getUnacceptableThreshold();
            String _desire = this.m_panel.getDesirableThreshold();
            if (!_unaccept.equals("") && _unaccept.equals(_desire)) {
                boolean _flag2;
                StoplightThresholdDialog _dialog = new StoplightThresholdDialog((Dialog)((Object)this), this.getLocale(), _unaccept);
                _dialog.setHelpProvider(this.getHelpProvider());
                if (this.m_uiFormat != null) {
                    _dialog.setDesirableValue(this.m_uiFormat.isDesirableGreaterThanThreshold());
                }
                if (!(_flag2 = _dialog.runDialog())) {
                    return;
                }
                if (_dialog.getDesirableValue() == 0) {
                    this.m_panel.setDesirableGreaterThanThreshold(true);
                } else {
                    this.m_panel.setDesirableGreaterThanThreshold(false);
                }
            }
            if (!(_flag = this.m_panel.apply())) {
                return;
            }
        }
        super.dismissDialog(cancelled);
    }

    public UIFormat getUIFormat() {
        return this.m_panel.getUIFormat();
    }

    public Color getUnacceptableColor() {
        return this.m_panel.getUnacceptableColor();
    }

    public Color getAcceptableColor() {
        return this.m_panel.getAcceptableColor();
    }

    public Color getDesirableColor() {
        return this.m_panel.getDesirableColor();
    }

    public void apply() {
        this.m_panel.applyStoplightFormat();
    }

    @Override
    public String getHelpContextID() {
        return this.getClass().getName();
    }

    @Override
    public void setHelpContextID(String strHelpContextID) {
        this.m_strHelpContextID = strHelpContextID;
        HelpUtils.setHelpID((JComponent)((JComponent)this.getContent()), (String)this.getHelpContextID());
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
        HelpUtils.setHelpProvider((JComponent)((JComponent)this.getContent()), (HelpProvider)this.m_helpProvider);
        this.m_panel.setHelpProvider(helpProvider);
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    public void setHelpEnabled(boolean bValue) {
        this.m_bHelpEnabled = bValue;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    private void updateResourceBundle(Locale loc) {
        this.m_bundle = loc != null ? ResourceBundle.getBundle("oracle.dss.gridView.gui.resource.GridviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.gridView.gui.resource.GridviewGUIBundle");
    }

    public void setLocale(Locale loc) {
        super.setLocale(loc);
        this.updateResourceBundle(loc);
    }

    public void setFormatsPanel(FormatsPanel panel) {
        this.m_panel.setFormatsPanel(panel);
    }
}

