/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import oracle.adfdtinternal.model.dvt.util.gui.BIColorChoice;
import oracle.adfdtinternal.model.dvt.util.gui.FontButton;
import oracle.adfdtinternal.model.dvt.util.help.HelpContext;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.util.StringUtils;
import oracle.bali.share.util.IntegerUtils;
import oracle.dss.gridView.UIGridView;

public class StoplightColorDialog
extends JEWTDialog
implements HelpContext {
    private ResourceBundle m_bundle;
    private MultiLineLabel m_instruction;
    private JLabel m_unacceptable;
    private BIColorChoice m_unacceptableColor;
    private JLabel m_acceptable;
    private BIColorChoice m_acceptableColor;
    private JLabel m_desirable;
    private BIColorChoice m_desirableColor;
    private HelpProvider m_helpProvider;
    private String m_strHelpContextID;
    private boolean m_bHelpEnabled;

    public StoplightColorDialog(Dialog parent, UIGridView gridView, Color unacceptable, Color acceptable, Color desirable) {
        super(parent, null, 7);
        this._initialize(gridView, unacceptable, acceptable, desirable);
        this.setResizable(true);
    }

    public StoplightColorDialog(Frame parent, UIGridView gridView, Color unacceptable, Color acceptable, Color desirable) {
        super(parent, null, 7);
        this._initialize(gridView, unacceptable, acceptable, desirable);
        this.setResizable(true);
    }

    private void _initialize(UIGridView gridView, Color unacceptable, Color acceptable, Color desirable) {
        if (gridView.getLocale() != null) {
            this.setLocale(gridView.getLocale());
        } else {
            this.updateResourceBundle(null);
        }
        this.setTitle(this.m_bundle.getString("STOPLIGHTCOLOR.TITLE"));
        JPanel _mainPanel = new JPanel();
        ToolTipManager.sharedInstance().registerComponent(_mainPanel);
        _mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 2;
        c.anchor = 17;
        c.ipadx = 0;
        c.ipady = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 4;
        c.gridheight = 1;
        this.m_instruction = new MultiLineLabel();
        this.m_instruction.setPreferredRows(2);
        this.m_instruction.setTextWrapper(WordWrapper.getTextWrapper());
        this.m_instruction.setText(this.m_bundle.getString("STOPLIGHTCOLOR.INSTRUCTION"));
        _mainPanel.add((Component)this.m_instruction, c);
        c.gridy = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.m_unacceptable = new JLabel();
        this.setLabelText(this.m_unacceptable, this.m_bundle.getString("STOPLIGHT.UNACCEPTABLE"));
        _mainPanel.add((Component)this.m_unacceptable, c);
        c.gridx = 1;
        String tooltiptext = this.m_bundle.getString("STOPLIGHT.COLORPALETTETOOLTIP");
        MessageFormat messageformat = new MessageFormat(tooltiptext);
        this.m_unacceptableColor = new BIColorChoice();
        this.m_unacceptableColor.setName("UnacceptableColorChoice");
        this.m_unacceptableColor.setCustomColorsEnabled(gridView.isCustomColorsEnabled());
        if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_unacceptableColor.getColorPalette(), (Color)unacceptable)) {
            this.m_unacceptableColor.setColorPalette(FontButton.getNewColorPalette(this.m_unacceptableColor.getColorPalette(), unacceptable, false));
        }
        this.m_unacceptableColor.setSelectedColor(unacceptable);
        Object[] aobj = new Object[]{IntegerUtils.getInteger((int)unacceptable.getRed()), IntegerUtils.getInteger((int)unacceptable.getGreen()), IntegerUtils.getInteger((int)unacceptable.getBlue())};
        String s1 = messageformat.format(aobj);
        this.m_unacceptableColor.setToolTipText(StringUtils.stripMnemonic((String)this.m_bundle.getString("STOPLIGHT.UNACCEPTABLE")) + " " + s1);
        _mainPanel.add((Component)((Object)this.m_unacceptableColor), c);
        c.gridx = 2;
        c.weightx = 1.0;
        c.gridwidth = 2;
        _mainPanel.add(Box.createHorizontalStrut(1), c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.m_acceptable = new JLabel();
        this.setLabelText(this.m_acceptable, this.m_bundle.getString("STOPLIGHT.ACCEPTABLE"));
        _mainPanel.add((Component)this.m_acceptable, c);
        c.gridx = 1;
        this.m_acceptableColor = new BIColorChoice();
        this.m_acceptableColor.setName("AcceptableColorChoice");
        this.m_acceptableColor.setCustomColorsEnabled(gridView.isCustomColorsEnabled());
        if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_acceptableColor.getColorPalette(), (Color)acceptable)) {
            this.m_acceptableColor.setColorPalette(FontButton.getNewColorPalette(this.m_acceptableColor.getColorPalette(), acceptable, false));
        }
        this.m_acceptableColor.setSelectedColor(acceptable);
        Object[] aobj1 = new Object[]{IntegerUtils.getInteger((int)acceptable.getRed()), IntegerUtils.getInteger((int)acceptable.getGreen()), IntegerUtils.getInteger((int)acceptable.getBlue())};
        s1 = messageformat.format(aobj1);
        this.m_acceptableColor.setToolTipText(StringUtils.stripMnemonic((String)this.m_bundle.getString("STOPLIGHT.ACCEPTABLE")) + " " + s1);
        _mainPanel.add((Component)((Object)this.m_acceptableColor), c);
        c.gridx = 2;
        c.weightx = 1.0;
        c.gridwidth = 2;
        _mainPanel.add(Box.createHorizontalStrut(1), c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.weightx = 0.0;
        this.m_desirable = new JLabel();
        this.setLabelText(this.m_desirable, this.m_bundle.getString("STOPLIGHT.DESIRABLE"));
        _mainPanel.add((Component)this.m_desirable, c);
        c.gridx = 1;
        this.m_desirableColor = new BIColorChoice();
        this.m_desirableColor.setName("DesirableColorChoice");
        this.m_desirableColor.setCustomColorsEnabled(gridView.isCustomColorsEnabled());
        if (!BIColorChoice.isColorInPalette((TwoDModel)this.m_desirableColor.getColorPalette(), (Color)desirable)) {
            this.m_desirableColor.setColorPalette(FontButton.getNewColorPalette(this.m_desirableColor.getColorPalette(), desirable, false));
        }
        this.m_desirableColor.setSelectedColor(desirable);
        Object[] aobj2 = new Object[]{IntegerUtils.getInteger((int)desirable.getRed()), IntegerUtils.getInteger((int)desirable.getGreen()), IntegerUtils.getInteger((int)desirable.getBlue())};
        s1 = messageformat.format(aobj2);
        this.m_desirableColor.setToolTipText(StringUtils.stripMnemonic((String)this.m_bundle.getString("STOPLIGHT.DESIRABLE")) + " " + s1);
        _mainPanel.add((Component)((Object)this.m_desirableColor), c);
        c.gridx = 2;
        c.weightx = 1.0;
        c.gridwidth = 2;
        _mainPanel.add(Box.createHorizontalStrut(1), c);
        c.gridx = 0;
        c.gridwidth = 4;
        c.gridheight = 1;
        c.gridy = 4;
        c.fill = 1;
        c.weighty = 1.0;
        _mainPanel.add(Box.createVerticalStrut(1), c);
        this.setContent(_mainPanel);
    }

    public Color getUnacceptableColor() {
        return this.m_unacceptableColor.getSelectedColor();
    }

    public Color getAcceptableColor() {
        return this.m_acceptableColor.getSelectedColor();
    }

    public Color getDesirableColor() {
        return this.m_desirableColor.getSelectedColor();
    }

    public void cleanup() {
    }

    private void updateResourceBundle(Locale loc) {
        this.m_bundle = loc != null ? ResourceBundle.getBundle("oracle.dss.gridView.gui.resource.GridviewGUIBundle", loc) : ResourceBundle.getBundle("oracle.dss.gridView.gui.resource.GridviewGUIBundle");
    }

    public void setLocale(Locale loc) {
        super.setLocale(loc);
        this.updateResourceBundle(loc);
    }

    @Override
    public String getHelpContextID() {
        return this.getClass().getName();
    }

    @Override
    public void setHelpContextID(String strHelpContextID) {
        this.m_strHelpContextID = strHelpContextID;
        HelpUtils.setHelpID((JComponent)((JComponent)this.getContent()), (String)this.getHelpContextID());
    }

    public void setHelpProvider(HelpProvider helpProvider) {
        this.m_helpProvider = helpProvider;
        HelpUtils.setHelpProvider((JComponent)((JComponent)this.getContent()), (HelpProvider)this.m_helpProvider);
    }

    public HelpProvider getHelpProvider() {
        return this.m_helpProvider;
    }

    public void setHelpEnabled(boolean bValue) {
        this.m_bHelpEnabled = bValue;
    }

    public boolean isHelpEnabled() {
        return this.m_bHelpEnabled;
    }

    private void setLabelText(JLabel label, String text) {
        int _index = StringUtils.getMnemonicIndex((String)text);
        String _text = StringUtils.stripMnemonic((String)text);
        if (_index > -1) {
            char _char = text.charAt(_index + 1);
            label.setDisplayedMnemonic(_char);
        }
        label.setText(_text);
    }
}

