/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.gridView;

import java.util.Enumeration;
import oracle.bali.share.collection.ArrayMap;

public class CSSStyle {
    protected Object[] m_cssStyles;
    private static final int _DEFAULT_BUFFER_SIZE = 100;
    private String _inline;
    private String _block;
    private String m_name;

    public CSSStyle() {
    }

    public CSSStyle(String name) {
        this();
        this.setName(name);
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public Object clone() {
        CSSStyle css = new CSSStyle();
        Enumeration keys = this.getPropertyNames();
        while (keys != null && keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            css.setProperty(key, this.getProperty(key));
        }
        css.setName(this.getName());
        return css;
    }

    public void merge(CSSStyle style) {
        if (style != null) {
            Enumeration keys = style.getPropertyNames();
            while (keys != null && keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                this.setProperty(key, style.getProperty(key));
            }
        }
    }

    public boolean equals(CSSStyle style) {
        boolean rc = true;
        if (style == null) {
            return this.m_cssStyles == null;
        }
        if (this.m_cssStyles.length != style.m_cssStyles.length) {
            return false;
        }
        Enumeration keys = this.getPropertyNames();
        while (keys != null && keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String val1 = this.getProperty(key);
            if (val1 != null) {
                String val = style.getProperty(key);
                if (val1.equals(val)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String name, String value) {
        name = name.toLowerCase();
        CSSStyle cSSStyle = this;
        synchronized (cSSStyle) {
            this.m_cssStyles = ArrayMap.remove((Object[])this.m_cssStyles, (Object)name);
            if (value != null) {
                this.m_cssStyles = ArrayMap.put((Object[])this.m_cssStyles, (Object)name, (Object)value);
            }
            this._inline = null;
            this._block = null;
        }
    }

    public String getProperty(String name) {
        return (String)ArrayMap.get((Object[])this.m_cssStyles, (Object)name.toLowerCase());
    }

    public Enumeration getPropertyNames() {
        return ArrayMap.getKeys((Object[])this.m_cssStyles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toInlineString() {
        String inline = this._inline;
        if (inline != null) {
            return inline;
        }
        Enumeration e = this.getPropertyNames();
        StringBuffer buffer = new StringBuffer(100);
        boolean first = true;
        if (e != null) {
            while (e.hasMoreElements()) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(";");
                }
                String name = (String)e.nextElement();
                String value = this.getProperty(name);
                buffer.append(name);
                buffer.append(":");
                buffer.append(value);
            }
        }
        inline = buffer.toString();
        CSSStyle cSSStyle = this;
        synchronized (cSSStyle) {
            this._inline = inline;
        }
        return inline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toBlockString() {
        String block = this._block;
        if (block != null) {
            return block;
        }
        Enumeration e = this.getPropertyNames();
        StringBuffer buffer = new StringBuffer(100);
        boolean first = true;
        if (this.getName() != null) {
            buffer.append(this.getName());
        } else {
            buffer.append("dummy");
        }
        buffer.append(" {\n");
        if (e != null) {
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = this.getProperty(name);
                buffer.append("  ");
                buffer.append(name);
                buffer.append(":");
                buffer.append(value);
                buffer.append(";\n");
            }
        }
        buffer.append("}\n");
        block = buffer.toString();
        CSSStyle cSSStyle = this;
        synchronized (cSSStyle) {
            this._block = block;
        }
        return block;
    }
}

