/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.gui;

public final class PaperSize {
    private float width;
    private float height;
    private int sizeID;
    private int units;
    private static final float POINTS_TO_INCHES = 0.013888889f;
    private static final float POINTS_TO_CENTIMETERS = 0.035277776f;
    private static final float INCHES_TO_POINTS = 72.0f;
    private static final float INCHES_TO_CENTIMETERS = 2.54f;
    private static final float CENTIMETERS_TO_INCHES = 0.39370078f;
    private static final float CENTIMETERS_TO_POINTS = 28.346457f;
    public static final int UNITS_CM = 0;
    public static final int UNITS_INCH = 1;
    public static final int UNITS_POINTS = 2;
    public static final int LETTER_ID = 10;
    public static final PaperSize LETTER = new PaperSize(21.6f, 27.9f, 10);
    public static final int LEGAL_ID = 11;
    public static final PaperSize LEGAL = new PaperSize(21.6f, 35.6f, 11);
    public static final int TABLOID_ID = 12;
    public static final PaperSize TABLOID = new PaperSize(27.9f, 43.2f, 12);
    public static final int EXECUTIVE_ID = 13;
    public static final PaperSize EXECUTIVE = new PaperSize(19.0f, 25.4f, 13);
    public static final int BROADSHEET_ID = 14;
    public static final PaperSize BROADSHEET = new PaperSize(27.9f, 55.8f, 14);
    public static final int A1_ID = 15;
    public static final PaperSize A1 = new PaperSize(59.4f, 84.1f, 15);
    public static final int A2_ID = 16;
    public static final PaperSize A2 = new PaperSize(42.0f, 59.4f, 16);
    public static final int A3_ID = 17;
    public static final PaperSize A3 = new PaperSize(29.7f, 42.0f, 17);
    public static final int A4_ID = 18;
    public static final PaperSize A4 = new PaperSize(21.0f, 29.7f, 18);
    public static final int A5_ID = 19;
    public static final PaperSize A5 = new PaperSize(14.8f, 21.0f, 19);
    public static final int A6_ID = 20;
    public static final PaperSize A6 = new PaperSize(10.5f, 14.8f, 20);
    public static final int B3_ID = 21;
    public static final PaperSize B3 = new PaperSize(35.3f, 50.0f, 21);
    public static final int B4_ID = 22;
    public static final PaperSize B4 = new PaperSize(25.0f, 35.3f, 22);
    public static final int B5_ID = 23;
    public static final PaperSize B5 = new PaperSize(17.6f, 25.0f, 23);
    public static final int B6_ID = 24;
    public static final PaperSize B6 = new PaperSize(12.5f, 17.6f, 24);
    public static final int C1_ID = 25;
    public static final PaperSize C1 = new PaperSize(64.8f, 91.7f, 25);
    public static final int C2_ID = 26;
    public static final PaperSize C2 = new PaperSize(45.8f, 64.8f, 26);
    public static final int C3_ID = 27;
    public static final PaperSize C3 = new PaperSize(32.4f, 45.8f, 27);
    public static final int C4_ID = 28;
    public static final PaperSize C4 = new PaperSize(22.9f, 32.4f, 28);
    public static final int C5_ID = 29;
    public static final PaperSize C5 = new PaperSize(16.2f, 22.9f, 29);
    public static final int C6_ID = 30;
    public static final PaperSize C6 = new PaperSize(11.4f, 16.2f, 30);

    private PaperSize(float aWidth, float aHeight, int asizeID) {
        this.width = aWidth;
        this.height = aHeight;
        this.sizeID = asizeID;
        this.units = 0;
    }

    public static PaperSize parse(int aPaperSize) {
        if (aPaperSize == 10) {
            return LETTER;
        }
        if (aPaperSize == 11) {
            return LEGAL;
        }
        if (aPaperSize == 14) {
            return BROADSHEET;
        }
        if (aPaperSize == 13) {
            return EXECUTIVE;
        }
        if (aPaperSize == 12) {
            return TABLOID;
        }
        if (aPaperSize == 15) {
            return A1;
        }
        if (aPaperSize == 16) {
            return A2;
        }
        if (aPaperSize == 17) {
            return A3;
        }
        if (aPaperSize == 18) {
            return A4;
        }
        if (aPaperSize == 19) {
            return A5;
        }
        if (aPaperSize == 20) {
            return A6;
        }
        if (aPaperSize == 21) {
            return B3;
        }
        if (aPaperSize == 22) {
            return B4;
        }
        if (aPaperSize == 23) {
            return B5;
        }
        if (aPaperSize == 24) {
            return B6;
        }
        if (aPaperSize == 25) {
            return C1;
        }
        if (aPaperSize == 26) {
            return C2;
        }
        if (aPaperSize == 27) {
            return C3;
        }
        if (aPaperSize == 28) {
            return C4;
        }
        if (aPaperSize == 29) {
            return C5;
        }
        if (aPaperSize == 30) {
            return C6;
        }
        return LETTER;
    }

    public static PaperSize parse(float width, float height) {
        PaperSize paperSize = LETTER;
        float convWidth = PaperSize.convertValues(width, 2, 1, 1);
        float convHeight = PaperSize.convertValues(height, 2, 1, 1);
        if (convWidth == 4.1f) {
            paperSize = A6;
        } else if (convWidth == 4.5f) {
            paperSize = C6;
        } else if (convWidth == 4.9f) {
            paperSize = B6;
        } else if (convWidth == 5.8f) {
            paperSize = A5;
        } else if (convWidth == 6.4f) {
            paperSize = C5;
        } else if (convWidth == 6.9f) {
            paperSize = B5;
        } else if (convWidth == 7.5f) {
            paperSize = EXECUTIVE;
        } else if (convWidth == 8.3f) {
            paperSize = A4;
        } else if (convWidth == 8.5f) {
            if (convHeight == 11.0f) {
                paperSize = LETTER;
            } else if (convHeight == 14.0f) {
                paperSize = LEGAL;
            }
        } else if (convWidth == 9.0f) {
            paperSize = C4;
        } else if (convWidth == 9.8f) {
            paperSize = B4;
        } else if (convWidth == 11.0f) {
            if (convHeight == 17.0f) {
                paperSize = TABLOID;
            } else if (convHeight == 22.0f) {
                paperSize = BROADSHEET;
            }
        } else if (convWidth == 11.7f) {
            paperSize = A3;
        } else if (convWidth == 12.8f) {
            paperSize = C3;
        } else if (convWidth == 13.9f) {
            paperSize = B3;
        } else if (convWidth == 16.5f) {
            paperSize = A2;
        } else if (convWidth == 18.0f) {
            paperSize = C2;
        } else if (convWidth == 23.4f) {
            paperSize = A1;
        } else if (convWidth == 25.5f) {
            paperSize = C1;
        }
        return paperSize;
    }

    public float getWidth(int unitType) {
        return PaperSize.convertValues(this.width, this.units, unitType, 2);
    }

    public float getHeight(int unitType) {
        return PaperSize.convertValues(this.height, this.units, unitType, 2);
    }

    public static float getInches(float aNumber, int unitType) {
        if (unitType == 0) {
            return aNumber * 0.39370078f;
        }
        if (unitType == 1) {
            return aNumber;
        }
        if (unitType == 2) {
            return aNumber * 0.013888889f;
        }
        return aNumber;
    }

    public static float getPixels(float aNumber, int unitType) {
        if (unitType == 0) {
            return aNumber * 28.346457f;
        }
        if (unitType == 1) {
            return aNumber * 72.0f;
        }
        if (unitType == 2) {
            return aNumber;
        }
        return aNumber;
    }

    public static float getCentimeters(float aNumber, int unitType) {
        if (unitType == 0) {
            return aNumber;
        }
        if (unitType == 1) {
            return aNumber * 2.54f;
        }
        if (unitType == 2) {
            return aNumber * 0.035277776f;
        }
        return aNumber;
    }

    public static float convertValues(float aNumber, int sourceUnitType, int targetUnitType, int precision) {
        float myReturnValue = 0.0f;
        if (targetUnitType == 0) {
            myReturnValue = PaperSize.getCentimeters(aNumber, sourceUnitType);
        } else if (targetUnitType == 1) {
            myReturnValue = PaperSize.getInches(aNumber, sourceUnitType);
        } else if (targetUnitType == 2) {
            myReturnValue = PaperSize.getPixels(aNumber, sourceUnitType);
        }
        float roundedReturnValue = PaperSize.round(myReturnValue, precision);
        return roundedReturnValue;
    }

    public static float round(float valueToRound, int precision) {
        float returnValue = valueToRound;
        if (precision >= 0) {
            float myValue = 1.0f;
            for (int x = 0; x < precision; ++x) {
                myValue *= 10.0f;
            }
            returnValue *= myValue;
            returnValue = Math.round(returnValue);
            returnValue /= myValue;
        }
        return returnValue;
    }
}

