/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.datacache;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import oracle.dss.dataView.datacache.Data;
import oracle.dss.dataView.datacache.Edge;
import oracle.dss.dataView.datacache.Map;
import oracle.dss.dataView.datacache.Member;
import oracle.dss.dataView.datacache.PageLayer;
import oracle.dss.util.DataAccess;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.QDR;
import oracle.dss.util.SliceOutOfRangeException;
import oracle.dss.util.xml.BaseNode;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.NoSuchPropertyException;
import oracle.dss.util.xml.ObjectNode;

public class PageEdge
implements Edge {
    private PageLayer[] m_layers;
    private int[] m_defHPos;

    public PageEdge(PageLayer[] layers) {
        this.m_layers = layers;
        this.m_defHPos = new int[this.m_layers.length];
    }

    public PageEdge(ObjectNode edgeNode, Map metadataMap, Map layerMap) {
        int layerCount = 0;
        try {
            layerCount = edgeNode.getPropertyValueAsInteger("layerCount");
        }
        catch (NoSuchPropertyException noSuchPropertyException) {
            // empty catch block
        }
        ContainerNode layersNode = edgeNode.getContainer("Layers");
        if (layersNode == null) {
            layerCount = 0;
        }
        this.m_layers = new PageLayer[layerCount];
        if (layersNode != null) {
            Enumeration entries = layersNode.getContainerNodes("Layer");
            for (int layer = 0; layer < layerCount; ++layer) {
                if (entries.hasMoreElements()) {
                    ContainerNode layerNode = (ContainerNode)entries.nextElement();
                    this.m_layers[layer] = new PageLayer(layerNode, metadataMap, layerMap);
                    continue;
                }
                this.m_layers[layer] = new PageLayer();
            }
        }
        this.m_defHPos = new int[layerCount];
    }

    public PageEdge(DataAccess da, int edge, Map metadataMap, Map layerMap) {
        int slice = 0;
        int layerCount = 0;
        try {
            slice = da.getEdgeCurrentSlice(edge);
            layerCount = da.getLayerCount(edge);
        }
        catch (EdgeOutOfRangeException edgeOutOfRangeException) {
            // empty catch block
        }
        this.m_layers = new PageLayer[layerCount];
        for (int layer = 0; layer < layerCount; ++layer) {
            this.m_layers[layer] = new PageLayer(da, edge, layer, slice, metadataMap, layerMap);
        }
        this.m_defHPos = new int[layerCount];
    }

    @Override
    public ObjectNode addEdgeToXML(String name, Data data, Map metadataMap, Map layerMap) {
        ObjectNode edgeNode = new ObjectNode(name);
        int layerCount = this.getLayerCount();
        edgeNode.addProperty("layerCount", layerCount);
        ContainerNode layersNode = new ContainerNode("Layers");
        for (int layer = 0; layer < layerCount; ++layer) {
            ContainerNode layerNode = this.m_layers[layer].addLayerToXML(metadataMap, layerMap);
            layersNode.addContainedObject((BaseNode)layerNode);
        }
        edgeNode.addContainer(layersNode);
        return edgeNode;
    }

    @Override
    public Object getMemberMetadata(int layer, int slice, String type) throws SliceOutOfRangeException, LayerOutOfRangeException {
        return this.getMember(layer, slice).getMetadata(type);
    }

    @Override
    public Object getLayerMetadata(int layer, String type) throws LayerOutOfRangeException {
        if (layer >= this.m_layers.length) {
            throw new LayerOutOfRangeException(layer, this.m_layers.length - 1);
        }
        return this.m_layers[layer].getMetadata(type);
    }

    @Override
    public int getLayerCount() {
        return this.m_layers.length;
    }

    @Override
    public int getExtent() {
        return 1;
    }

    @Override
    public int getLimit() {
        return -1;
    }

    @Override
    public int getSliceOutlineLayer(int slice) throws SliceOutOfRangeException {
        return 0;
    }

    @Override
    public Object getSliceLabel(int slice) throws SliceOutOfRangeException {
        return null;
    }

    @Override
    public int getSliceMemberCount(int slice) throws SliceOutOfRangeException {
        if (slice != 0) {
            throw new SliceOutOfRangeException(slice, 0);
        }
        return this.m_layers.length;
    }

    @Override
    public int getMemberDepth(int layer, int slice) throws LayerOutOfRangeException, SliceOutOfRangeException {
        this.getMember(layer, slice);
        return 1;
    }

    @Override
    public int getMemberStartLayer(int layer, int slice) throws LayerOutOfRangeException, SliceOutOfRangeException {
        this.getMember(layer, slice);
        return layer;
    }

    @Override
    public int getMemberExtent(int layer, int slice) throws SliceOutOfRangeException, LayerOutOfRangeException {
        this.getMember(layer, slice);
        return 1;
    }

    @Override
    public int getMemberStartSlice(int layer, int slice) throws SliceOutOfRangeException, LayerOutOfRangeException {
        this.getMember(layer, slice);
        return slice;
    }

    @Override
    public int getMemberSiblingCount(int[] hPos, int memberLayer) throws LayerOutOfRangeException, SliceOutOfRangeException {
        return 1;
    }

    @Override
    public Object getMemberMetadata(int[] hPos, int memberLayer, int hIndex, String type) throws LayerOutOfRangeException, SliceOutOfRangeException {
        return this.getMemberMetadata(memberLayer, 0, type);
    }

    @Override
    public int[] getMemberHPos(int layer, int slice) throws LayerOutOfRangeException, SliceOutOfRangeException {
        this.getMember(layer, slice);
        return new int[layer + 1];
    }

    @Override
    public int[] getFirstHPos() {
        return this.m_defHPos;
    }

    @Override
    public int[] getLastHPos() {
        return this.m_defHPos;
    }

    @Override
    public int[] getPrevHPos(int[] hPos) throws LayerOutOfRangeException, SliceOutOfRangeException {
        return null;
    }

    @Override
    public int[] getNextHPos(int[] hPos) throws LayerOutOfRangeException, SliceOutOfRangeException {
        return null;
    }

    @Override
    public int getCurrentSlice() {
        return 0;
    }

    @Override
    public int[] getCurrentHPos() {
        return this.m_defHPos;
    }

    @Override
    public QDR getSliceQDR(int slice) {
        return null;
    }

    @Override
    public QDR getMemberQDR(int layer, int slice) {
        return null;
    }

    private Member getMember(int layer, int slice) throws SliceOutOfRangeException, LayerOutOfRangeException {
        if (slice != 0) {
            throw new SliceOutOfRangeException(slice, 0);
        }
        if (layer < 0) {
            throw new LayerOutOfRangeException(slice, 0);
        }
        if (layer >= this.m_layers.length) {
            throw new LayerOutOfRangeException(slice, this.m_layers.length - 1);
        }
        return this.m_layers[layer].getMember();
    }

    @Override
    public Enumeration getMemberEnumeration(int layer) {
        return new _MemberEnumeration(layer);
    }

    private class _MemberEnumeration
    implements Enumeration {
        private Member member;

        _MemberEnumeration(int layer) {
            this.member = PageEdge.this.m_layers[layer].getMember();
        }

        @Override
        public boolean hasMoreElements() {
            return this.member != null;
        }

        public Object nextElement() throws NoSuchElementException {
            Member ret = null;
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            ret = this.member;
            this.member = null;
            return ret;
        }
    }
}

