/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.datacache;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.dss.dataView.datacache.Layer;
import oracle.dss.dataView.datacache.Map;
import oracle.dss.dataView.datacache.Member;
import oracle.dss.util.DataAccess;
import oracle.dss.util.xml.BaseNode;
import oracle.dss.util.xml.BaseObjectNode;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;

public class CubeLayer
extends Layer {
    private Dictionary m_members = new Hashtable();

    public CubeLayer(ContainerNode layerNode, Map layerMap, Map metadataMap) {
        super((BaseObjectNode)layerNode, layerMap);
        Enumeration members = layerNode.getContainedObject("Member");
        while (members.hasMoreElements()) {
            ObjectNode memberNode = (ObjectNode)members.nextElement();
            Member member = new Member(memberNode, metadataMap);
            String val = (String)member.getMetadata("value");
            if (val == null) continue;
            this.putMember(val, member);
        }
    }

    public CubeLayer(DataAccess da, int edge, int layer, Map layerMap) {
        super(da, edge, layer, layerMap);
    }

    public ContainerNode addLayerToXML(Map metadataMap, Map layerMap) {
        ContainerNode layerNode = super.addLayerToXML(layerMap);
        Enumeration members = this.m_members.keys();
        while (members.hasMoreElements()) {
            Member member = this.getMember(members.nextElement());
            ObjectNode memberNode = member.addMemberToXML(metadataMap);
            layerNode.addContainedObject((BaseNode)memberNode);
        }
        return layerNode;
    }

    public Member getMember(Object value) {
        return (Member)this.m_members.get(value);
    }

    public void putMember(Object value, Member member) {
        this.m_members.put(value, member);
    }

    Dictionary getMembers() {
        return this.m_members;
    }
}

