/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.crosstab;

import oracle.dss.crosstab.CrosstabDefaultValues;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class Total {
    protected int layer;
    protected int type;
    protected String label;
    public static final String a_layer = "layer";
    public static final String a_type = "type";
    public static final String a_label = "label";
    protected static final String TOTAL_NAME = "Total";
    protected static final String total_all_layers = "TOTAL_ALL_LAYERS";
    protected static final String grand_total_layer = "GRAND_TOTAL_LAYER";
    protected static final String no_totals = "NO_TOTALS";
    protected static final String total_sum = "TOTAL_SUM";
    protected static final String total_average = "TOTAL_AVERAGE";
    protected static final String total_minimum = "TOTAL_MINIMUM";
    protected static final String total_maximum = "TOTAL_MAXIMUM";

    public Total() {
        this.layer = CrosstabDefaultValues.getTotalLayer();
        this.type = CrosstabDefaultValues.getTotalType();
        this.label = CrosstabDefaultValues.getTotalLabel();
    }

    public Total(int layer, int type, String label) {
        this.layer = layer;
        this.type = type;
        this.label = label;
    }

    public int getLayer() {
        return this.layer;
    }

    public void setLayer(int layer) {
        this.layer = layer;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    protected void setXML(ObjectNode node) {
        PropertyNode pNode = node.getProperty(a_layer);
        if (pNode != null) {
            this.setLayer(this.convertLayerToInt(pNode.getValueAsString()));
        }
        if ((pNode = node.getProperty(a_type)) != null) {
            this.setType(this.convertTypeToInt(pNode.getValueAsString()));
        }
        if ((pNode = node.getProperty(a_label)) != null) {
            this.setLabel(pNode.getValueAsString());
        }
    }

    protected ObjectNode getXML(boolean allProperties) {
        ObjectNode node = new ObjectNode(TOTAL_NAME);
        boolean nodeExists = false;
        if (allProperties || this.layer != CrosstabDefaultValues.getTotalLayer()) {
            node.addProperty(a_layer, this.convertLayerToString(this.getLayer()));
            nodeExists = true;
        }
        if (allProperties || this.type != CrosstabDefaultValues.getTotalType()) {
            node.addProperty(a_type, this.convertTypeToString(this.getType()));
            nodeExists = true;
        }
        if (allProperties || !this.label.equals(CrosstabDefaultValues.getTotalLabel())) {
            node.addProperty(a_label, this.getLabel());
            nodeExists = true;
        }
        if (nodeExists) {
            return node;
        }
        return null;
    }

    protected int convertLayerToInt(String slayer) {
        int layer = slayer.equals(total_all_layers) ? -1 : (slayer.equals(grand_total_layer) ? 0 : -2);
        return layer;
    }

    protected String convertLayerToString(int layer) {
        String str = "";
        switch (layer) {
            case -1: {
                str = total_all_layers;
                break;
            }
            case 0: {
                str = grand_total_layer;
                break;
            }
            case -2: {
                str = no_totals;
            }
        }
        return str;
    }

    protected int convertTypeToInt(String stype) {
        int itype = stype.equals(total_average) ? 2 : (stype.equals(total_minimum) ? 3 : (stype.equals(total_maximum) ? 4 : 1));
        return itype;
    }

    protected String convertTypeToString(int type) {
        String str = total_sum;
        switch (type) {
            case 1: {
                str = total_sum;
                break;
            }
            case 2: {
                str = total_average;
                break;
            }
            case 3: {
                str = total_minimum;
                break;
            }
            case 4: {
                str = total_maximum;
            }
        }
        return str;
    }
}

