/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.model.dvt.util.gui.component.tree;

import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JTree;
import oracle.adfdtinternal.model.dvt.util.gui.component.ComponentNode;
import oracle.adfdtinternal.model.dvt.util.gui.component.tree.CheckableTreeNodeImpl;
import oracle.adfdtinternal.model.dvt.util.gui.component.tree.ComponentTreeNode;

public class ComponentTreeNodeImpl
extends CheckableTreeNodeImpl
implements ComponentTreeNode {
    private Hashtable m_hashtableEnv = null;
    private Vector m_vCachedChildren = null;

    public ComponentTreeNodeImpl(JTree jTree, ComponentNode componentNode, Hashtable hashtableEnv) {
        super(jTree, componentNode);
        this.setEnvironment(hashtableEnv);
    }

    @Override
    public ComponentNode getComponentNode() {
        Object object = this.getUserObject();
        if (object instanceof ComponentNode) {
            return (ComponentNode)object;
        }
        return null;
    }

    @Override
    public void refresh() {
        this.removeCachedChildren();
        super.refresh();
    }

    @Override
    public Icon getOpenIcon() {
        return null;
    }

    @Override
    public Icon getClosedIcon() {
        return null;
    }

    @Override
    public JTree getTree() {
        Object objComponent;
        JTree jTree = super.getTree();
        if (jTree == null && this.m_hashtableEnv != null && (objComponent = this.m_hashtableEnv.get("tree")) != null && objComponent instanceof JTree) {
            jTree = (JTree)objComponent;
        }
        return jTree;
    }

    public void setEnvironment(Hashtable environment) {
        this.m_hashtableEnv = environment;
    }

    public Hashtable getEnvironment() {
        return this.m_hashtableEnv;
    }

    @Override
    protected Vector getChildren(int nIndex, int nOffset) {
        if (this.getCachedChildren() == null) {
            this.setCachedChildren(this.getAllChildren());
            if (this.getCachedChildren() != null) {
                this.setSize(this.getCachedChildren().size());
            }
        }
        return ComponentTreeNodeImpl.subVector(this.getCachedChildren(), nIndex, nOffset);
    }

    protected Vector getAllChildren() {
        return null;
    }

    protected Vector getCachedChildren() {
        return this.m_vCachedChildren;
    }

    protected void setCachedChildren(Vector vCachedChildren) {
        this.m_vCachedChildren = vCachedChildren;
    }

    protected void removeCachedChildren() {
        Vector vCachedChildren = this.getCachedChildren();
        if (vCachedChildren != null) {
            for (int nIndex = vCachedChildren.size() - 1; nIndex >= 0; --nIndex) {
                vCachedChildren.set(nIndex, null);
            }
            this.setCachedChildren(null);
        }
    }

    private static Vector subVector(Vector v, int nIndex, int nOffset) {
        if (v != null) {
            Vector vSub = new Vector();
            try {
                for (int i = nIndex; i < nIndex + nOffset; ++i) {
                    vSub.add(v.get(i));
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return vSub;
        }
        return null;
    }
}

