/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.model.dvt.util.gui.component.tree;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import oracle.adfdtinternal.model.dvt.util.gui.component.tree.CheckTreeCellRenderer;
import oracle.adfdtinternal.model.dvt.util.gui.component.tree.Checkable;
import oracle.adfdtinternal.model.dvt.util.gui.component.tree.VirtualTreeCellEditor;

public class CheckTreeCellEditor
extends VirtualTreeCellEditor {
    private CheckTreeCellRenderer m_checkTreeCellRenderer = null;
    private Object m_objValue = null;
    private boolean m_bChecksEditable = true;

    public CheckTreeCellEditor(JTree jTree, CheckTreeCellRenderer checkTreeCellRenderer) {
        super(jTree, checkTreeCellRenderer);
        this.setCheckTreeCellRenderer(checkTreeCellRenderer);
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        boolean blnEditable = super.isCellEditable(eventObject);
        if (!blnEditable && eventObject instanceof MouseEvent && this.isChecksEditable()) {
            TreePath treePath;
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            JTree jTree = this.getTree();
            if (mouseEvent != null && jTree != null && (treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null) {
                Object object = treePath.getLastPathComponent();
                blnEditable = object instanceof Checkable;
            }
        }
        return blnEditable;
    }

    @Override
    public Component getTreeCellEditorComponent(JTree jTree, Object objValue, boolean bIsSelected, boolean bIsExpanded, boolean bLeaf, int nRow) {
        this.setValue(objValue);
        if (this.getCheckTreeCellRenderer() != null) {
            return this.getCheckTreeCellRenderer().getTreeCellRendererComponent(jTree, objValue, true, bIsExpanded, bLeaf, nRow, true);
        }
        return null;
    }

    @Override
    public Object getCellEditorValue() {
        JCheckBox jCheckBox;
        if (this.getValue() instanceof Checkable && this.getCheckTreeCellRenderer() != null && (jCheckBox = this.getCheckTreeCellRenderer().getCheckBox()) != null) {
            boolean bSelected = jCheckBox.isSelected() || jCheckBox.getModel().isPressed();
            ((Checkable)this.getValue()).setChecked(bSelected);
        }
        return this.getValue();
    }

    public void setChecksEditable(boolean blnChecksEditable) {
        this.m_bChecksEditable = blnChecksEditable;
    }

    public boolean isChecksEditable() {
        return this.m_bChecksEditable;
    }

    public void setCheckTreeCellRenderer(CheckTreeCellRenderer checkTreeCellRenderer) {
        this.m_checkTreeCellRenderer = checkTreeCellRenderer;
    }

    public CheckTreeCellRenderer getCheckTreeCellRenderer() {
        return this.m_checkTreeCellRenderer;
    }

    public void setValue(Object objValue) {
        this.m_objValue = objValue;
    }

    public Object getValue() {
        return this.m_objValue;
    }
}

