/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfdtinternal.model.dvt.util.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.EventListener;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicComboPopup;
import oracle.bali.ewt.button.PopupButton;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.olaf.OracleLookAndFeel;
import oracle.bali.share.nls.StringUtils;

public class InsertButton
extends PopupButton
implements ActionListener,
FocusListener {
    protected Vector m_Vector = new Vector();
    protected boolean m_insertAdded = false;
    protected JComboBox m_jComboBox = null;
    protected MyBasicComboPopup m_basicComboPopup = null;
    protected String m_selectedItem = null;
    protected int m_selectedIndex = -1;
    protected int m_maximumRowCount = 4;
    protected ActionListener m_actionListener;
    protected boolean m_bSuperCalled = false;
    protected ActionListener m_editAction;
    protected int m_saveVerticalScrollbarWidth = 0;
    public static final int DEFAULT_TYPE = 0;
    public static final int S_TYPE = 1;
    public static final int R_TYPE = 2;
    private KeyListener m_keyListener;
    private ResourceBundle rBundle = null;
    private int m_type = 0;
    private int m_maxPopupHeight;

    public InsertButton() {
        super((Icon)new ImageIcon(ImageUtils.getImageResource(InsertButton.class, (String)"images/PopupButtonArrow.gif")));
        this.updateResourceBundle(null);
        this._setPreferredSize();
        this.setEnabled(false);
        this.setType(this.m_type);
    }

    public InsertButton(Object[] name) {
        super((Icon)new ImageIcon(ImageUtils.getImageResource(InsertButton.class, (String)"images/PopupButtonArrow.gif")));
        this.m_bSuperCalled = true;
        this.updateResourceBundle(null);
        this._setPreferredSize();
        this.setEnabled(true);
        this.setType(this.m_type);
        if (this.m_Vector != null) {
            this.m_Vector.removeAllElements();
        }
        this.m_jComboBox = new JComboBox();
        this.m_jComboBox.setName("InsertCombo");
        for (int y = 0; y < name.length; ++y) {
            this.m_jComboBox.addItem(name[y]);
            this.m_Vector.addElement((String)name[y]);
        }
        int count = this.m_Vector.size();
        if (count > this.m_maximumRowCount) {
            count = this.m_maximumRowCount;
            this._saveVerticalScrollbarWidth();
        }
        this.m_jComboBox.setMaximumRowCount(count);
        this.m_jComboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.m_actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InsertButton.this.m_selectedIndex = InsertButton.this.m_jComboBox.getSelectedIndex();
                InsertButton.this.m_selectedItem = (String)InsertButton.this.m_jComboBox.getSelectedItem();
                InsertButton.this.notifyActionListeners();
                InsertButton.this.m_basicComboPopup.setVisible(false);
            }
        };
        this.m_jComboBox.addActionListener(this.m_actionListener);
        this.m_basicComboPopup = new MyBasicComboPopup(this.m_jComboBox);
        this.m_basicComboPopup.setName("InsertComboPopup");
        if (UIManager.getLookAndFeel() instanceof OracleLookAndFeel) {
            this.m_basicComboPopup.setBorder(UIManager.getBorder("Button.border"));
        }
        this.setMaximumRowCount(count);
        this.setMaxPopupHeight();
        this.setPopupMenu(this.m_basicComboPopup);
        this.addActionListener(this);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                InsertButton.this.internalKeyPressed(e);
            }
        });
        this.addFocusListener(this);
    }

    private void setMaxPopupHeight() {
        if (this.m_Vector != null) {
            this.setMaximumRowCount(this.m_Vector.size());
            this.m_maxPopupHeight = this.m_basicComboPopup.getPreferredSize().height;
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        try {
            if (!e.isTemporary() && this.m_basicComboPopup.isVisible()) {
                this.m_basicComboPopup.setVisible(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int iButtonWidth = 0;
        int iPopupWidth = 0;
        int x = 0;
        if (e.getSource() == this) {
            iButtonWidth = this.getPreferredSize().width;
            iPopupWidth = this.m_basicComboPopup.getPreferredSize().width;
            x = iButtonWidth - iPopupWidth;
            if (this.isShowing()) {
                Component parentWindow = SwingUtilities.getRoot((Component)((Object)this));
                Point compLocation = SwingUtilities.convertPoint((Component)((Object)this), this.getLocation(), parentWindow);
                int newHeight = parentWindow.getSize().height - (compLocation.y + this.getPreferredSize().height);
                if (this.m_maxPopupHeight > newHeight) {
                    this.m_basicComboPopup.setPreferredSize(new Dimension(this.m_basicComboPopup.getPreferredSize().width, newHeight));
                } else {
                    this.m_basicComboPopup.setPreferredSize(new Dimension(this.m_basicComboPopup.getPreferredSize().width, this.m_maxPopupHeight));
                }
                this.m_basicComboPopup.show((Component)((Object)this), x, this.getPreferredSize().height);
            }
            if (!this.m_basicComboPopup.isVisible()) {
                this.m_selectedItem = null;
                this.m_selectedIndex = -1;
            }
        }
    }

    public void setType(int type) {
        this.m_type = type;
        String key = this.m_type == 0 ? "Insert" : (this.m_type == 1 ? "Insert-S" : (this.m_type == 2 ? "Insert-R" : "Insert"));
        String translatedText = this.rBundle.getString(key);
        this.setText(StringUtils.stripMnemonic((String)translatedText));
        this.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this.setHorizontalTextPosition(2);
    }

    public void setLocale(Locale loc) {
        super.setLocale(loc);
        if (!this.m_bSuperCalled) {
            return;
        }
        this.updateResourceBundle(loc);
        this._setPreferredSize();
    }

    public void setModel(ComboBoxModel comboBoxModel) {
        this.m_jComboBox.setModel(comboBoxModel);
    }

    public String getSelectedItem() {
        String strTemp = this.m_selectedItem;
        this.m_selectedItem = null;
        return strTemp;
    }

    public int getSelectedIndex() {
        int iTemp = this.m_selectedIndex;
        this.m_selectedIndex = -1;
        return iTemp;
    }

    public void setItems(Object[] name) {
        this.setModel(new DefaultComboBoxModel<Object>(name));
        this.setType(this.m_type);
        this.setEnabled(true);
    }

    public void notifyActionListeners() {
        EventListener[] eventListeners = this.getListeners(ActionListener.class);
        for (int nIndex = 0; nIndex < eventListeners.length; ++nIndex) {
            ActionListener actionListener = (ActionListener)eventListeners[nIndex];
            ActionEvent actionEvent = new ActionEvent(this, this.m_selectedIndex, this.m_selectedItem);
            actionListener.actionPerformed(actionEvent);
        }
    }

    public void setMaximumRowCount(int iRowCount) {
        this.m_maximumRowCount = iRowCount;
        if (this.m_jComboBox != null) {
            this.m_basicComboPopup.setMaximumRowCount(this.m_maximumRowCount);
        }
    }

    protected void updateResourceBundle(Locale loc) {
        this.rBundle = loc != null ? ResourceBundle.getBundle("oracle.adfdtinternal.model.dvt.util.gui.resource.UtilGUIBundle", loc) : ResourceBundle.getBundle("oracle.adfdtinternal.model.dvt.util.gui.resource.UtilGUIBundle");
    }

    private void _setPreferredSize() {
        String strTemp = this.rBundle.getString("Insert-R");
        JLabel insertLabel = new JLabel(StringUtils.stripMnemonic((String)strTemp));
        int width = this.getToolkit().getFontMetrics(insertLabel.getFont()).stringWidth(insertLabel.getText());
        int iconWidth = this.getIcon().getIconWidth();
        this.setPreferredSize(new Dimension(width + iconWidth + 40, 26));
        this.setMinimumSize(this.getPreferredSize());
        this.setMaximumSize(this.getPreferredSize());
    }

    private void _saveVerticalScrollbarWidth() {
        int count;
        JScrollBar scrollbar = new JScrollBar();
        if (this.m_Vector != null && (count = this.m_Vector.size()) > this.m_maximumRowCount) {
            this.m_saveVerticalScrollbarWidth = scrollbar.getPreferredSize().width;
        }
    }

    private void internalKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27 && this.m_basicComboPopup.isVisible()) {
            this.m_basicComboPopup.setVisible(false);
            e.consume();
        }
        if (e.getKeyCode() == 40 || e.getKeyCode() == 39) {
            if (this.m_basicComboPopup.isVisible() && this.m_jComboBox.getSelectedIndex() < this.m_jComboBox.getItemCount() - 1) {
                this.m_jComboBox.removeActionListener(this.m_actionListener);
                this.m_jComboBox.setSelectedIndex(this.m_jComboBox.getSelectedIndex() + 1);
                this.m_jComboBox.addActionListener(this.m_actionListener);
            }
        } else if (e.getKeyCode() == 38 || e.getKeyCode() == 37) {
            if (this.m_basicComboPopup.isVisible() && this.m_jComboBox.getSelectedIndex() != 0) {
                this.m_jComboBox.removeActionListener(this.m_actionListener);
                this.m_jComboBox.setSelectedIndex(this.m_jComboBox.getSelectedIndex() - 1);
                this.m_jComboBox.addActionListener(this.m_actionListener);
            }
        } else if (e.getKeyCode() == 10 && this.m_basicComboPopup.isVisible()) {
            this.m_selectedIndex = this.m_jComboBox.getSelectedIndex();
            this.m_selectedItem = (String)this.m_jComboBox.getSelectedItem();
            this.notifyActionListeners();
        }
    }

    public class MyBasicComboPopup
    extends BasicComboPopup {
        JComboBox comboBox;
        int m_basicComboPopupHeight;
        int m_basicComboPopupWidth;

        public MyBasicComboPopup(JComboBox cBox) {
            super(cBox);
            this.m_basicComboPopupHeight = 0;
            this.m_basicComboPopupWidth = 0;
            this.comboBox = cBox;
            this.m_basicComboPopupHeight = this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount());
        }

        public void setMaximumRowCount(int iRowCount) {
            this.comboBox.setMaximumRowCount(iRowCount);
            this.m_basicComboPopupHeight = this.getPopupHeightForRowCount(this.comboBox.getMaximumRowCount());
            if (UIManager.getLookAndFeel() instanceof OracleLookAndFeel) {
                this.m_basicComboPopupHeight += 4;
            }
            if (this.m_basicComboPopupWidth == 0) {
                this.m_basicComboPopupWidth = InsertButton.this.m_basicComboPopup.getPreferredSize().width + InsertButton.this.m_saveVerticalScrollbarWidth;
            }
            InsertButton.this.m_basicComboPopup.setPreferredSize(new Dimension(this.m_basicComboPopupWidth, this.m_basicComboPopupHeight + 2));
        }
    }
}

