/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import oracle.jdevimpl.audit.util.ComparableComparator;

public class SortedCollections {
    public static <T0, T1> ComparisonIterator<T0, T1> comparisonIterator(Collection<T0> left, Collection<T1> right, Comparator comparator) {
        return new ComparisonIterator<T0, T1>(left, right, comparator);
    }

    public static <T extends Comparable<T>> ComparisonIterator<T, T> comparisonIterator(Collection<T> left, Collection<T> right) {
        return new ComparisonIterator<T, T>(left, right, new ComparableComparator());
    }

    public static class ComparisonIterator<T0, T1>
    implements Iterator<Comparison> {
        private Comparator comparator;
        private Iterator<T0> iLeft;
        private Iterator<T1> iRight;
        private T0 left;
        private T1 right;
        private T0 nextLeft;
        private T1 nextRight;

        public ComparisonIterator(Collection<T0> left, Collection<T1> right, Comparator comparator) {
            this.comparator = comparator;
            if (left != null && !left.isEmpty()) {
                this.iLeft = left.iterator();
                this.nextLeft = this.iLeft.next();
            }
            if (right != null && !right.isEmpty()) {
                this.iRight = right.iterator();
                this.nextRight = this.iRight.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextLeft != null || this.nextRight != null;
        }

        @Override
        public Comparison next() {
            this.left = this.nextLeft;
            this.right = this.nextRight;
            if (this.left == null) {
                if (this.right == null) {
                    throw new NoSuchElementException();
                }
                this.nextRight = this.iRight.hasNext() ? this.iRight.next() : null;
                return Comparison.GREATER_THAN;
            }
            if (this.right == null) {
                this.nextLeft = this.iLeft.hasNext() ? this.iLeft.next() : null;
                return Comparison.LESS_THAN;
            }
            int comparison = this.comparator.compare(this.left, this.right);
            if (comparison < 0) {
                this.nextLeft = this.iLeft.hasNext() ? this.iLeft.next() : null;
                return Comparison.LESS_THAN;
            }
            if (comparison > 0) {
                this.nextRight = this.iRight.hasNext() ? this.iRight.next() : null;
                return Comparison.GREATER_THAN;
            }
            this.nextLeft = this.iLeft.hasNext() ? this.iLeft.next() : null;
            this.nextRight = this.iRight.hasNext() ? this.iRight.next() : null;
            return Comparison.EQUAL;
        }

        public T0 left() {
            return this.left;
        }

        public T1 right() {
            return this.right;
        }

        @Override
        public void remove() {
        }
    }

    public static enum Comparison {
        LESS_THAN,
        EQUAL,
        GREATER_THAN;

    }
}

