/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.util;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import oracle.ide.util.ArraySortedSet;
import oracle.jdevimpl.audit.util.ComparableComparator;
import oracle.jdevimpl.audit.util.UnmodifiableIterator;

public class KeyedSortedSet
extends AbstractSet
implements SortedSet {
    private final Comparator comparator;
    private final Extractor keyExtractor;
    private SortedSet sorted;
    private HashMap unsorted;
    private int size;
    private volatile int version;

    public KeyedSortedSet(Extractor keyExtractor) {
        this(new ComparableComparator(), keyExtractor);
    }

    public KeyedSortedSet(Comparator comparator, Extractor keyExtractor) {
        this.comparator = comparator;
        this.keyExtractor = keyExtractor;
        this.sorted = new ArraySortedSet((Comparator)new PartitionComparator());
        this.unsorted = new HashMap();
        this.size = 0;
        this.version = 0;
    }

    public KeyedSortedSet(KeyedSortedSet set) {
        this(set.comparator(), set.keyExtractor());
        this.addAll(set);
    }

    public Extractor keyExtractor() {
        return this.keyExtractor;
    }

    public Comparator comparator() {
        return this.comparator;
    }

    public Object first() {
        Object first = this.sorted.first();
        SortedSet partition = (SortedSet)first;
        return partition.first();
    }

    public SortedSet headSet(Object to) {
        return new CompositePartitionSet(this, null, to);
    }

    public Object last() {
        return ((SortedSet)this.sorted.last()).last();
    }

    public SortedSet subSet(Object from, Object to) {
        return new CompositePartitionSet(this, from, to);
    }

    public SortedSet tailSet(Object from) {
        return new CompositePartitionSet(this, from, null);
    }

    private void added(int count, PartitionSet partition) {
        this.size += count;
        if (partition.size() == count) {
            boolean added = this.sorted.add(partition);
            assert (added);
        }
        ++this.version;
    }

    private void removed(int count, PartitionSet partition) {
        this.size -= count;
        if (partition.isEmpty()) {
            boolean removed = this.sorted.remove(partition);
            assert (removed);
        }
        ++this.version;
    }

    private PartitionSet createPartition(Object object) {
        Object key = this.keyExtractor.key(object);
        PartitionSet partition = (PartitionSet)this.unsorted.get(key);
        if (partition == null) {
            partition = new PartitionSet(key);
            this.unsorted.put(key, partition);
        }
        return partition;
    }

    private PartitionSet getPartition(Object object) {
        Object key = this.keyExtractor.key(object);
        PartitionSet partition = (PartitionSet)this.unsorted.get(key);
        if (partition == null) {
            partition = new PartitionSet(key);
            this.unsorted.put(key, partition);
        }
        return partition;
    }

    @Override
    public boolean add(Object object) {
        return this.createPartition(object).add(object);
    }

    @Override
    public void clear() {
        while (this.size > 0) {
            PartitionSet partition = (PartitionSet)this.sorted.first();
            partition.clear();
        }
    }

    @Override
    public boolean contains(Object object) {
        PartitionSet partition = this.getPartition(object);
        if (partition != null) {
            return partition.contains(object);
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator iterator() {
        return new ElementIterator(this, this.sorted.iterator());
    }

    @Override
    public boolean remove(Object object) {
        PartitionSet partition = this.getPartition(object);
        if (partition != null) {
            return partition.remove(object);
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    private static class ElementIterator
    implements Iterator {
        private KeyedSortedSet root;
        private int version;
        private Iterator partitions;
        private Iterator elements;
        private Object next;

        public ElementIterator(KeyedSortedSet root, Iterator partitions) {
            this.root = root;
            this.version = root.version;
            this.partitions = partitions;
            if (partitions.hasNext()) {
                this.elements = ((SortedSet)partitions.next()).iterator();
                this.next = this.elements.next();
            }
        }

        @Override
        public boolean hasNext() {
            if (this.version != this.root.version) {
                throw new ConcurrentModificationException();
            }
            return this.next != null;
        }

        public Object next() {
            if (this.version != this.root.version) {
                throw new ConcurrentModificationException();
            }
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Object element = this.next;
            if (this.elements.hasNext()) {
                this.next = this.elements.next();
            } else if (this.partitions.hasNext()) {
                this.elements = ((SortedSet)this.partitions.next()).iterator();
                this.next = this.elements.next();
            } else {
                this.next = null;
            }
            return element;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class PartitionIterator
    implements Iterator {
        private KeyedSortedSet root;
        private Object last;
        private Object lastKey;
        private Iterator iterator;
        private SortedSet next;

        public PartitionIterator(KeyedSortedSet root, Object first, Object last) {
            this.root = root;
            this.last = last;
            if (last != null) {
                this.lastKey = root.keyExtractor.key(last);
            }
            if (first != null) {
                Object headKey = root.keyExtractor.key(first);
                this.iterator = root.sorted.tailSet(headKey).iterator();
                if (this.iterator.hasNext()) {
                    PartitionSet partition = (PartitionSet)this.iterator.next();
                    Object key = partition.key;
                    if (key.equals(headKey)) {
                        this.advance(partition.tailSet(first), key);
                    } else {
                        this.advance(partition, key);
                    }
                }
            } else {
                this.iterator = root.sorted.iterator();
                this.advance();
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            SortedSet partition = this.next;
            assert (!partition.isEmpty());
            this.advance();
            return partition;
        }

        private void advance() {
            if (this.iterator.hasNext()) {
                PartitionSet partition = (PartitionSet)this.iterator.next();
                this.advance(partition, partition.key);
            } else {
                this.next = null;
            }
        }

        private void advance(SortedSet set, Object key) {
            if (this.last == null) {
                this.next = set;
                if (this.next.isEmpty()) {
                    this.advance();
                }
            } else if (this.lastKey.equals(key)) {
                this.next = set.headSet(this.last);
                if (this.next.isEmpty()) {
                    this.advance();
                }
            } else if (this.root.comparator().compare(key, this.last) <= 0) {
                this.next = set;
                if (this.next.isEmpty()) {
                    this.advance();
                }
            } else {
                this.next = null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class CompositePartitionSet
    extends AbstractSet
    implements SortedSet {
        private KeyedSortedSet root;
        private Object first;
        private Object last;

        public CompositePartitionSet(KeyedSortedSet set, Object first, Object last) {
            this.root = set;
            this.first = first;
            this.last = last;
        }

        private boolean contained(Object object) {
            return !(this.first != null && this.root.comparator.compare(this.first, object) > 0 || this.last != null && this.root.comparator.compare(object, this.last) >= 0);
        }

        private Iterator partitionIterator() {
            return new PartitionIterator(this.root, this.first, this.last);
        }

        public Comparator comparator() {
            return this.root.comparator;
        }

        public Object first() {
            return ((SortedSet)this.partitionIterator().next()).first();
        }

        public SortedSet headSet(Object to) {
            if (!this.contained(to)) {
                throw new IllegalArgumentException();
            }
            return new CompositePartitionSet(this.root, this.first, to);
        }

        public Object last() {
            PartitionSet partition;
            Iterator i = this.partitionIterator();
            do {
                partition = (PartitionSet)i.next();
            } while (i.hasNext());
            return partition.last();
        }

        public SortedSet subSet(Object from, Object to) {
            if (!this.contained(from)) {
                throw new IllegalArgumentException();
            }
            if (!this.contained(to)) {
                throw new IllegalArgumentException();
            }
            return new CompositePartitionSet(this.root, from, to);
        }

        public SortedSet tailSet(Object from) {
            if (!this.contained(from)) {
                throw new IllegalArgumentException();
            }
            return new CompositePartitionSet(this.root, from, this.last);
        }

        @Override
        public boolean add(Object object) {
            if (!this.contained(object)) {
                throw new IllegalArgumentException();
            }
            return this.root.add(object);
        }

        @Override
        public void clear() {
            ArrayList partitions = new ArrayList();
            Iterator i = this.partitionIterator();
            while (i.hasNext()) {
                partitions.add(i.next());
            }
            for (int i2 = 0; i2 < partitions.size(); ++i2) {
                PartitionSet partition = (PartitionSet)partitions.get(i2);
                partition.clear();
            }
        }

        @Override
        public boolean contains(Object object) {
            if (!this.contained(object)) {
                return false;
            }
            return this.root.contains(object);
        }

        @Override
        public boolean isEmpty() {
            Iterator i = this.partitionIterator();
            while (i.hasNext()) {
                if (((SortedSet)i.next()).isEmpty()) continue;
                return false;
            }
            return true;
        }

        @Override
        public Iterator iterator() {
            return new ElementIterator(this.root, this.partitionIterator());
        }

        @Override
        public boolean remove(Object object) {
            if (!this.contained(object)) {
                return false;
            }
            return this.root.remove(object);
        }

        @Override
        public int size() {
            int size = 0;
            Iterator i = this.partitionIterator();
            while (i.hasNext()) {
                size += ((SortedSet)i.next()).size();
            }
            return size;
        }
    }

    private class PartitionSet
    implements SortedSet {
        private PartitionSet partition;
        private SortedSet subset;
        private Object key;

        public PartitionSet(Object key) {
            this.partition = this;
            this.subset = new ArraySortedSet(KeyedSortedSet.this.comparator);
            this.key = key;
        }

        public PartitionSet(PartitionSet partition, SortedSet subset, Object key) {
            this.partition = partition;
            this.subset = subset;
            this.key = key;
        }

        public Comparator comparator() {
            return KeyedSortedSet.this.comparator;
        }

        public Object first() {
            return this.subset.first();
        }

        public SortedSet headSet(Object to) {
            return new PartitionSet(this.partition, this.subset.headSet(to), this.key);
        }

        public Object last() {
            return this.subset.last();
        }

        public SortedSet subSet(Object from, Object to) {
            return new PartitionSet(this.partition, this.subset.subSet(from, to), this.key);
        }

        public SortedSet tailSet(Object from) {
            return new PartitionSet(this.partition, this.subset.tailSet(from), this.key);
        }

        @Override
        public boolean add(Object object) {
            if (this.subset.add(object)) {
                KeyedSortedSet.this.added(1, this.partition);
                return true;
            }
            return false;
        }

        @Override
        public boolean addAll(Collection c) {
            int size = this.subset.size();
            if (this.subset.addAll(c)) {
                int count = this.subset.size() - size;
                assert (count > 0);
                KeyedSortedSet.this.added(count, this.partition);
                return true;
            }
            assert (size == this.subset.size());
            return false;
        }

        @Override
        public void clear() {
            int count = this.subset.size();
            this.subset.clear();
            KeyedSortedSet.this.removed(count, this.partition);
        }

        @Override
        public boolean contains(Object o) {
            return this.subset.contains(o);
        }

        @Override
        public boolean containsAll(Collection c) {
            return this.subset.containsAll(c);
        }

        @Override
        public boolean equals(Object o) {
            return this.subset.equals(o);
        }

        @Override
        public int hashCode() {
            return this.subset.hashCode();
        }

        @Override
        public boolean isEmpty() {
            return this.subset.isEmpty();
        }

        @Override
        public Iterator iterator() {
            return new UnmodifiableIterator(this.subset.iterator());
        }

        @Override
        public boolean remove(Object object) {
            if (this.subset.remove(object)) {
                KeyedSortedSet.this.removed(1, this.partition);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection c) {
            int size = this.subset.size();
            if (this.subset.removeAll(c)) {
                int count = size - this.subset.size();
                assert (count > 0);
                KeyedSortedSet.this.removed(count, this.partition);
                return true;
            }
            assert (size == this.subset.size());
            return false;
        }

        @Override
        public boolean retainAll(Collection c) {
            int size = this.subset.size();
            if (this.subset.retainAll(c)) {
                int count = size - this.subset.size();
                assert (count > 0);
                KeyedSortedSet.this.removed(count, this.partition);
                return true;
            }
            assert (size == this.subset.size());
            return false;
        }

        @Override
        public int size() {
            return this.subset.size();
        }

        @Override
        public Object[] toArray() {
            return this.subset.toArray();
        }

        @Override
        public Object[] toArray(Object[] a) {
            return this.subset.toArray(a);
        }

        public String toString() {
            return this.subset.toString();
        }
    }

    public static interface Extractor {
        public Object key(Object var1);
    }

    private class PartitionComparator
    implements Comparator {
        private PartitionComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof PartitionSet) {
                o1 = ((PartitionSet)o1).key;
            }
            if (o2 instanceof PartitionSet) {
                o2 = ((PartitionSet)o2).key;
            }
            return KeyedSortedSet.this.comparator.compare(o1, o2);
        }
    }
}

