/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.swing;

import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import oracle.jdevimpl.audit.swing.TableTransferable;

public class RowTableTransferHandler
extends TransferHandler {
    @Override
    protected Transferable createTransferable(JComponent component) {
        if (component instanceof JTable) {
            int[] rows;
            JTable table = (JTable)component;
            if (!table.getRowSelectionAllowed() && !table.getColumnSelectionAllowed()) {
                return null;
            }
            if (!table.getRowSelectionAllowed()) {
                rows = new int[table.getRowCount()];
                for (int i = 0; i < rows.length; ++i) {
                    rows[i] = i;
                }
            } else {
                rows = table.getSelectedRows();
            }
            if (rows == null || rows.length == 0) {
                return null;
            }
            StringBuilder plainBuffer = new StringBuilder();
            StringBuilder htmlBuffer = new StringBuilder();
            htmlBuffer.append("<html>\n<body>\n<table>\n");
            for (int i = 0; i < rows.length; ++i) {
                int row = rows[i];
                Object value = this.getRowValue(table, row);
                String text = value != null ? value.toString() : "";
                htmlBuffer.append("<tr><td>");
                htmlBuffer.append(text);
                htmlBuffer.append("</td></tr>\n");
                plainBuffer.append(text);
                if (i >= rows.length) continue;
                plainBuffer.append("\n");
            }
            htmlBuffer.append("</table>\n</body>\n</html>");
            return new TableTransferable(plainBuffer.toString(), htmlBuffer.toString());
        }
        return null;
    }

    protected Object getRowValue(JTable table, int row) {
        return table.getModel().getValueAt(row, 0);
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }
}

