/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import oracle.javatools.util.Log;
import oracle.jdevimpl.audit.swing.AbstractCheckBoxTreeModel;
import oracle.jdevimpl.audit.swing.CheckBoxTreeModel;

public class CheckBoxTreeCellRenderer
extends JCheckBox
implements TreeCellRenderer,
Icon {
    private static final Log LOG = new Log("checkboxtree");
    TreeCellRenderer delegate;
    private Dimension iconSize;
    private Component delegateComponent;
    private int row;
    private Object value;
    private Boolean state = Boolean.FALSE;
    private Color overlayKey;
    private Color overlayColor;

    public CheckBoxTreeCellRenderer(TreeCellRenderer defaultRenderer) {
        this.setHorizontalAlignment(2);
        this.setBorderPaintedFlat(true);
        this.setFocusPainted(false);
        this.setOpaque(false);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setBorder(null);
        this.setText(null);
        this.iconSize = super.getPreferredSize();
        this.delegate = defaultRenderer;
    }

    public int getCheckBoxWidth() {
        return this.iconSize.width;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean focused) {
        Color background;
        this.value = value;
        this.row = row;
        this.setEnabled(tree.isEnabled());
        this.setComponentOrientation(tree.getComponentOrientation());
        CheckBoxTreeModel model = (CheckBoxTreeModel)tree.getModel();
        LOG.trace("**** getting renderer component for row {0}, value {1}, model {2}", row, value, model.getClass());
        String text = null;
        this.state = false;
        boolean modified = false;
        if (value != null) {
            text = model.convertValueToText(value);
            this.state = model.getState(value);
            if (model instanceof AbstractCheckBoxTreeModel) {
                modified = ((AbstractCheckBoxTreeModel)model).isModified(value);
                LOG.trace("row {0} value {1} state {2}, modified {3}", (Object)row, value, (Object)this.state, (Object)modified);
            }
        }
        this.setSelected(this.state == null || this.state != false);
        this.delegateComponent = this.delegate.getTreeCellRendererComponent(tree, text, selected, expanded, leaf, row, focused);
        this.delegateComponent.setEnabled(tree.isEnabled());
        Font font = this.delegateComponent.getFont().deriveFont(modified ? 2 : 0);
        this.delegateComponent.setFont(font);
        if (this.delegateComponent instanceof JLabel) {
            ((JLabel)this.delegateComponent).setIcon(this);
        }
        if (!(background = tree.getBackground()).equals(this.overlayKey)) {
            this.overlayKey = background;
            this.overlayColor = new Color(background.getRed(), background.getGreen(), background.getBlue(), 127);
        }
        AccessibleContext context = this.getAccessibleContext();
        context.setAccessibleName(text);
        return this;
    }

    void forwardKeyEvent(KeyEvent event) {
        this.processKeyEvent(event);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = this.delegateComponent.getPreferredSize();
        return size;
    }

    @Override
    public void paint(Graphics graphics) {
        LOG.trace("painting renderer row {0}, state {1}, text {2}, font {3}", this.row, (Object)this.state, this.value, (Object)this.getFont());
        super.paint(graphics);
        this.delegateComponent.setBounds(0, 0, this.getWidth(), this.getHeight());
        this.delegateComponent.paint(graphics);
    }

    @Override
    public int getIconHeight() {
        return this.iconSize.height;
    }

    @Override
    public int getIconWidth() {
        return this.iconSize.width;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.state == null) {
            Color oldColor = g.getColor();
            g.setColor(this.overlayColor);
            g.fillRect(x + 1, y + 1, this.iconSize.width - 2, this.iconSize.height - 2);
            g.setColor(oldColor);
        }
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    @Override
    public String toString() {
        return "renderer {row " + this.row + ", value " + this.value + ", state " + this.state + ", selected " + this.isSelected() + "}";
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleIndeterminateCheckBox();
        }
        return this.accessibleContext;
    }

    protected class AccessibleIndeterminateCheckBox
    extends JCheckBox.AccessibleJCheckBox {
        protected AccessibleIndeterminateCheckBox() {
            super(CheckBoxTreeCellRenderer.this);
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet set = super.getAccessibleStateSet();
            if (CheckBoxTreeCellRenderer.this.state == null) {
                set.add(AccessibleState.INDETERMINATE);
            }
            return set;
        }
    }
}

