/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.report;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.IdeUtil;
import oracle.jdevimpl.audit.report.AuditReporter;
import oracle.jdevimpl.audit.report.StyleSheet;
import oracle.jdevimpl.audit.report.XmlReporter;

public class XsltReporter<T>
implements AuditReporter {
    private URL outputFile;
    private XmlReporter<T> xmlReporter;
    private URL intermediateFile;
    private StyleSheet stylesheet;
    private String title;
    private String encoding = IdeUtil.getIdeIanaEncoding();
    private T model;

    public void setEncoding(String encoding) {
        if (encoding == null) {
            encoding = IdeUtil.getIdeIanaEncoding();
        }
        this.encoding = encoding;
    }

    public void setOutputFile(URL file) {
        this.outputFile = file;
    }

    public void setXmlReporter(XmlReporter reporter) {
        this.xmlReporter = reporter;
    }

    public void setIntermediateFile(URL file) {
        this.intermediateFile = file;
    }

    public StyleSheet getStylesheet() {
        return this.stylesheet;
    }

    public void setStyleSheet(StyleSheet stylesheet) {
        this.stylesheet = stylesheet;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setModel(T model) {
        this.model = model;
    }

    public T getModel() {
        return this.model;
    }

    @Override
    public void report() throws InvocationTargetException {
        URL xmlFile;
        if (this.intermediateFile != null) {
            xmlFile = this.intermediateFile;
        } else {
            try {
                xmlFile = URLFileSystem.createTempFile((String)"audit", (String)".tmp", null);
            }
            catch (Throwable e) {
                throw new InvocationTargetException(e);
            }
        }
        this.xmlReporter.setTitle(this.title);
        this.xmlReporter.setOutputFile(xmlFile);
        this.xmlReporter.setEncoding(this.encoding);
        this.xmlReporter.setModel(this.model);
        this.xmlReporter.report();
        BufferedInputStream inputStream = null;
        OutputStream outputStream = null;
        boolean throwing = false;
        try {
            inputStream = new BufferedInputStream(URLFileSystem.openInputStream((URL)xmlFile));
            StreamSource input = new StreamSource(inputStream, xmlFile.toString());
            outputStream = new BufferedOutputStream(this.outputFile != null ? URLFileSystem.openOutputStream((URL)this.outputFile) : new StandardOutputStream());
            StreamResult output = new StreamResult(outputStream);
            output.setSystemId(this.outputFile != null ? this.outputFile.toString() : "file:///dev/stdout");
            this.stylesheet.apply(input, output, this.encoding);
        }
        catch (IOException e) {
            throwing = true;
            throw new InvocationTargetException(e);
        }
        catch (TransformerException e) {
            throwing = true;
            throw new InvocationTargetException(e);
        }
        finally {
            block29: {
                Node node;
                block28: {
                    block27: {
                        try {
                            if (inputStream != null) {
                                ((InputStream)inputStream).close();
                            }
                        }
                        catch (IOException e) {
                            if (throwing) break block27;
                            throw new InvocationTargetException(e);
                        }
                    }
                    try {
                        if (outputStream != null) {
                            outputStream.close();
                        }
                    }
                    catch (IOException e) {
                        if (throwing) break block28;
                        throw new InvocationTargetException(e);
                    }
                }
                if (this.intermediateFile == null) {
                    URLFileSystem.delete((URL)xmlFile);
                }
                if ((node = NodeFactory.find((URL)this.outputFile)) != null) {
                    try {
                        node.revert();
                    }
                    catch (IOException e) {
                        if (throwing) break block29;
                        throw new InvocationTargetException(e);
                    }
                }
            }
        }
    }

    private static class StandardOutputStream
    extends PrintStream {
        public StandardOutputStream() {
            super(System.out, false);
        }

        @Override
        public void close() {
            this.flush();
        }
    }
}

