/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.profile;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.jdeveloper.audit.AuditManager;
import oracle.jdeveloper.audit.service.Profile;
import oracle.jdevimpl.audit.profile.AuditProfileDialog;
import oracle.jdevimpl.audit.profile.ProfileBundle;
import oracle.jdevimpl.audit.profile.ProfileComboBox;
import oracle.jdevimpl.audit.profile.ProfileModel;
import oracle.jdevimpl.audit.profile.SelectionOverridingProfileModel;
import oracle.jdevimpl.audit.swing.DialogFactory;
import oracle.jdevimpl.audit.util.Cache;

public class AuditDialog
implements ActionListener {
    private static final String DIALOG_HELP_TOPIC = "f1_aud_dlg_html";
    private static final String SELECTION_KEY = "audit.profile.dialog.selection";
    private final String description;
    private JComponent component;
    private JComboBox selector;
    private JButton editButton;
    private ProfileModel model;
    private AuditProfileDialog editDialog;

    public AuditDialog(String description) {
        this.description = description;
    }

    public Profile show() {
        final JComponent component = (JComponent)this.getComponent();
        DialogFactory dialog = new DialogFactory();
        dialog.setTitle(ProfileBundle.format("run.audit.title", this.description));
        dialog.setContent(component);
        dialog.setHelpTopic(DIALOG_HELP_TOPIC);
        dialog.setResizable(false);
        dialog.addCancelButton(null);
        final JButton ok = dialog.addOkButton(new JButton(ProfileBundle.get("run.ok.label")));
        dialog.setDefaultButton(ok);
        ok.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                Dimension size = ok.getSize();
                AuditDialog.this.editButton.setPreferredSize(size);
                AuditDialog.this.editButton.setMaximumSize(size);
                AuditDialog.this.editButton.setMinimumSize(size);
                component.revalidate();
            }
        });
        JButton command = dialog.show();
        if (ok == command) {
            Profile profile = (Profile)this.selector.getSelectedItem();
            Cache.put(SELECTION_KEY, profile.getName());
            return profile;
        }
        return null;
    }

    protected Component createComponent() {
        AuditManager manager = AuditManager.getAuditManager();
        this.model = new ProfileModel(manager.getDefaultProfileRepository());
        JLabel label = new JLabel(ProfileBundle.get("run.selector.label"));
        label.setDisplayedMnemonic(ProfileBundle.get("run.selector.mnemonic").charAt(0));
        this.selector = new ProfileComboBox((ComboBoxModel)new SelectionOverridingProfileModel(this.model));
        label.setLabelFor(this.selector);
        this.editButton = new JButton(ProfileBundle.get("run.edit.label"));
        this.editButton.setMnemonic(ProfileBundle.get("run.edit.mnemonic").charAt(0));
        JPanel component = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets.top = 5;
        constraints.insets.bottom = 5;
        component.add((Component)label, constraints);
        constraints.fill = 2;
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.insets.left = 12;
        component.add((Component)this.selector, constraints);
        constraints.fill = 0;
        constraints.gridx = 2;
        constraints.weightx = 0.0;
        constraints.insets.left = 12;
        component.add((Component)this.editButton, constraints);
        this.editButton.addActionListener(this);
        String selectionName = (String)Cache.get(SELECTION_KEY);
        Profile selection = this.model.getProfile(selectionName, "oracle.ide.audit.audit-rules");
        assert (selection != null);
        this.selector.setSelectedItem(selection);
        return component;
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = (JComponent)this.createComponent();
        }
        return this.component;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Profile profile;
        Window window = SwingUtilities.getWindowAncestor(this.component);
        this.model.setSelectedItem(this.selector.getSelectedItem());
        if (this.editDialog == null) {
            this.editDialog = new AuditProfileDialog(this.model);
        }
        if ((profile = this.editDialog.show(window)) != null) {
            this.selector.setSelectedItem(profile);
        }
    }
}

