/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.model;

import java.net.URL;
import java.util.Collection;
import java.util.EnumSet;
import javax.swing.Icon;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.WorkingSet;
import oracle.jdeveloper.audit.model.ContainerModelAdapter;
import oracle.jdeveloper.audit.model.ContentCache;
import oracle.jdeveloper.audit.model.ContentDirectory;
import oracle.jdeveloper.audit.model.ContentRoot;
import oracle.jdeveloper.audit.model.Location;
import oracle.jdeveloper.audit.model.ModelAdapter;
import oracle.jdeveloper.audit.model.ModelFactory;
import oracle.jdeveloper.audit.model.ModelType;

public class ProjectModelAdapter
extends ContainerModelAdapter {
    private final Project project;

    public ProjectModelAdapter(ModelFactory factory, ModelType type, ContainerModelAdapter workspace, Project project) {
        super(factory, type, workspace, project, project.getURL());
        this.project = project;
    }

    @Override
    public URL getUrl() {
        return this.project.getURL();
    }

    @Override
    public ContainerModelAdapter getContainingAdapter() {
        return this.getWorkspaceAdapter();
    }

    @Override
    public ContentDirectory getDirectory() {
        return null;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    protected void collectContainedElements() {
        ContentCache cache = this.getFactory().getContentSetCache(this.project, this.getWorkspace());
        Collection<ContentDirectory> roots = cache.getRootDirectories(EnumSet.of(ContentRoot.PROJECT));
        for (ContentDirectory directory : roots) {
            this.addContainedElement(directory, directory.getURL());
        }
    }

    @Override
    public int compareTo(ModelAdapter that) {
        if (this == that) {
            return 0;
        }
        assert (this.getFactory() == that.getFactory()) : "generation mismatch: " + this + " - " + that;
        int comparison = ProjectModelAdapter.compareSiblings(this.getWorkspaceAdapter(), that.getWorkspaceAdapter());
        if (comparison != 0) {
            return comparison;
        }
        comparison = ProjectModelAdapter.compareSiblings(this, that.getProjectAdapter());
        if (comparison == 0) {
            comparison = -1;
        }
        return comparison;
    }

    @Override
    public boolean contains(ModelAdapter that) {
        assert (this.getFactory() == that.getFactory()) : "generation mismatch: " + this + " - " + that;
        return this.getWorkspaceAdapter() == that.getWorkspaceAdapter() && this == that.getProjectAdapter();
    }

    @Override
    public boolean contains(Object construct, Location location) {
        assert (this.getFactory() == location.getModel().getFactory()) : "generation mismatch: " + this + " - " + location;
        assert (this.getProject().equals(construct));
        assert (this == location.getModel());
        return true;
    }

    @Override
    public Node getNode() {
        return this.project;
    }

    @Override
    public boolean isModifiable() {
        return !this.project.isReadOnly();
    }

    @Override
    public Object getLabel(Object construct) {
        String text = ((Element)construct).getShortLabel();
        WorkingSet workingSet = this.getFactory().getWorkingSet();
        if (workingSet != null) {
            text = text + " (" + workingSet.getName() + ')';
        }
        return text;
    }

    @Override
    public Object getSummary(Object construct) {
        String text = ((Element)construct).getToolTipText();
        WorkingSet workingSet = this.getFactory().getWorkingSet();
        if (workingSet != null) {
            text = text + " (" + workingSet.getName() + ')';
        }
        return text;
    }

    @Override
    public Icon getIcon(Object construct) {
        return ((Element)construct).getIcon();
    }
}

