/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.markers;

import java.text.MessageFormat;
import oracle.ide.adapters.AdapterFactory;
import oracle.ide.markers.Marker;
import oracle.ide.markers.MarkerLabelProvider;
import oracle.ide.model.LabelProvider;
import oracle.jdeveloper.audit.markers.AuditTaskMarker;

public class AuditTaskMarkerLabelProvider
implements LabelProvider<AuditTaskMarker>,
AdapterFactory<AuditTaskMarker, LabelProvider> {
    private static final LabelProvider<Marker> BASE = new MarkerLabelProvider();
    private static final String[] PRIORITY_STRINGS = new String[]{"!!!", " !!", "  !"};
    private static final String TASK_MSG_FORMAT = "{0} - {1} {2}";

    public String labelFor(AuditTaskMarker marker, String key) {
        String label = BASE.labelFor((Object)marker, key);
        if ("description".equalsIgnoreCase(key)) {
            label = MessageFormat.format(TASK_MSG_FORMAT, PRIORITY_STRINGS[marker.priority()], marker.tag(), marker.description());
        }
        return label;
    }

    public LabelProvider adapt(AuditTaskMarker marker) {
        return this;
    }
}

