/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.core;

import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import oracle.javatools.util.Log;
import oracle.javatools.util.MultiMap;
import oracle.javatools.util.Tuple;
import oracle.jdeveloper.audit.extension.BeanDefinition;
import oracle.jdeveloper.audit.extension.ExtensionBean;
import oracle.jdeveloper.audit.service.AuditLogger;
import oracle.jdeveloper.audit.service.Profile;
import oracle.jdeveloper.audit.service.ProfileTransaction;
import oracle.jdeveloper.audit.service.ValueHandle;
import oracle.jdevimpl.audit.core.DefaultProfile;
import oracle.jdevimpl.audit.util.Beans;
import oracle.jdevimpl.audit.util.PropertyDescriptor;

public class DefaultProfileTransaction
implements PropertyChangeListener,
ProfileTransaction {
    private Profile profile;
    private boolean sealed;
    private final Map<String, ExtensionBean> beans = new HashMap<String, ExtensionBean>();
    private MultiMap<String, ValueHandle> pendingChangedValues;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Thread thread;
    private static final ValueHandle ENABLED_TRUE = new ValueHandle("enabled", "true", true);
    private static final ValueHandle ENABLED_FALSE = new ValueHandle("enabled", "false", false);
    private static final Log LOG = new Log("profile", "profile-detail");

    private void preconditions() {
        assert (this.thread == Thread.currentThread()) : "transaction for profile '" + this.profile.getName() + "' created in thread '" + this.thread.getName() + "' but accessed in thread '" + Thread.currentThread().getName() + "'";
        assert (this.pendingChangedValues != null) : "transaction for profile '" + this.profile.getName() + "' already committed";
    }

    public DefaultProfileTransaction(DefaultProfile profile) {
        LOG.trace("transaction created for {0}", (Object)profile);
        this.profile = profile;
        this.sealed = profile.isSealed();
        this.pendingChangedValues = new MultiMap();
        this.thread = Thread.currentThread();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public Profile getProfile() {
        return this.profile;
    }

    @Override
    public Collection<BeanDefinition> getDefinitions() {
        return this.profile.getDefinitions();
    }

    @Override
    public BeanDefinition getDefinition(String id) {
        return this.profile.getDefinition(id);
    }

    @Override
    public boolean isSealed() {
        return this.sealed;
    }

    @Override
    public void setSealed(boolean newValue) {
        boolean oldValue = this.sealed;
        boolean wasModified = this.isModified();
        this.sealed = newValue;
        this.propertyChangeSupport.firePropertyChange("sealed", oldValue, newValue);
        this.propertyChangeSupport.firePropertyChange("modified", wasModified, this.isModified());
    }

    @Override
    public boolean isEnabled(String id) {
        ValueHandle pendingChangedValue = this.getPendingChangedValue(id, "enabled");
        if (pendingChangedValue != null) {
            return pendingChangedValue.isTrue();
        }
        return this.profile.isEnabled(id);
    }

    @Override
    public void setEnabled(String id, boolean enabled) {
        this.mergeValue(id, "enabled", enabled ? ENABLED_TRUE : ENABLED_FALSE);
    }

    private void mergePropertyChange(String id, Object bean, String propertyName, Object oldValue, Object newValue) {
        Object profileValue;
        LOG.trace("merging change {0} from {1} to {2} of {3} in {4}", (Object)propertyName, oldValue, newValue, (Object)id, (Object)this);
        boolean wasModified = this.isModified();
        if (oldValue == null ? newValue == null : oldValue.equals(newValue)) {
            throw new IllegalArgumentException("newValue equals oldValue");
        }
        BeanDefinition definition = this.getDefinition(id);
        if (definition == null) {
            throw new IllegalArgumentException("Bean " + id + " not defined");
        }
        if (bean != this.getBean(id, false)) {
            throw new IllegalStateException("Bean " + id + " not created by this transaction: expected " + this.getBean(id, false) + "; actual " + bean);
        }
        this.removePendingChangedValue(id, propertyName);
        try {
            ValueHandle changedValue = this.profile.getChangedValue(id, propertyName);
            profileValue = changedValue != null ? changedValue.getValueForProperty(bean) : this.profile.getDefaultValue(definition, propertyName);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Getting default value of bean \"" + id + "#" + propertyName + "\" failed: " + e);
        }
        if (newValue == null ? profileValue != null : !newValue.equals(profileValue)) {
            this.pendingChangedValues.add((Object)id, (Object)new ValueHandle(propertyName, null, newValue));
        }
        this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(definition, propertyName, oldValue, newValue));
        this.propertyChangeSupport.firePropertyChange("modified", wasModified, this.isModified());
        LOG.trace("completed merging change {0} from {1} to {2} of {3} in {4}", (Object)propertyName, oldValue, newValue, (Object)id, (Object)this);
    }

    private void mergeValue(String id, String propertyName, ValueHandle newHandle) {
        LOG.trace("merging value {0}#{1} to {2} in {3}", (Object)id, (Object)propertyName, (Object)newHandle, (Object)this);
        this.preconditions();
        if (newHandle == null) {
            throw new IllegalArgumentException("newHandle == null");
        }
        BeanDefinition definition = this.getDefinition(id);
        ExtensionBean bean = this.getBean(id, false);
        if (definition != null) {
            ValueHandle oldHandle;
            if (bean != null) {
                try {
                    Object newValue = newHandle.getRepresentation() == DEFAULT_VALUE ? this.profile.getDefaultValue(definition, propertyName) : newHandle.getValueForProperty(bean);
                    Beans.setPropertyValue(bean, propertyName, newValue);
                }
                catch (Exception e) {
                    AuditLogger.error(e, "Setting value of {0}#{1} failed: {2}", id, propertyName, e);
                }
                return;
            }
            if ("enabled".equals(propertyName) && definition.hasEnabledProperty()) {
                boolean newValue;
                if (newHandle.getRepresentation() == DEFAULT_VALUE) {
                    newValue = definition.isEnabledByDefault();
                    newHandle = newValue ? ENABLED_TRUE : ENABLED_FALSE;
                } else {
                    newValue = newHandle.isTrue();
                }
                boolean oldValue = this.isEnabled(id);
                if (oldValue != newValue) {
                    boolean wasModified = this.isModified();
                    this.removePendingChangedValue(id, propertyName);
                    if (newValue != this.profile.isEnabled(id)) {
                        this.pendingChangedValues.add((Object)id, (Object)newHandle);
                    }
                    this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(definition, propertyName, oldValue, newValue));
                    this.propertyChangeSupport.firePropertyChange("modified", wasModified, this.isModified());
                }
                return;
            }
            ValueHandle pendingChangedValue = this.getPendingChangedValue(id, propertyName);
            ValueHandle valueHandle = oldHandle = pendingChangedValue != null ? pendingChangedValue : this.profile.getChangedValue(id, propertyName);
            if (!ValueHandle.valueEquals(oldHandle, newHandle)) {
                boolean wasModified;
                boolean bl = wasModified = !this.pendingChangedValues.isEmpty();
                if (pendingChangedValue != null) {
                    this.removePendingChangedValue(id, propertyName);
                }
                this.pendingChangedValues.add((Object)id, (Object)newHandle);
                this.propertyChangeSupport.firePropertyChange("modified", wasModified, this.isModified());
            }
        }
        LOG.trace("completed merging value {0}#{1} to {2} in {3}", (Object)id, (Object)propertyName, (Object)newHandle, (Object)this);
    }

    private ValueHandle getPendingChangedValue(String id, String propertyName) {
        this.preconditions();
        Collection changes = this.pendingChangedValues.get((Object)id);
        if (changes != null) {
            for (ValueHandle change : changes) {
                if (!propertyName.equals(change.getName())) continue;
                return change;
            }
        }
        return null;
    }

    private void removePendingChangedValue(String id, String propertyName) {
        this.preconditions();
        Collection changes = this.pendingChangedValues.get((Object)id);
        if (changes != null) {
            Iterator iterator = changes.iterator();
            while (iterator.hasNext()) {
                ValueHandle change = (ValueHandle)iterator.next();
                if (!propertyName.equals(change.getName())) continue;
                iterator.remove();
                if (!changes.isEmpty()) break;
                this.pendingChangedValues.remove((Object)id);
                break;
            }
        }
    }

    @Override
    public MultiMap<String, ValueHandle> getPendingChangedValues() {
        return this.pendingChangedValues;
    }

    @Override
    public ExtensionBean getBean(String id, boolean force) {
        BeanDefinition definition = this.getDefinition(id);
        if (definition == null) {
            return null;
        }
        ExtensionBean bean = this.beans.get(id);
        if (bean != null) {
            return bean;
        }
        bean = this.profile.createBean(definition, force, this.beans);
        if (bean == null) {
            return null;
        }
        Collection changes = this.pendingChangedValues.get((Object)id);
        if (changes != null) {
            for (ValueHandle change : changes) {
                String propertyName = change.getName();
                try {
                    try {
                        Object value = change.getValueForProperty(bean);
                        Beans.setPropertyValue(bean, propertyName, value);
                    }
                    catch (IntrospectionException e) {
                        AuditLogger.log(Level.SEVERE, e.getCause(), "Introspecting property \"{0}\" of {1} failed: {2}", propertyName, definition, e);
                    }
                    catch (IllegalAccessException e) {
                        AuditLogger.log(Level.SEVERE, e, "Property \"{0}\" of {1} not accessible: {2}", propertyName, definition, e);
                    }
                    catch (InvocationTargetException e) {
                        AuditLogger.log(Level.SEVERE, e.getCause(), "Setting property \"{0}\" of {1} failed: {2}", propertyName, definition, e.getCause());
                    }
                }
                catch (Exception e) {
                    AuditLogger.log(Level.SEVERE, e, "Value {0} for property \"{1}\" of {2} not convertible: {3}", change, propertyName, definition, e);
                }
            }
        }
        bean.addPropertyChangeListener(this);
        return bean;
    }

    @Override
    public boolean isModified() {
        this.preconditions();
        return this.sealed != this.profile.isSealed() || !this.pendingChangedValues.isEmpty();
    }

    @Override
    public boolean isModified(String id) {
        return this.pendingChangedValues.containsKey((Object)id);
    }

    @Override
    public void apply() {
        LOG.trace("applying {0}", (Object)this);
        boolean wasModified = this.isModified();
        if (wasModified) {
            this.profile.applyChanges(this);
            this.pendingChangedValues.clear();
            assert (this.sealed == this.profile.isSealed());
        }
        this.propertyChangeSupport.firePropertyChange("modified", wasModified, this.isModified());
        LOG.trace("completed applying {0}", (Object)this);
    }

    @Override
    public void revert() {
        LOG.trace("reverting {0}", (Object)this);
        this.preconditions();
        this.setProperties(this.profile);
        assert (this.sealed == this.profile.isSealed());
        assert (this.pendingChangedValues.isEmpty());
        LOG.trace("completed reverting {0}", (Object)this);
    }

    @Override
    public Profile createProfile(String name) {
        LOG.trace("copying {0}", (Object)this);
        return new DefaultProfile(this.profile.getFactory(), name, this.sealed, this.profile.getChangedValues(), this.pendingChangedValues);
    }

    @Override
    public void setProperties(Profile profile) {
        LOG.trace("setting properties of {0} from {1}", (Object)this, (Object)profile);
        this.sealed = profile.isSealed();
        this.resetProperties(profile.getChangedValues());
        LOG.trace("completed setting properties of {0} from {1}", (Object)this, (Object)profile);
    }

    @Override
    public void setProperties(Profile profile, String id) {
        LOG.trace("setting properties of {0} from {1}, bean {2}", (Object)this, (Object)profile, (Object)id);
        for (ValueHandle handle : profile.getChangedValues(id)) {
            this.mergeValue(id, handle.getName(), handle);
        }
        LOG.trace("completed setting properties of {0} from {1}", (Object)this, (Object)profile);
    }

    private void resetProperties(MultiMap<String, ValueHandle> ... newValues) {
        LinkedHashMap<Tuple, ValueHandle> merge = new LinkedHashMap<Tuple, ValueHandle>();
        MultiMap changedValues = new MultiMap();
        changedValues.putAll(this.pendingChangedValues);
        changedValues.putAll(this.profile.getChangedValues());
        for (Map.Entry entry : changedValues.entrySet()) {
            String id = (String)entry.getKey();
            for (ValueHandle change : (Collection)entry.getValue()) {
                String name = change.getName();
                merge.put(new Tuple((Object)id, (Object)name), new ValueHandle(name, DEFAULT_VALUE, null));
            }
        }
        for (MultiMap<String, ValueHandle> map : newValues) {
            for (Map.Entry entry : map.entrySet()) {
                for (ValueHandle change : (Collection)entry.getValue()) {
                    merge.put(new Tuple(entry.getKey(), (Object)change.getName()), change);
                }
            }
        }
        for (Map.Entry entry : merge.entrySet()) {
            this.mergeValue((String)((Tuple)entry.getKey()).object1(), (String)((Tuple)entry.getKey()).object2(), (ValueHandle)entry.getValue());
        }
    }

    private static Collection<ValueHandle> filtered(Map<Tuple<String, String>, ValueHandle> map, String key) {
        ArrayList<ValueHandle> handles = new ArrayList<ValueHandle>();
        for (Map.Entry<Tuple<String, String>, ValueHandle> entry : map.entrySet()) {
            Tuple<String, String> tuple = entry.getKey();
            if (!key.equals(tuple.object1())) continue;
            handles.add(entry.getValue());
        }
        return handles;
    }

    @Override
    public void setProperties(ProfileTransaction thatTransaction) {
        LOG.trace("setting properties of {0} from {1}", (Object)this, (Object)thatTransaction);
        this.preconditions();
        if (thatTransaction == this) {
            throw new IllegalArgumentException("transaction = this");
        }
        this.resetProperties(thatTransaction.getProfile().getChangedValues(), thatTransaction.getPendingChangedValues());
        LOG.trace("completed setting properties of {0} from {1}", (Object)this, (Object)thatTransaction);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        ExtensionBean bean = (ExtensionBean)event.getSource();
        String id = bean.id();
        String propertyName = event.getPropertyName();
        Object oldValue = event.getOldValue();
        Object newValue = event.getNewValue();
        LOG.trace("handling property '{0}:{1}' in {2} changed from '{3}' to '{4}'", (Object)id, (Object)propertyName, (Object)this, oldValue, newValue);
        if (bean != this.getBean(id, false)) {
            throw new IllegalArgumentException("changed bean not in transaction");
        }
        if (oldValue == newValue) {
            return;
        }
        try {
            PropertyDescriptor property = Beans.getPropertyDescriptor(bean, propertyName);
            if (property != null) {
                this.mergePropertyChange(id, bean, propertyName, oldValue, newValue);
            } else {
                LOG.trace("ignoring unconventional property {0} change in bean {1}", (Object)propertyName, (Object)id);
            }
        }
        catch (Throwable e) {
            Log.error((String)"Exception introspecting changes for bean '{0}': {1}", (Object)id, (Object)e);
        }
    }

    public String toString() {
        return "transaction " + this.profile.getName() + " (" + this.pendingChangedValues.size() + ")";
    }
}

