/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.core;

import java.awt.Graphics;
import java.net.URL;
import java.util.List;
import javax.swing.Action;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.ProductInformation;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Project;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.util.Log;
import oracle.jdeveloper.audit.AbstractAuditAddin;
import oracle.jdeveloper.audit.AuditManager;
import oracle.jdevimpl.audit.core.Converters;
import oracle.jdevimpl.audit.core.CoreBundle;
import oracle.jdevimpl.audit.core.DefaultAuditManager;
import oracle.jdevimpl.audit.core.ExtensionBeanCustomizer;
import oracle.jdevimpl.audit.core.MetricCustomizer;
import oracle.jdevimpl.audit.core.ObjectCustomizer;
import oracle.jdevimpl.audit.core.RuleCustomizer;
import oracle.jdevimpl.audit.resource.AuditARB;
import oracle.jdevimpl.audit.resource.profile.ProfileBundle;
import oracle.jdevimpl.audit.swing.MessageDialog;

public class AuditAddin
extends AbstractAuditAddin {
    @Override
    public void initialize() {
        AuditManager.setAuditManager(new DefaultAuditManager());
        Converters.register();
        super.initialize();
    }

    @Override
    public void initializeAlways() {
        Log.addFormatter(Workspace.class, null);
        Log.addFormatter(Project.class, null);
        Log.addFormatter(Element.class, (Log.Formatter)new ElementFormatter());
        Log.addFormatter(Action.class, (Log.Formatter)new ActionFormatter());
        Log.addFormatter(Context.class, (Log.Formatter)new ContextFormatter());
        Log.addFormatter(ElementAttributes.class, (Log.Formatter)new ElementAttributesFormatter());
        Log.addFormatter(Graphics.class, (Log.Formatter)new GraphicsFormatter());
        Log.addFormatter(ReadTextBuffer.class, (Log.Formatter)new TextBufferFormatter());
        Log.addFormatter(UpdateMessage.class, (Log.Formatter)new UpdateMessageFormatter());
    }

    @Override
    public void initializeUI() {
        try {
            Class.forName("javax.el.ELContext");
        }
        catch (Throwable t) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    String productName = ProductInformation.getProductInformation().getShortName();
                    String message = CoreBundle.format("bad.install.message", productName);
                    String title = CoreBundle.get("bad.install.title");
                    MessageDialog dialog = new MessageDialog(MessageDialog.ERROR);
                    dialog.addContent(message);
                    dialog.setTitle(title);
                    dialog.setCommands(CoreBundle.format("bad.install.button.label", productName));
                    dialog.show();
                    Ide.quit();
                }
            };
            ExtensionRegistry.getExtensionRegistry().invokeAfterExtensionLoading(runnable, true);
        }
    }

    @Override
    public URL[] getStyleSheets() {
        return new URL[]{AuditARB.class.getResource("audit-text.xsl"), AuditARB.class.getResource("audit-html.xsl"), AuditARB.class.getResource("metrics-text.xsl"), AuditARB.class.getResource("metrics-html.xsl")};
    }

    @Override
    public URL[] getProfileStyleSheets() {
        return new URL[]{ProfileBundle.class.getResource("profile-text.xsl"), ProfileBundle.class.getResource("profile-html.xsl")};
    }

    @Override
    public Class[] getBeanCustomizers() {
        return new Class[]{ObjectCustomizer.class, ExtensionBeanCustomizer.class, RuleCustomizer.class, MetricCustomizer.class};
    }

    private static class UpdateMessageFormatter
    implements Log.Formatter {
        private UpdateMessageFormatter() {
        }

        public void append(StringBuffer buffer, Object object) {
            UpdateMessage message = (UpdateMessage)object;
            buffer.append('{');
            buffer.append(message);
            buffer.append(',');
            boolean successor = UpdateMessageFormatter.appendNotEmpty(buffer, "added", message.getAddObjects());
            if (successor) {
                buffer.append(',');
            }
            if (successor = UpdateMessageFormatter.appendNotEmpty(buffer, "removed", message.getRemoveObjects())) {
                buffer.append(',');
            }
            UpdateMessageFormatter.appendNotEmpty(buffer, "modified", message.getModifyObjects());
            buffer.append('}');
        }

        private static boolean appendNotEmpty(StringBuffer buffer, String name, List list) {
            if (list == null || list.isEmpty()) {
                return false;
            }
            buffer.append(name);
            Log.append((StringBuffer)buffer, (Object)list);
            return true;
        }
    }

    private static class TextBufferFormatter
    implements Log.Formatter {
        private TextBufferFormatter() {
        }

        public void append(StringBuffer buffer, Object object) {
            buffer.append('{');
            buffer.append("TextBuffer ");
            TextBuffer textBuffer = (TextBuffer)object;
            buffer.append("length ");
            buffer.append(textBuffer.getLength());
            buffer.append(", modified ");
            buffer.append(textBuffer.isModified());
            buffer.append(", id ");
            buffer.append(textBuffer.getChangeId());
            buffer.append('}');
        }
    }

    private static class GraphicsFormatter
    implements Log.Formatter {
        private GraphicsFormatter() {
        }

        public void append(StringBuffer buffer, Object object) {
            buffer.append('{');
            buffer.append("Graphics ");
            buffer.append(((Graphics)object).getClipBounds());
            buffer.append('}');
        }
    }

    private static class ElementAttributesFormatter
    implements Log.Formatter {
        private ElementAttributesFormatter() {
        }

        public void append(StringBuffer buffer, Object object) {
            buffer.append("ElementAttributes(");
            ElementAttributes attributes = (ElementAttributes)object;
            if (!attributes.isSet(ElementAttributes.ACTIVE)) {
                buffer.append('!');
            }
            buffer.append("ACTIVE,");
            if (!attributes.isSet(ElementAttributes.DIRTY)) {
                buffer.append('!');
            }
            buffer.append("DIRTY,");
            if (!attributes.isSet(ElementAttributes.READ_ONLY)) {
                buffer.append('!');
            }
            buffer.append("READ_ONLY)");
        }
    }

    private static class ContextFormatter
    implements Log.Formatter {
        private ContextFormatter() {
        }

        public void append(StringBuffer buffer, Object object) {
            buffer.append('{');
            Context context = (Context)object;
            buffer.append(context);
            buffer.append(", node ");
            Log.append((StringBuffer)buffer, (Object)context.getNode());
            buffer.append(", selection ");
            Log.append((StringBuffer)buffer, (Object)context.getSelection());
            buffer.append(", project ");
            buffer.append(context.getProject());
            buffer.append(", workspace ");
            buffer.append(context.getWorkspace());
            buffer.append(", view ");
            buffer.append(context.getView());
            buffer.append('}');
        }
    }

    private static class ActionFormatter
    implements Log.Formatter {
        private ActionFormatter() {
        }

        public void append(StringBuffer buffer, Object object) {
            buffer.append('{');
            Action action = (Action)object;
            buffer.append(action);
            buffer.append(", name ");
            buffer.append(action.getValue("Name"));
            buffer.append(", enabled ");
            buffer.append(action.isEnabled());
            buffer.append('}');
        }
    }

    private static class ElementFormatter
    implements Log.Formatter {
        private ElementFormatter() {
        }

        public void append(StringBuffer buffer, Object object) {
            buffer.append('{');
            Element element = (Element)object;
            buffer.append(element.getClass().getName());
            buffer.append(" \"");
            buffer.append(element.getShortLabel());
            buffer.append("\"");
            buffer.append('}');
        }
    }
}

