/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.audit.bean;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import oracle.jdeveloper.audit.bean.PropertyField;
import oracle.jdevimpl.audit.swing.WhitespaceDecoratorIcon;

public class ActionLabelField
extends PropertyField
implements MouseListener {
    private final JPanel component;
    private final JTextArea textArea;
    private final ActionListener listener;

    public ActionLabelField(Icon actionIcon, ActionListener listener) {
        this.listener = listener;
        this.textArea = new JTextArea(null, null, 1, 0);
        this.textArea.setLineWrap(false);
        this.textArea.setWrapStyleWord(false);
        this.textArea.setEnabled(false);
        this.textArea.setEditable(false);
        this.textArea.setOpaque(false);
        this.textArea.setFont(UIManager.getFont("Label.font"));
        this.textArea.setForeground(UIManager.getColor("Label.foreground"));
        this.textArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        this.textArea.setBackground(UIManager.getColor("Label.background"));
        this.textArea.setBorder(UIManager.getBorder("Label.border"));
        JButton button = new JButton(new WhitespaceDecoratorIcon(actionIcon, -2, 0, -2, 0));
        button.setMargin(new Insets(0, 0, 0, 0));
        button.setBorder(BorderFactory.createEmptyBorder());
        button.addActionListener(listener);
        this.component = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridy = 0;
        constraints.anchor = 18;
        this.component.add((Component)this.textArea, constraints);
        constraints.insets.left = 5;
        this.component.add((Component)button, constraints);
        constraints.insets.left = 0;
        constraints.weightx = 1.0;
        this.component.add(Box.createHorizontalGlue(), constraints);
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public Object getValue() throws Exception {
        return this.textArea.getText();
    }

    @Override
    public void setValue(Object value) {
        this.textArea.setText((String)value);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " " + this.textArea.getText();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.isControlDown()) {
            this.listener.actionPerformed(new ActionEvent(this, 1001, "Control-Action"));
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

